/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

public class SetParameterPolicy
extends CommandListener
implements IShowCommand,
IStoreCommand {
    String[] aliases = new String[]{"parameterpolicy"};

    @Override
    public String[] getShowAliases() {
        return this.aliases;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx != null && ctx.getProperty("sqlcl.parameterpolicy") != null && Boolean.parseBoolean(ctx.getProperty("sqlcl.parameterpolicy").toString())) {
            ctx.write("parameterpolicy ISOLATE\n");
        } else if (ctx != null && ctx.getProperty("sqlcl.parameterpolicy") != null && !Boolean.parseBoolean(ctx.getProperty("sqlcl.parameterpolicy").toString())) {
            ctx.write("parameterpolicy SHARE\n");
        } else {
            ctx.write("parameterpolicy SHARE\n");
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    @Override
    @Restricted(level=Restricted.Level.NONE)
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] thesplit;
        if (cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_SET_PARAMETERPOLICY && (thesplit = cmd.getLoweredTrimmedSQL().split("\\s+")).length == 3 && thesplit[1].equals(this.aliases[0]) && thesplit[0].equals("set")) {
            if (thesplit.length == 3 && (thesplit[2].toLowerCase().equals("isolate") || thesplit[2].toLowerCase().equals("share"))) {
                if (thesplit[2].toLowerCase().equals("isolate")) {
                    ctx.putProperty("sqlcl.parameterpolicy", Boolean.TRUE);
                } else {
                    ctx.putProperty("sqlcl.parameterpolicy", Boolean.FALSE);
                }
            } else {
                ctx.write(Messages.getString("PARAMETERPOLICYERROR"));
            }
            return true;
        }
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if ((cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_AT || cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_ATNESTED || cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_START) && ctx != null && ctx.getProperty("sqlcl.parameterpolicy") != null && Boolean.parseBoolean(ctx.getProperty("sqlcl.parameterpolicy").toString())) {
            Map<String, String> ctxHashMap = ctx.getMap();
            HashMap<String, String> toRestore = new HashMap<String, String>();
            for (String key : ctxHashMap.keySet()) {
                try {
                    int i = Integer.parseInt(key);
                    if (i <= 0) continue;
                    toRestore.put(key, ctxHashMap.get(key));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            cmd.setProperty("prop_parameterpolicy", toRestore);
            for (String key : toRestore.keySet()) {
                ctxHashMap.remove(key);
            }
        }
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if ((cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_AT || cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_ATNESTED || cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_START) && ctx != null && ctx.getProperty("sqlcl.parameterpolicy") != null && Boolean.parseBoolean(ctx.getProperty("sqlcl.parameterpolicy").toString())) {
            Map<String, String> ctxHashMap = ctx.getMap();
            ArrayList<String> toDelete = new ArrayList<String>();
            for (String key : ctxHashMap.keySet()) {
                try {
                    int i = Integer.parseInt(key);
                    if (i <= 0) continue;
                    toDelete.add(key);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            for (String key : toDelete) {
                ctxHashMap.remove(key);
            }
            HashMap toRestore = (HashMap)cmd.getProperty("prop_parameterpolicy");
            if (toRestore != null) {
                ctxHashMap.putAll(toRestore);
            }
        }
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        if (ctx != null && ctx.getProperty("sqlcl.parameterpolicy") != null && Boolean.parseBoolean(ctx.getProperty("sqlcl.parameterpolicy").toString())) {
            return StoreRegistry.getCommand("parameterpolicy", "isolate");
        }
        return StoreRegistry.getCommand("parameterpolicy", "share");
    }
}

