/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Locale;
import oracle.dbtools.data.loadservice.LoadParmsAPI;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetLoadMethod
extends CommandListener
implements IShowCommand {
    private static final String INSERT = "insert";
    private static final String METHOD = "method";
    private static final String BATCH_ROWS = "batch_rows";
    private static final String BATCHES_PER_COMMIT = "batches_per_commit";
    private static final String DO_COMMIT = "do_commit";
    private static final String FORMAT_DATE = "format_date";
    private static final String FORMAT_TIMESTAMP = "format_timestamp";
    private static final String FORMAT_TIMESTAMPTZ = "format_timestamptz";
    private static final String ERRORS = "errors";
    private static final String LOCALE = "locale";
    private static final String MAP_COLUMN_NAMES = "map_column_names";
    private static final String RESPONSE_FORMAT = "response_format";
    private static final String RESPONSE_LOCALES = "response_locales";
    private static final String TRUNCATE = "do_truncate";
    private static final String UNKNOWN_COLUMNS_FAIL = "unknown_columns_fail";
    private static final String DEFAULT = "default";
    private static final String DQUOTE = "\"";
    private static final String ON = "on";
    private static final String OFF = "off";
    private static final String NL = "\n";
    private static final String SPACE = " ";
    private static final String SQUOTE = "'";

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setloadmethod")) {
            String line;
            String[] parts = cmd.getSQLOrig().split(SPACE);
            if (parts.length < 3 || parts.length == 3 && parts[2].equalsIgnoreCase(DEFAULT)) {
                ctx.write(Messages.getString("LOADMETHODCLEARED"));
                ctx.putProperty("load.method", null);
                return true;
            }
            LoadParmsAPI.Builder loadParmsBuilder = (LoadParmsAPI.Builder)ctx.getProperty("load.method");
            if (loadParmsBuilder == null) {
                loadParmsBuilder = new LoadParmsAPI.Builder(LoadParmsAPI.SERVICE_METHOD.JDBC_BATCH);
                loadParmsBuilder.doCommit(true);
            }
            String[] bits = this.split((line = (String)cmd.getProperty("ORIG_LINE")) != null ? line : cmd.getSQLOrig());
            int skip = 2;
            while (bits != null && bits.length > 0) {
                Object fmt = "";
                int i = skip;
                try {
                    switch (bits[skip].toLowerCase()) {
                        case "insert": {
                            ctx.putProperty("load.method", loadParmsBuilder);
                            bits = this.nextBits(bits, skip + 1);
                            break;
                        }
                        case "batch_rows": {
                            if (bits.length < skip + 2) {
                                this.writeMethodBad(ctx, bits[skip]);
                                return false;
                            }
                            loadParmsBuilder.batchRows(new Integer(bits[skip + 1]));
                            ctx.putProperty("load.method", loadParmsBuilder);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "batches_per_commit": {
                            if (bits.length < skip + 2) {
                                this.writeMethodBad(ctx, bits[skip]);
                                return false;
                            }
                            int batches = new Integer(bits[skip + 1]);
                            loadParmsBuilder.batchesPerCommit(batches);
                            loadParmsBuilder.doCommit(batches > 0);
                            ctx.putProperty("load.method", loadParmsBuilder);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "format_date": {
                            if (bits.length < skip + 2) {
                                this.writeMethodBad(ctx, bits[2]);
                                return false;
                            }
                            ++i;
                            String space = "";
                            while (i < bits.length && !this.isOption(bits[i])) {
                                fmt = (String)fmt + space + bits[i];
                                space = SPACE;
                                ++i;
                            }
                            loadParmsBuilder.dateFormat(this.unQuote((String)fmt));
                            ctx.putProperty("load.method", loadParmsBuilder);
                            bits = this.nextBits(bits, i);
                            break;
                        }
                        case "format_timestamp": {
                            if (bits.length < skip + 2) {
                                this.writeMethodBad(ctx, bits[2]);
                                return false;
                            }
                            ++i;
                            String space = "";
                            while (i < bits.length && !this.isOption(bits[i])) {
                                fmt = (String)fmt + space + bits[i];
                                space = SPACE;
                                ++i;
                            }
                            loadParmsBuilder.timestampFormat(this.unQuote((String)fmt));
                            ctx.putProperty("load.method", loadParmsBuilder);
                            bits = this.nextBits(bits, i);
                            break;
                        }
                        case "format_timestamptz": {
                            if (bits.length < skip + 2) {
                                this.writeMethodBad(ctx, bits[2]);
                                return false;
                            }
                            ++i;
                            String space = "";
                            while (i < bits.length && !this.isOption(bits[i])) {
                                fmt = (String)fmt + space + bits[i];
                                space = SPACE;
                                ++i;
                            }
                            loadParmsBuilder.timestampTZFormat(this.unQuote((String)fmt));
                            ctx.putProperty("load.method", loadParmsBuilder);
                            bits = this.nextBits(bits, i);
                            break;
                        }
                        case "do_commit": {
                            if (bits.length < skip + 2) {
                                this.writeMethodBad(ctx, bits[skip]);
                                return false;
                            }
                            if (!bits[skip + 1].equalsIgnoreCase(ON) && !bits[skip + 1].equalsIgnoreCase(OFF)) {
                                this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return false;
                            }
                            loadParmsBuilder.doCommit(bits[skip + 1].equalsIgnoreCase(ON));
                            ctx.putProperty("load.method", loadParmsBuilder);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "errors": {
                            if (bits.length < skip + 2) {
                                this.writeMethodBad(ctx, bits[skip]);
                                return false;
                            }
                            loadParmsBuilder.errors(new Integer(bits[skip + 1]));
                            ctx.putProperty("load.method", loadParmsBuilder);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "locale": {
                            Locale locale = null;
                            if (bits.length < skip + 2) {
                                this.writeMethodBad(ctx, bits[skip]);
                                return false;
                            }
                            if (bits.length == skip + 3) {
                                locale = new Locale(bits[skip + 1], bits[skip + 2]);
                                bits = this.nextBits(bits, skip + 3);
                            } else {
                                locale = new Locale(bits[skip + 1]);
                                bits = this.nextBits(bits, skip + 2);
                            }
                            loadParmsBuilder.locale(locale);
                            ctx.putProperty("load.method", loadParmsBuilder);
                            break;
                        }
                        case "map_column_names": 
                        case "response_format": {
                            break;
                        }
                        case "response_locales": {
                            break;
                        }
                        case "do_truncate": {
                            if (bits.length < skip + 2) {
                                this.writeMethodBad(ctx, bits[skip]);
                                return false;
                            }
                            if (!bits[skip + 1].equalsIgnoreCase(ON) && !bits[skip + 1].equalsIgnoreCase(OFF)) {
                                this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return false;
                            }
                            loadParmsBuilder.deleteRows(bits[skip + 1].equalsIgnoreCase(ON) ? LoadParmsAPI.DELETE_ROWS.TRUE : LoadParmsAPI.DELETE_ROWS.FALSE);
                            ctx.putProperty("load.method", loadParmsBuilder);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "unknown_columns_fail": {
                            if (bits.length < skip + 2) {
                                this.writeMethodBad(ctx, bits[skip]);
                                return false;
                            }
                            if (!bits[skip + 1].equalsIgnoreCase(ON) && !bits[skip + 1].equalsIgnoreCase(OFF)) {
                                this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return false;
                            }
                            loadParmsBuilder.unknownColumnsFail(bits[skip + 1].equalsIgnoreCase(ON));
                            ctx.putProperty("load.method", loadParmsBuilder);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        default: {
                            ctx.write(Messages.getString("LOADMETHOD") + SPACE + bits[skip].toLowerCase());
                            return false;
                        }
                    }
                }
                catch (Exception e) {
                    this.writeMethodBad(ctx, bits.length > 0 ? bits[skip] : "");
                    return false;
                }
                skip = 0;
            }
            return true;
        }
        return false;
    }

    private String[] split(String cmd) {
        if (!cmd.contains(SQUOTE) && !cmd.contains(DQUOTE)) {
            return cmd.split("\\s+");
        }
        String c = null;
        Object word = "";
        ArrayList<Object> words = new ArrayList<Object>();
        for (int i = 0; i < cmd.length(); ++i) {
            int end;
            word = "";
            c = cmd.substring(i, i + 1);
            if (c.equals(DQUOTE) && i + 1 < cmd.length()) {
                end = cmd.indexOf(DQUOTE, i + 1);
                if (end != -1) {
                    words.add(cmd.substring(i, end + 1));
                    i = end + 1;
                    continue;
                }
                word = (String)word + c;
                while (++i < cmd.length() && !cmd.substring(i, i + 1).equals(SPACE)) {
                    word = (String)word + cmd.substring(i, i + 1);
                }
                words.add(word);
                continue;
            }
            if (c.equals(SQUOTE) && i + 1 < cmd.length()) {
                end = cmd.indexOf(SQUOTE, i + 1);
                if (end != -1) {
                    words.add(cmd.substring(i, end + 1));
                    i = end + 1;
                    continue;
                }
                word = (String)word + c;
                while (++i < cmd.length() && !cmd.substring(i, i + 1).equals(SPACE)) {
                    word = (String)word + cmd.substring(i, i + 1);
                }
                words.add(word);
                continue;
            }
            if (c.equals(SPACE)) continue;
            word = (String)word + c;
            while (++i < cmd.length() && !cmd.substring(i, i + 1).equals(SPACE)) {
                word = (String)word + cmd.substring(i, i + 1);
            }
            words.add(word);
        }
        return words.toArray(new String[words.size()]);
    }

    private void writeMethodBad(ScriptRunnerContext ctx, String option) {
        ctx.write(Messages.getString("LOADMETHOD") + SPACE + option + NL);
    }

    private boolean isOption(String word) {
        try {
            switch (word) {
                case "insert": 
                case "batch_rows": 
                case "batches_per_commit": 
                case "format_date": 
                case "do_commit": 
                case "errors": 
                case "locale": 
                case "map_column_names": 
                case "response_format": 
                case "response_locales": 
                case "format_timestamp": 
                case "format_timestamptz": 
                case "do_truncate": 
                case "unknown_columns_fail": {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String unQuote(String word) {
        if (word.startsWith(SQUOTE) && word.endsWith(SQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        if (word.startsWith(DQUOTE) && word.endsWith(DQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        return word;
    }

    private String[] nextBits(String[] bits, int skip) {
        if (bits.length > skip) {
            String[] rtn = new String[bits.length - skip];
            for (int j = 0; rtn.length > j; ++j) {
                rtn[j] = bits[j + skip];
            }
            return rtn;
        }
        return null;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("showloadmethod")) {
            LoadParmsAPI.Builder loadParmsBuilder = null;
            if (ctx.getProperties().containsKey("load.method") && ctx.getProperties().get("load.method") != null) {
                loadParmsBuilder = (LoadParmsAPI.Builder)ctx.getProperty("load.method");
            } else {
                ctx.write("default\n");
                loadParmsBuilder = new LoadParmsAPI.Builder(LoadParmsAPI.SERVICE_METHOD.JDBC_BATCH);
            }
            LoadParmsAPI loadParms = loadParmsBuilder.build();
            SetLoadMethod.showParms(ctx, loadParms);
            return true;
        }
        return false;
    }

    public static void showParms(ScriptRunnerContext ctx, LoadParmsAPI loadParms) {
        Object method = "\nmethod insert\n";
        method = (String)method + "batch_rows " + new Integer(loadParms.getBatchRows()).toString() + NL;
        method = (String)method + "batches_per_commit " + new Integer(loadParms.getBatchesPerCommit()).toString() + NL;
        method = (String)method + "do_commit " + (loadParms.isDoCommit() ? ON : OFF) + NL;
        method = (String)method + "errors " + new Integer(loadParms.getErrorsLimit()).toString() + NL;
        method = (String)method + "format_date " + loadParms.getDataFormat() + NL;
        method = (String)method + "format_timestamp " + loadParms.getTimestampFormat() + NL;
        method = (String)method + "format_timestamptz " + loadParms.getTimestampTZFormat() + NL;
        if (loadParms.getLocale() != null) {
            method = (String)method + "locale " + loadParms.getLocale().getDisplayName() + NL;
        }
        method = (String)method + "do_truncate " + (loadParms.getDeleteRows() == LoadParmsAPI.DELETE_ROWS.TRUE ? ON : OFF) + NL;
        ctx.write((String)method);
        ctx.write("");
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"loadmethod"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }
}

