/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.jdbc.OracleConnection;

public class SetCopyCommit
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_COPYCOMMIT;

    public SetCopyCommit() {
        super(m_cmdStmtSubType);
    }

    @Override
    public boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String input = (String)cmd.getProperty("prop_file_string");
        if (input != null && (conn == null || conn instanceof OracleConnection)) {
            try {
                Integer valueInt = Integer.parseInt(input);
                if (valueInt > -1 && valueInt < 5001) {
                    this.setProperties(cmd, ctx, ctx.getProperty("script.runner.copycommit").toString(), "copycommit", "script.runner.copycommit");
                    this.writeShowMode(cmd, ctx, valueInt.toString());
                    ctx.putProperty("script.runner.copycommit", valueInt.toString());
                } else {
                    ctx.write(MessageFormat.format(Messages.getString("COPY_ARRAY_RANGE"), valueInt.toString()) + "\n");
                }
            }
            catch (NumberFormatException e) {
                ctx.write(Messages.getString("ARRAY_NUMBER_FORMAT_EXCEPTION") + "\n");
            }
            return true;
        }
        return false;
    }
}

