/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetConcat
extends AForAllStmtsCommand {
    private static final String CONCAT = "set con";
    private static final String CONCAT_ON = "on";
    private static final String CONCAT_OFF = "off";
    private static final String[] aliases = new String[]{"concat", "conca", "conc", "con"};
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_CONCAT;

    public SetConcat() {
        super(m_cmdStmtSubType);
    }

    @Override
    public boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String sql = cmd.getSql().trim().toLowerCase();
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        if ((sql.startsWith("set con ") || sql.startsWith("set conc ") || sql.startsWith("set conca ") || sql.startsWith("set concat ")) && !sql.substring(sql.lastIndexOf(" ")).trim().equals(CONCAT_OFF)) {
            Character escapeChar;
            String toggle = sql.substring(sql.lastIndexOf(" ")).trim();
            if (sql.replaceFirst("set con[^\\s]*", "").trim().equals("")) {
                ctx.write(Messages.getString("NO_ESCAPE_VAL"));
                return true;
            }
            if (!toggle.equals(CONCAT_ON)) {
                String checkValue = this.validString(toggle, ctx);
                if (checkValue == null) {
                    return true;
                }
                escapeChar = Character.valueOf(checkValue.charAt(0));
            } else {
                escapeChar = Character.valueOf('.');
            }
            this.showModeForConcat(ctx, cmd, CONCAT_ON, escapeChar);
            ctx.setSubstitutionTerminateChar(escapeChar);
            return true;
        }
        if (sql.startsWith(CONCAT)) {
            this.showModeForConcat(ctx, cmd, CONCAT_OFF, null);
            ctx.setSubstitutionTerminateChar(null);
            return true;
        }
        return false;
    }

    public String validString(String toTestIn, ScriptRunnerContext ctx) {
        String toTest = toTestIn;
        if (toTest == null || toTest.equals("")) {
            ctx.write(Messages.getString("NO_ESCAPE_VAL"));
            return null;
        }
        if (toTest.equals("\"\"\"\"") || toTest.equals("'\"'")) {
            return "\"";
        }
        if (toTest.equals("''''") || toTest.equals("\"'\"")) {
            return "'";
        }
        if ((toTest = this.removeQuotesString(toTest)).length() > 1) {
            ctx.write(MessageFormat.format(Messages.getString("ONE_CHARACTER"), toTest));
            return null;
        }
        if (toTest.equals("") || toTest.equals("\"") || toTest.equals("'")) {
            ctx.write(Messages.getString("INVALID_ESCAPE"));
            return null;
        }
        if (toTest.matches("^\\s") || toTest.matches("^\\w") && !toTest.startsWith("_") || toTest.matches("^\\d")) {
            ctx.write(Messages.getString("NOT_ALHA_OR_WHITE"));
            return null;
        }
        return toTest.substring(0, 1);
    }

    public String removeQuotesString(String toBeStripped) {
        if (toBeStripped.startsWith("'") && toBeStripped.endsWith("'") && toBeStripped.length() >= 2) {
            return toBeStripped.substring(1, toBeStripped.length() - 1);
        }
        if (toBeStripped.startsWith("\"") && toBeStripped.endsWith("\"") && toBeStripped.length() >= 2) {
            return toBeStripped.substring(1, toBeStripped.length() - 1);
        }
        return toBeStripped;
    }

    private void showModeForConcat(ScriptRunnerContext ctx, ISQLCommand cmd, String onoff, Character newConcatchar) {
        Object btermin = null;
        Object termin = null;
        btermin = ctx.getSubstitutionTerminateChar() != null ? "\"" + ctx.getSubstitutionTerminateChar() + "\" (hex " + String.format("%02x", ctx.getSubstitutionTerminateChar().charValue()) + ")" : "OFF";
        this.setProperties(cmd, ctx, (String)btermin, "concat", "concat");
        if (newConcatchar != null) {
            if (onoff.equalsIgnoreCase(CONCAT_ON)) {
                termin = "\"" + newConcatchar + "\" (hex " + String.format("%02x", newConcatchar.charValue()) + ")";
            } else if (onoff.equalsIgnoreCase(CONCAT_OFF)) {
                termin = "OFF";
            }
        } else if (onoff.equalsIgnoreCase(CONCAT_ON)) {
            termin = "\".\" (hex " + String.format("%02x", 46) + ")";
        } else if (onoff.equalsIgnoreCase(CONCAT_OFF)) {
            termin = "OFF";
        }
        this.writeShowMode(cmd, ctx, (String)termin);
    }
}

