/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.NONE)
public class SetColInvisble
extends CommandListener
implements IShowCommand,
IStoreCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_COLINVISIBLE;
    private static final String[] m_aliases = new String[]{"colinvi", "colinvisible"};
    private static final String OFF = "OFF";

    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("prop_file_string") != null) {
            String str = cmd.getSql();
            if ((str = str.trim().replaceAll("^(?i:set\\s+[colinv|colinvisible])[^\\s]*\\s+", "").trim()).startsWith("\"") && str.endsWith("\"") && str.length() > 1) {
                str = str.substring(1, str.length() - 1);
            } else if (str.startsWith("'") && str.endsWith("'") && str.length() > 1) {
                str = str.substring(1, str.length() - 1);
            }
            if (str.matches("(?i:on)")) {
                ctx.putProperty("sqlcl.set.colinvisible", Boolean.TRUE);
            }
            if (str.matches("(?i:off)")) {
                ctx.putProperty("sqlcl.set.colinvisible", Boolean.FALSE);
            }
        }
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return m_aliases;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String onOff = OFF;
        if (((Boolean)ctx.getProperty("sqlcl.set.colinvisible")).booleanValue()) {
            onOff = "ON";
        }
        ctx.write(MessageFormat.format("colinvisible {0}\n", onOff));
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getStmtSubType() == m_cmdStmtSubType) {
            boolean isHandled = this.doHandleCmd(conn, ctx, cmd);
            return isHandled;
        }
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        String onOff = OFF;
        if (((Boolean)ctx.getProperty("sqlcl.set.colinvisible")).booleanValue()) {
            onOff = "ON";
        }
        return MessageFormat.format("set colinvisible {0}\n", onOff);
    }
}

