/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.CommonServices;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorTypeCache;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleConnector;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.NUMBER;

public class CopyCommand
extends CommandListener {
    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        CopyConnector connector = new CopyConnector(ctx, cmd);
        connector.copy(conn, ctx, cmd);
        return true;
    }

    private class CopyConnector
    extends OracleConnector {
        CopyConnector(ScriptRunnerContext ctx, ISQLCommand cmd) {
            super(ConnectorArgs.create(null, CommonServices.get(ConnectorTypeCache.class).getConnectionContext(ctx).getContextPropertyValues().createCopy(), ctx, cmd, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void copy(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
            boolean copySucceeded;
            String errorString;
            String[] stringArray;
            block355: {
                cmd.setSql(SQLPLUSUtil.removeDashNewline(cmd, cmd.getSql()));
                String mySQL = cmd.getSql().trim();
                String copyFrom = null;
                String copyTo = null;
                String toType = null;
                String destinationTable = null;
                String destColumns = null;
                String query = null;
                stringArray = SQLPLUSUtil.nextWordAndRest(mySQL);
                errorString = null;
                boolean useByte = false;
                int maxSrcCols = 0;
                copySucceeded = false;
                if (stringArray != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("COPY") && stringArray.length == 2 && stringArray[1] != null) {
                    if ((stringArray = SQLPLUSUtil.nextWordAndRest(stringArray[1].trim())) != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("FROM") && stringArray.length == 2 && stringArray[1] != null) {
                        if ((stringArray = SQLPLUSUtil.nextWordAndRest(stringArray[1].trim())) != null && stringArray[0] != null && stringArray.length == 2 && stringArray[1] != null) {
                            copyFrom = stringArray[0];
                            stringArray = SQLPLUSUtil.nextWordAndRest(stringArray[1].trim());
                        } else {
                            errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                        }
                    }
                    if (errorString == null && stringArray != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("TO") && stringArray.length == 2 && stringArray[1] != null) {
                        if ((stringArray = SQLPLUSUtil.nextWordAndRest(stringArray[1].trim())) != null && stringArray[0] != null && stringArray.length == 2 && stringArray[1] != null) {
                            copyTo = stringArray[0];
                            stringArray = SQLPLUSUtil.nextWordAndRest(stringArray[1].trim());
                        } else {
                            errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                        }
                    }
                    if (errorString == null && stringArray != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("FROM") && stringArray.length == 2 && stringArray[1] != null) {
                        if ((stringArray = SQLPLUSUtil.nextWordAndRest(stringArray[1].trim())) != null && stringArray[0] != null && stringArray.length == 2 && stringArray[1] != null) {
                            copyFrom = stringArray[0];
                            stringArray = SQLPLUSUtil.nextWordAndRest(stringArray[1].trim());
                        } else {
                            errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                        }
                    }
                    if (errorString == null && stringArray != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("TO") && stringArray.length == 2 && stringArray[1] != null) {
                        if ((stringArray = SQLPLUSUtil.nextWordAndRest(stringArray[1].trim())) != null && stringArray[0] != null && stringArray.length == 2 && stringArray[1] != null) {
                            copyTo = stringArray[0];
                            stringArray = SQLPLUSUtil.nextWordAndRest(stringArray[1].trim());
                        } else {
                            errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                        }
                    }
                    if (copyFrom != null && copyFrom.toLowerCase().contains("as sysdba")) {
                        ctx.write(ScriptRunnerDbArb.getString("COPY_ERR_SYSDBA"));
                        return;
                    }
                    if (errorString == null && stringArray != null && stringArray[0] != null && (stringArray[0].equalsIgnoreCase("APPEND") || stringArray[0].equalsIgnoreCase("APPEND_BYTE") || stringArray[0].equalsIgnoreCase("CREATE") || stringArray[0].equalsIgnoreCase("CREATE_BYTE") || stringArray[0].equalsIgnoreCase("INSERT") || stringArray[0].equalsIgnoreCase("REPLACE_BYTE") || stringArray[0].equalsIgnoreCase("REPLACE")) && stringArray.length == 2 && stringArray[1] != null) {
                        toType = stringArray[0].toUpperCase();
                        if (toType.equals("CREATE_BYTE")) {
                            useByte = true;
                            toType = "CREATE";
                        }
                        if (toType.equals("APPEND_BYTE")) {
                            useByte = true;
                            toType = "APPEND";
                        }
                        if (toType.equals("REPLACE_BYTE")) {
                            useByte = true;
                            toType = "REPLACE";
                        }
                    } else {
                        errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                    }
                    if (errorString == null && stringArray != null) {
                        stringArray = SQLPLUSUtil.nextWordAndRestOrString(stringArray[1].trim(), "(");
                    }
                    if (errorString == null && stringArray != null && stringArray[0] != null && stringArray.length == 2 && stringArray[1] != null) {
                        destinationTable = stringArray[0];
                        destinationTable = destinationTable.length() > 2 && destinationTable.startsWith("\"") && destinationTable.endsWith("\"") ? destinationTable.substring(1, destinationTable.length() - 1) : destinationTable.toUpperCase();
                    } else {
                        errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                    }
                    if (errorString == null && stringArray != null) {
                        String maybeBracketted = stringArray[1].trim();
                        if (maybeBracketted.startsWith("(") && maybeBracketted.indexOf(")") != -1) {
                            destColumns = maybeBracketted.substring(1, maybeBracketted.indexOf(")"));
                            try {
                                maybeBracketted = maybeBracketted.substring(maybeBracketted.indexOf(")") + 1);
                            }
                            catch (Exception e) {
                                errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                            }
                            maybeBracketted = maybeBracketted.trim();
                        }
                        if (errorString == null && stringArray != null) {
                            stringArray = SQLPLUSUtil.nextWordAndRest(maybeBracketted);
                        }
                        if (stringArray == null || stringArray == null || stringArray.length <= 0 || stringArray[0] == null || !stringArray[0].equalsIgnoreCase("USING")) {
                            ctx.write(ScriptRunnerDbArb.getString("COPY_USING_NOT_DESCRIBED"));
                            return;
                        }
                        if (errorString == null && stringArray != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("USING") && stringArray.length == 2 && stringArray[1] != null) {
                            query = stringArray[1];
                            ArrayList<String> destArray = new ArrayList<String>();
                            if (destColumns != null) {
                                String[] interrum;
                                for (String acol : interrum = destColumns.trim().split("\\s*,\\s*")) {
                                    String thisCol = null;
                                    thisCol = acol;
                                    thisCol = thisCol.length() > 2 && thisCol.startsWith("\"") && thisCol.endsWith("\"") ? thisCol.substring(1, thisCol.length() - 1) : thisCol.toUpperCase();
                                    destArray.add(thisCol);
                                }
                            }
                            Connection[] fromToConnection = new Connection[]{null, null};
                            String[] fromToString = new String[]{copyFrom, copyTo};
                            for (int i = 0; i < 2; ++i) {
                                String toCon;
                                if (errorString != null || fromToString[i] == null) continue;
                                boolean wasThirdParty = false;
                                String retVal = toCon = fromToString[i];
                                if (toCon != null && toCon.startsWith("\"") && toCon.endsWith("\"") && toCon.length() > 2) {
                                    String candidate = toCon.substring(1, toCon.length() - 1);
                                    int at = retVal.lastIndexOf("@");
                                    int space = retVal.indexOf(" ");
                                    if (!(candidate.indexOf("\"") != -1 || at == -1 && space != -1 || at != -1 && space != -1 && space < at)) {
                                        retVal = candidate;
                                    }
                                }
                                ConnectionDetails cd = ScriptUtils.getConnectionDetails("connect " + retVal);
                                fromToString[i] = retVal;
                                if (cd != null && cd.getCallUsage() || cd != null && cd.getConnectName() != null && cd.getConnectPassword() != null && !cd.getConnectPassword().equals("") && cd.getConnectName().equals("")) {
                                    errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                                    continue;
                                }
                                if (cd != null && cd.getConnectDB() != null && !cd.getConnectDB().equals("")) {
                                    oracle.dbtools.db.ConnectionDetails cd3 = null;
                                    try {
                                        if (!SQLPLUSUtil.hasUrlStub(cd.getConnectDB())) {
                                            cd3 = new oracle.dbtools.db.ConnectionDetails(cd.getConnectDB());
                                        }
                                    }
                                    catch (Exception e) {
                                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage());
                                    }
                                    if (cd3 != null && cd3.getDriver() != null) {
                                        wasThirdParty = true;
                                    }
                                }
                                boolean cancelPressed = false;
                                Connection myconn = null;
                                ArrayList<String> urlMessage = new ArrayList<String>();
                                try {
                                    if (!wasThirdParty && cd != null) {
                                        boolean bl = cancelPressed = !this.completeConnectionDetails(conn, cd);
                                    }
                                    if (!(ctx.getExited() || cd == null || cancelPressed || wasThirdParty)) {
                                        if (cd.getConnection() == null) {
                                            myconn = this.getNewConnection(urlMessage, cd.getConnectName(), cd.getConnectPassword(), cd.getConnectDB(), cd.getRole());
                                        } else {
                                            myconn = cd.getConnection();
                                            cd.setConnection(null);
                                        }
                                    }
                                }
                                finally {
                                    if (cd != null && cd.getConnection() != null) {
                                        try {
                                            cd.getConnection().close();
                                        }
                                        catch (SQLException e) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                        }
                                    }
                                }
                                if (!ctx.getExited()) {
                                    if (cd != null && !cancelPressed && !wasThirdParty && myconn == null) {
                                        for (String outln : urlMessage) {
                                            if (ctx.isSQLPlusClassic() && (outln == null || outln.equals(""))) continue;
                                            if (ctx.getOutputStream() != null) {
                                                ctx.write(outln);
                                            } else {
                                                System.out.print(outln);
                                            }
                                            if (!ctx.isSQLPlusClassic() || outln == null || outln.equals("")) continue;
                                            break;
                                        }
                                    }
                                    if (myconn != null) {
                                        fromToConnection[i] = myconn;
                                    }
                                }
                                if (myconn != null) continue;
                                if (fromToConnection[0] != null) {
                                    try {
                                        fromToConnection[0].close();
                                    }
                                    catch (SQLException e) {
                                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                    }
                                }
                                errorString = ScriptRunnerDbArb.getString("COPY_CONNECTION_FAILED");
                            }
                            if (errorString == null) {
                                if (fromToString[0] != null) {
                                    copyFrom = fromToString[0];
                                }
                                if (fromToString[1] != null) {
                                    copyTo = fromToString[1];
                                }
                            }
                            if (errorString == null && fromToConnection[0] == null && fromToConnection[1] == null) {
                                errorString = ScriptRunnerDbArb.getString("COPY_EITHER_FROM_OR_TO");
                            }
                            if (errorString == null) {
                                Connection fromConnection = fromToConnection[0];
                                Connection toConnection = fromToConnection[1];
                                Boolean getCommit = (Boolean)ctx.getProperty("script.runner.autocommit.checkbox");
                                try {
                                    if (getCommit == null || getCommit.equals(Boolean.FALSE)) {
                                        if (toConnection != null) {
                                            toConnection.setAutoCommit(false);
                                        }
                                        if (fromConnection != null) {
                                            fromConnection.setAutoCommit(false);
                                        }
                                    } else {
                                        if (toConnection != null) {
                                            toConnection.setAutoCommit(true);
                                        }
                                        if (fromConnection != null) {
                                            fromConnection.setAutoCommit(true);
                                        }
                                    }
                                }
                                catch (SQLException e) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                }
                                if (fromConnection == null) {
                                    fromConnection = ctx.getCurrentConnection();
                                }
                                if (toConnection == null) {
                                    toConnection = ctx.getCurrentConnection();
                                }
                                int copyCommit = 0;
                                String cc = (String)ctx.getProperty("script.runner.copycommit");
                                if (cc != null) {
                                    try {
                                        copyCommit = Integer.parseInt(cc);
                                    }
                                    catch (NumberFormatException e) {
                                        copyCommit = 0;
                                    }
                                }
                                Integer fs = null;
                                if (ctx.getProperty("script.runner.arraysize") != null) {
                                    fs = Integer.valueOf((String)ctx.getProperty("script.runner.arraysize"));
                                } else {
                                    Properties props = this.getConnectionInfo();
                                    try {
                                        if (props != null) {
                                            fs = Integer.valueOf(props.getProperty("PreferfedFetchSize"));
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        fs = null;
                                    }
                                }
                                String fsString = ScriptRunnerDbArb.getString("COPY_DEFAULT");
                                if (fs != null) {
                                    fsString = fs.toString();
                                }
                                Integer reportFs = fs;
                                if (fs == null) {
                                    reportFs = 0;
                                }
                                if (ctx.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(ctx.getProperty("sqlplus.classic.mode").toString())) {
                                    SQLPLUSUtil.report(ctx, ScriptRunnerDbArb.format("COPY_ARRAY_CLASSIC", new Integer(reportFs).toString(), fsString));
                                } else {
                                    SQLPLUSUtil.report(ctx, ScriptRunnerDbArb.format("COPY_ARRAY", new Integer(reportFs).toString(), fsString));
                                }
                                if (copyCommit == 0) {
                                    SQLPLUSUtil.report(ctx, ScriptRunnerDbArb.getString("COPY_COMMIT_WHEN_DONE"));
                                } else {
                                    SQLPLUSUtil.report(ctx, ScriptRunnerDbArb.format("COPY_COMMIT", new Integer(copyCommit).toString()));
                                }
                                SQLPLUSUtil.report(ctx, ScriptRunnerDbArb.format("COPY_LONG", ctx.getProperty("script.runner.setlong").toString()));
                                Statement s = null;
                                ResultSet rs = null;
                                Statement ps = null;
                                boolean amILocked = false;
                                boolean commitMade = false;
                                ArrayList<Blob> blobs = new ArrayList<Blob>();
                                ArrayList<Clob> clobs = new ArrayList<Clob>();
                                try {
                                    if (fromToConnection[0] == null || fromToConnection[1] == null) {
                                        if (ctx.getCurrentConnection() != null) {
                                            amILocked = LockManager.lock(ctx.getCurrentConnection());
                                        }
                                        if (!amILocked) {
                                            errorString = ScriptRunnerDbArb.getString("COPY_FAILED_TO_LOCK_CONNECTION");
                                        }
                                    }
                                    boolean destTableNotExist = false;
                                    ArrayList<String> toColName = new ArrayList<String>();
                                    ArrayList<String> toColTypeName = new ArrayList<String>();
                                    ArrayList<Integer> toColPrecision = new ArrayList<Integer>();
                                    ArrayList<Integer> toColScale = new ArrayList<Integer>();
                                    ArrayList<Integer> fromColTypeInt = new ArrayList<Integer>();
                                    ArrayList<String> fromColName = new ArrayList<String>();
                                    ArrayList<String> fromColTypeName = new ArrayList<String>();
                                    ArrayList<Integer> fromColPrecision = new ArrayList<Integer>();
                                    ArrayList<Integer> fromColScale = new ArrayList<Integer>();
                                    ArrayList<Boolean> fromColNullable = new ArrayList<Boolean>();
                                    StringBuilder createBuilder = new StringBuilder("create table \"" + destinationTable + "\" (");
                                    String createString = null;
                                    try {
                                        if (errorString == null) {
                                            this.commitIgnoreAutocommitError(toConnection);
                                            commitMade = true;
                                            s = fromConnection.createStatement();
                                            rs = s.executeQuery(query);
                                            ResultSetMetaData rsmd = rs.getMetaData();
                                            maxSrcCols = rsmd.getColumnCount();
                                            if (maxSrcCols != destArray.size() && destArray.size() != 0) {
                                                errorString = ScriptRunnerDbArb.getString("COPY_NUMBER_OF_COLUMNS_MISMATCH");
                                            } else {
                                                for (int i = 1; i <= maxSrcCols; ++i) {
                                                    Object precision;
                                                    fromColTypeInt.add(rsmd.getColumnType(i));
                                                    fromColName.add(rsmd.getColumnName(i));
                                                    fromColTypeName.add(rsmd.getColumnTypeName(i));
                                                    if (rsmd.isNullable(i) != 1) {
                                                        fromColNullable.add(Boolean.FALSE);
                                                    } else {
                                                        fromColNullable.add(Boolean.TRUE);
                                                    }
                                                    Integer reportedPrecision = rsmd.getPrecision(i);
                                                    if (reportedPrecision == 0 || reportedPrecision == -1) {
                                                        if (((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("VARCHAR2") || ((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("CHAR") || ((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("NVARCHAR2") || ((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("NCHAR")) {
                                                            reportedPrecision = 500;
                                                        } else if (((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("RAW")) {
                                                            reportedPrecision = 2000;
                                                        }
                                                    }
                                                    fromColPrecision.add(reportedPrecision);
                                                    fromColScale.add(rsmd.getScale(i));
                                                    String createColName = (String)fromColName.get(i - 1);
                                                    if (destArray.size() > 0) {
                                                        createColName = (String)destArray.get(i - 1);
                                                    }
                                                    if (((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("INTERVALDS")) {
                                                        precision = "";
                                                        if ((Integer)fromColPrecision.get(i - 1) > -1) {
                                                            precision = " (" + fromColPrecision.get(i - 1) + ")";
                                                        }
                                                        Object scale = "";
                                                        if ((Integer)fromColScale.get(i - 1) > -1) {
                                                            scale = "(" + fromColScale.get(i - 1) + ") ";
                                                        }
                                                        createBuilder.append("\"" + createColName + "\" INTERVAL DAY" + (String)precision + " TO SECOND " + (String)scale);
                                                    } else if (((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("INTERVALYM")) {
                                                        precision = "";
                                                        if ((Integer)fromColPrecision.get(i - 1) > -1) {
                                                            precision = " (" + fromColPrecision.get(i - 1) + ")";
                                                        }
                                                        createBuilder.append("\"" + createColName + "\" INTERVAL YEAR" + (String)precision + " TO MONTH ");
                                                    } else if (((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("BINARY_DOUBLE")) {
                                                        createBuilder.append("\"" + createColName + "\" BINARY_DOUBLE");
                                                    } else {
                                                        createBuilder.append("\"" + createColName + "\" ");
                                                        if ((Integer)fromColPrecision.get(i - 1) != 0 && (Integer)fromColPrecision.get(i - 1) != -1) {
                                                            if (((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("NUMBER") && (Integer)fromColPrecision.get(i - 1) == 126) {
                                                                if ((Integer)fromColTypeInt.get(i - 1) == 2) {
                                                                    fromColTypeName.set(i - 1, "FLOAT");
                                                                } else {
                                                                    fromColTypeName.set(i - 1, "BINARY_FLOAT");
                                                                }
                                                                createBuilder.append((String)fromColTypeName.get(i - 1));
                                                            } else if (!((String)fromColTypeName.get(i - 1)).toUpperCase().startsWith("LONG")) {
                                                                createBuilder.append((String)fromColTypeName.get(i - 1));
                                                                createBuilder.append("(" + fromColPrecision.get(i - 1));
                                                                if (((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("VARCHAR2") || ((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("CHAR")) {
                                                                    if (useByte) {
                                                                        createBuilder.append(" BYTE");
                                                                    } else {
                                                                        createBuilder.append(" CHAR");
                                                                    }
                                                                }
                                                                if ((Integer)fromColScale.get(i - 1) != 0) {
                                                                    createBuilder.append(", " + fromColScale.get(i - 1));
                                                                }
                                                                createBuilder.append(") ");
                                                            } else {
                                                                createBuilder.append((String)fromColTypeName.get(i - 1));
                                                            }
                                                        } else {
                                                            createBuilder.append((String)fromColTypeName.get(i - 1));
                                                        }
                                                    }
                                                    if (fromColNullable.equals(Boolean.FALSE)) {
                                                        createBuilder.append(" NOT NULL, ");
                                                        continue;
                                                    }
                                                    createBuilder.append(", ");
                                                }
                                                createString = createBuilder.substring(0, createBuilder.lastIndexOf(",")) + ")";
                                            }
                                        }
                                    }
                                    catch (SQLException e) {
                                        errorString = e.getLocalizedMessage();
                                    }
                                    finally {
                                        if (rs != null) {
                                            try {
                                                rs.close();
                                            }
                                            catch (SQLException e) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                            }
                                        }
                                        if (s != null) {
                                            try {
                                                s.close();
                                            }
                                            catch (SQLException e) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                            }
                                        }
                                    }
                                    if (errorString == null && destArray.size() == 0) {
                                        for (int i = 1; i <= maxSrcCols; ++i) {
                                            destArray.add((String)fromColName.get(i - 1));
                                        }
                                    }
                                    Statement s2 = null;
                                    ResultSet rs2 = null;
                                    try {
                                        if (errorString == null) {
                                            s2 = toConnection.createStatement();
                                            rs2 = s2.executeQuery("select * from \"" + destinationTable + "\" where 1=2");
                                            ResultSetMetaData rsmd = rs2.getMetaData();
                                            int maxToCols = rsmd.getColumnCount();
                                            if (maxSrcCols < maxToCols) {
                                                errorString = ScriptRunnerDbArb.getString("COPY_NUMBER_OF_SRC_COLUMNS_LESS_THAN_DEST");
                                            } else if (maxToCols < maxSrcCols) {
                                                errorString = ScriptRunnerDbArb.getString("COPY_NUMBER_OF_SRC_COLUMNS_MORE_THAN_DEST");
                                            }
                                        }
                                    }
                                    catch (SQLException e) {
                                        destTableNotExist = true;
                                        if (toType.equals("INSERT")) {
                                            errorString = ScriptRunnerDbArb.getString("COPY_DESTINATION_DOES_NOT_EXIST");
                                        }
                                    }
                                    finally {
                                        if (rs2 != null) {
                                            try {
                                                rs2.close();
                                            }
                                            catch (SQLException e) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                            }
                                        }
                                        if (s2 != null) {
                                            try {
                                                s2.close();
                                            }
                                            catch (SQLException e) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                            }
                                        }
                                    }
                                    if (errorString == null && !destTableNotExist && toType.equals("CREATE")) {
                                        errorString = ScriptRunnerDbArb.getString("COPY_DESTINATION_DOES_EXIST");
                                    }
                                    Object reportCommand = "";
                                    try {
                                        if (errorString == null && toType.equals("REPLACE") && !destTableNotExist) {
                                            reportCommand = "drop table \"" + destinationTable + "\"";
                                            s = toConnection.createStatement();
                                            s.execute((String)reportCommand);
                                            s.close();
                                        }
                                        if (errorString == null && toType.equals("APPEND") && destTableNotExist || toType.equals("REPLACE") || toType.equals("CREATE") && destTableNotExist) {
                                            s = toConnection.createStatement();
                                            reportCommand = createString;
                                            s.execute((String)reportCommand);
                                            SQLPLUSUtil.report(ctx, ScriptRunnerDbArb.format("COPY_TABLE_CREATED", destinationTable));
                                        }
                                    }
                                    catch (SQLException e) {
                                        destTableNotExist = true;
                                        errorString = ScriptRunnerDbArb.format("COPY_CREATE_ERROR", reportCommand, e.getLocalizedMessage(), "COPY_DESTINATION_WAS_NOT_CREATED");
                                    }
                                    finally {
                                        if (rs != null) {
                                            try {
                                                rs.close();
                                            }
                                            catch (SQLException e) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                            }
                                        }
                                        if (s != null) {
                                            try {
                                                s.close();
                                            }
                                            catch (SQLException e) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                            }
                                        }
                                    }
                                    if (errorString != null) break block355;
                                    try {
                                        ResultSetMetaData rsmd;
                                        int maxCols = 0;
                                        int longCol = 0;
                                        StringBuilder allCols = new StringBuilder("");
                                        StringBuilder getAll = new StringBuilder("");
                                        String allColsString = "";
                                        String getAllString = "";
                                        try {
                                            s = toConnection.createStatement();
                                            if (destArray.size() == 0) {
                                                rs = s.executeQuery("select * from \"" + destinationTable + "\"  where 1=2");
                                            } else {
                                                int i = 0;
                                                for (String theCol : destArray) {
                                                    allCols.append("\"" + theCol + "\", ");
                                                    getAll.append(":" + ++i + ", ");
                                                }
                                                allColsString = allCols.substring(0, allCols.lastIndexOf(","));
                                                getAllString = getAll.substring(0, getAll.lastIndexOf(","));
                                                rs = s.executeQuery("select " + allColsString + " from \"" + destinationTable + "\" where 1 = 2");
                                            }
                                            rsmd = rs.getMetaData();
                                            maxCols = rsmd.getColumnCount();
                                            if (maxCols != destArray.size() && destArray.size() != 0) {
                                                errorString = ScriptRunnerDbArb.getString("COPY_NUMBER_OF_COLUMNS_MISMATCH");
                                            } else {
                                                for (int i = 1; i <= maxCols; ++i) {
                                                    toColName.add(rsmd.getColumnName(i));
                                                    toColTypeName.add(rsmd.getColumnTypeName(i));
                                                    toColPrecision.add(rsmd.getPrecision(i));
                                                    toColScale.add(rsmd.getScale(i));
                                                    if (destArray.size() != 0) continue;
                                                    getAll.append(":" + i + ", ");
                                                }
                                                if (destArray.size() == 0 && getAll.length() != 0) {
                                                    getAllString = getAll.substring(0, getAll.lastIndexOf(","));
                                                }
                                            }
                                        }
                                        catch (SQLException e) {
                                            destTableNotExist = true;
                                            errorString = e.getErrorCode() == 904 ? ScriptRunnerDbArb.getString("COPY_COL_NAME_MISMATCH") : ScriptRunnerDbArb.getString("COPY_DESTINATION_DOES_NOT_EXIST");
                                        }
                                        finally {
                                            if (rs != null) {
                                                try {
                                                    rs.close();
                                                }
                                                catch (SQLException e) {
                                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                                }
                                            }
                                            if (s != null) {
                                                try {
                                                    s.close();
                                                }
                                                catch (SQLException e) {
                                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                                }
                                            }
                                        }
                                        if (errorString != null) break block355;
                                        s = fromConnection.createStatement();
                                        rs = s.executeQuery(query);
                                        if (fs != null) {
                                            rs.setFetchSize(fs);
                                        }
                                        if ((maxCols = (rsmd = rs.getMetaData()).getColumnCount()) != destArray.size() && destArray.size() != 0) {
                                            errorString = ScriptRunnerDbArb.getString("COPY_NUMBER_OF_COLUMNS_MISMATCH");
                                            break block355;
                                        }
                                        for (int i = 1; i <= maxCols; ++i) {
                                            if (!((String)fromColTypeName.get(i - 1)).toUpperCase().equals("LONG") && !((String)fromColTypeName.get(i - 1)).toUpperCase().equals("LONG RAW") && !((String)fromColTypeName.get(i - 1)).toUpperCase().equals("BLOB") && !((String)fromColTypeName.get(i - 1)).toUpperCase().equals("NCLOB") && !((String)fromColTypeName.get(i - 1)).toUpperCase().equals("CLOB")) continue;
                                            ++longCol;
                                        }
                                        if (destArray.size() == 0 && errorString == null && fromColName.size() > 0 && toColName.size() > 0) {
                                            boolean problem = false;
                                            for (int i = 1; i <= maxCols; ++i) {
                                                if (((String)fromColName.get(i - 1)).equals(toColName.get(i - 1))) continue;
                                                problem = true;
                                                break;
                                            }
                                            if (problem) {
                                                errorString = ScriptRunnerDbArb.getString("COPY_COL_NAME_MISMATCH");
                                            }
                                        }
                                        if (errorString != null) break block355;
                                        Object myInsert = "";
                                        myInsert = allColsString.equals("") ? "insert into \"" + destinationTable + "\" values (" + getAllString + ")" : "insert into \"" + destinationTable + "\" (" + allColsString + ") values (" + getAllString + ")";
                                        ps = toConnection.prepareStatement((String)myInsert);
                                        for (int i = 1; i <= maxCols; ++i) {
                                            if (!((String)fromColTypeName.get(i - 1)).toLowerCase().equals("nvarchar2") && !((String)fromColTypeName.get(i - 1)).toLowerCase().equals("nvarchar") && !((String)fromColTypeName.get(i - 1)).toLowerCase().equals("nchar") && !((String)fromColTypeName.get(i - 1)).toLowerCase().equals("nclob")) continue;
                                            OraclePreparedStatement pstmt = (OraclePreparedStatement)ps;
                                            pstmt.setFormOfUse(i, (short)2);
                                        }
                                        int noOfRows = 0;
                                        int noOfRowsSinceCommit = 0;
                                        int noOfCommittedRows = 0;
                                        int noOfInsertedRows = 0;
                                        int myfs = 200;
                                        if (fs != null) {
                                            myfs = fs;
                                        }
                                        if (longCol > 0 && myfs > 50 / longCol) {
                                            myfs = 50 / longCol;
                                            if (myfs == 0) {
                                                myfs = 1;
                                            }
                                        } else if (myfs > 200) {
                                            myfs = 200;
                                        }
                                        int arrayBinds = 0;
                                        while (rs.next()) {
                                            for (int i = 1; i <= maxCols; ++i) {
                                                int lastRead;
                                                Closeable inp;
                                                Object gotObject = rs.getObject(i);
                                                if (rs.wasNull()) {
                                                    ps.setNull(i, (Integer)fromColTypeInt.get(i - 1));
                                                    continue;
                                                }
                                                int BUFFERSIZE = 2048;
                                                Object o = gotObject;
                                                if (o instanceof BigInteger) {
                                                    NUMBER oNUM = new NUMBER((BigInteger)o);
                                                    ((OraclePreparedStatement)ps).setNUMBER(i, oNUM);
                                                    continue;
                                                }
                                                if (o instanceof Blob) {
                                                    BLOB b = null;
                                                    BufferedInputStream bis = null;
                                                    FilterOutputStream bos = null;
                                                    inp = null;
                                                    OutputStream os = null;
                                                    try {
                                                        b = BLOB.createTemporary((Connection)toConnection, (boolean)false, (int)10);
                                                        blobs.add((Blob)b);
                                                        b.open(1);
                                                        inp = ((Blob)o).getBinaryStream();
                                                        bis = new BufferedInputStream((InputStream)inp);
                                                        byte[] buffer = new byte[BUFFERSIZE];
                                                        os = b.setBinaryStream(1L);
                                                        lastRead = 0;
                                                        bos = new BufferedOutputStream(os);
                                                        while ((lastRead = bis.read(buffer, 0, buffer.length)) != -1) {
                                                            ((BufferedOutputStream)bos).write(buffer, 0, lastRead);
                                                        }
                                                        ((BufferedOutputStream)bos).flush();
                                                    }
                                                    catch (IOException io) {
                                                        throw new SQLException(io);
                                                    }
                                                    finally {
                                                        if (inp != null) {
                                                            try {
                                                                ((InputStream)inp).close();
                                                            }
                                                            catch (IOException iOException) {}
                                                        }
                                                        if (os != null) {
                                                            try {
                                                                os.close();
                                                            }
                                                            catch (IOException iOException) {}
                                                        }
                                                        if (bis != null) {
                                                            try {
                                                                bis.close();
                                                            }
                                                            catch (IOException iOException) {}
                                                        }
                                                        if (bos != null) {
                                                            try {
                                                                bos.close();
                                                            }
                                                            catch (IOException iOException) {}
                                                        }
                                                    }
                                                    ps.setObject(i, b);
                                                    continue;
                                                }
                                                if (o instanceof Clob) {
                                                    CLOB c = null;
                                                    BufferedReader binp = null;
                                                    BufferedWriter bwr = null;
                                                    inp = null;
                                                    Writer wr = null;
                                                    try {
                                                        c = ((String)fromColTypeName.get(i - 1)).toUpperCase().equals("NCLOB") ? CLOB.createTemporary((Connection)toConnection, (boolean)false, (int)10, (short)2) : CLOB.createTemporary((Connection)toConnection, (boolean)false, (int)10);
                                                        clobs.add((Clob)c);
                                                        c.open(1);
                                                        inp = ((Clob)o).getCharacterStream();
                                                        binp = new BufferedReader((Reader)inp);
                                                        char[] myc = new char[BUFFERSIZE];
                                                        wr = c.setCharacterStream(1L);
                                                        lastRead = 0;
                                                        bwr = new BufferedWriter(wr);
                                                        while ((lastRead = binp.read(myc, 0, myc.length)) != -1) {
                                                            bwr.write(myc, 0, lastRead);
                                                        }
                                                        bwr.flush();
                                                    }
                                                    catch (IOException io) {
                                                        throw new SQLException(io);
                                                    }
                                                    finally {
                                                        if (inp != null) {
                                                            try {
                                                                ((Reader)inp).close();
                                                            }
                                                            catch (IOException iOException) {}
                                                        }
                                                        if (wr != null) {
                                                            try {
                                                                wr.close();
                                                            }
                                                            catch (IOException iOException) {}
                                                        }
                                                        if (binp != null) {
                                                            try {
                                                                binp.close();
                                                            }
                                                            catch (IOException iOException) {}
                                                        }
                                                        if (bwr != null) {
                                                            try {
                                                                bwr.close();
                                                            }
                                                            catch (IOException iOException) {}
                                                        }
                                                    }
                                                    ps.setObject(i, c);
                                                    continue;
                                                }
                                                ps.setObject(i, gotObject);
                                            }
                                            ++noOfRowsSinceCommit;
                                            ps.addBatch();
                                            if (myfs > 0 && ++noOfRows % myfs == 0) {
                                                ps.executeBatch();
                                                ++arrayBinds;
                                                noOfInsertedRows = noOfRows;
                                                for (Blob b : blobs) {
                                                    try {
                                                        ((BLOB)b).freeTemporary();
                                                    }
                                                    catch (SQLException BUFFERSIZE) {}
                                                }
                                                blobs = new ArrayList();
                                                for (Clob c : clobs) {
                                                    try {
                                                        ((CLOB)c).freeTemporary();
                                                    }
                                                    catch (SQLException BUFFERSIZE) {}
                                                }
                                                clobs = new ArrayList();
                                            }
                                            if (copyCommit == 0 || arrayBinds % copyCommit != 0) continue;
                                            ps.executeBatch();
                                            this.commitIgnoreAutocommitError(toConnection);
                                            noOfCommittedRows += noOfRowsSinceCommit;
                                            noOfRowsSinceCommit = 0;
                                            this.freelobs(blobs, clobs);
                                        }
                                        ps.executeBatch();
                                        noOfInsertedRows = noOfRows;
                                        this.commitIgnoreAutocommitError(toConnection);
                                        noOfCommittedRows += noOfRowsSinceCommit;
                                        copySucceeded = true;
                                        Object reportTo = "";
                                        this.freelobs(blobs, clobs);
                                        if (copyTo == null) {
                                            reportTo = ScriptRunnerDbArb.getString("COPY_DEFAULT_HOST");
                                        } else {
                                            ConnectionDetails cd = ScriptUtils.getConnectionDetails("connect " + copyTo);
                                            String unknown = ScriptRunnerDbArb.get("COPY_UNKNOWN");
                                            String name = cd.getConnectName();
                                            String db = cd.getConnectDB();
                                            if (name == null || name.equals("")) {
                                                name = unknown;
                                            }
                                            reportTo = name;
                                            if (db != null && !db.equals("")) {
                                                reportTo = (String)reportTo + "@" + db;
                                            }
                                        }
                                        Object reportFrom = "";
                                        if (copyFrom == null) {
                                            reportFrom = ScriptRunnerDbArb.getString("COPY_DEFAULT_HOST");
                                        } else {
                                            ConnectionDetails cd = ScriptUtils.getConnectionDetails("connect " + copyFrom);
                                            String unknown = ScriptRunnerDbArb.get("COPY_UNKNOWN");
                                            String name = cd.getConnectName();
                                            String db = cd.getConnectDB();
                                            if (name == null || name.equals("")) {
                                                name = unknown;
                                            }
                                            reportFrom = name;
                                            if (db != null && !db.equals("")) {
                                                reportFrom = (String)reportFrom + "@" + db;
                                            }
                                        }
                                        String in4Spaces = "    ";
                                        SQLPLUSUtil.report(ctx, in4Spaces + ScriptRunnerDbArb.format("COPY_ROWS_SELECTED", new Integer(noOfRows).toString(), reportFrom));
                                        SQLPLUSUtil.report(ctx, in4Spaces + ScriptRunnerDbArb.format("COPY_ROWS_INSERTED", new Integer(noOfInsertedRows).toString(), destinationTable));
                                        SQLPLUSUtil.report(ctx, in4Spaces + ScriptRunnerDbArb.format("COPY_ROWS_COMMITED_TWO_ARG", new Integer(noOfCommittedRows).toString(), destinationTable, reportTo));
                                    }
                                    catch (SQLException e) {
                                        errorString = e.getLocalizedMessage();
                                    }
                                }
                                finally {
                                    try {
                                        this.freelobs(blobs, clobs);
                                        if (s != null) {
                                            try {
                                                s.close();
                                            }
                                            catch (Exception destTableNotExist) {}
                                        }
                                        if (ps != null) {
                                            try {
                                                ps.close();
                                            }
                                            catch (SQLException e) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                            }
                                        }
                                        try {
                                            if (errorString != null && commitMade) {
                                                toConnection.rollback();
                                            }
                                        }
                                        catch (SQLException e) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                        }
                                        if (fromToConnection[0] != null) {
                                            try {
                                                fromToConnection[0].close();
                                            }
                                            catch (SQLException e) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                            }
                                        }
                                        if (fromToConnection[1] != null) {
                                            try {
                                                fromToConnection[1].close();
                                            }
                                            catch (SQLException e) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                            }
                                        }
                                    }
                                    finally {
                                        if (amILocked) {
                                            try {
                                                LockManager.unlock(ctx.getCurrentConnection());
                                            }
                                            catch (Exception e) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (errorString == null && stringArray == null) {
                errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
            }
            if (errorString == null && !copySucceeded) {
                errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
            }
            if (errorString != null) {
                SQLPLUSUtil.report(ctx, errorString);
                SQLPLUSUtil.doWhenever(ctx, cmd, conn, true);
            }
        }

        private Properties getConnectionInfo() {
            if (this.ctx.getBaseConnection() == null) {
                return null;
            }
            return ConnectionResolver.getConnectionInfo(SQLPLUSUtil.resolveConnectionName(this.ctx));
        }

        private void commitIgnoreAutocommitError(Connection conn) throws SQLException {
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }

        private void freelobs(ArrayList<Blob> blobs, ArrayList<Clob> clobs) {
            for (Blob b : blobs) {
                try {
                    ((BLOB)b).freeTemporary();
                }
                catch (SQLException sQLException) {}
            }
            blobs.clear();
            for (Clob c : clobs) {
                try {
                    ((CLOB)c).freeTemporary();
                }
                catch (SQLException sQLException) {}
            }
            clobs.clear();
        }
    }
}

