/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.oracle.sql.CHAR;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptCommandListener;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.util.Debug;
import oracle.jdbc.OraclePreparedStatement;

public abstract class SQLCommandRunner {
    protected static final Logger LOGGER = Logger.getLogger(SQLCommandRunner.class.getName());
    private ScriptRunnerContext scriptRunnerContext = null;
    protected ISQLCommand cmd;
    protected Connection conn;
    protected String connName;
    protected BufferedOutputStream out;
    protected PreparedStatement stmt;
    protected CallableStatement callStmt;
    Statement st;
    Statement cstmt;
    protected Debug debug = new Debug();
    protected String statusLine = null;
    public static final int CONTINUE = 0;
    public static final int EXITMASK = 4;
    public static final int ACTIONMASK = 3;
    public static final int ACTIONNONE = 0;
    public static final int ACTIONCOMMIT = 1;
    public static final int ACTIONROLLBACK = 2;
    public static final int EXIT = 4;
    public static final String EXECUTEFAILED = "EXECUTEFAILED";
    protected HashSet<String> doubleBinds = null;
    protected HashMap<String, String> lookUpMangle = new HashMap();
    protected String altSQL = null;
    protected String myUniq = "SqlDevBind";
    protected String myUniqException = "SqlEx";
    private static ArrayList<ScriptCommandListener> commandlisteners = new ArrayList();

    protected String alteredSQL(HashSet<String> inDoubleBinds, String cmdSQL, String inAltSQL) {
        String retSQL = null;
        retSQL = inDoubleBinds != null ? inAltSQL : cmdSQL;
        return retSQL;
    }

    public void interrupt() {
        if (this.getScriptRunnerContext() != null) {
            this.getScriptRunnerContext().setInterrupted(true);
        }
        try {
            if (this.stmt != null && !this.stmt.isClosed()) {
                this.stmt.cancel();
            }
        }
        catch (SQLFeatureNotSupportedException e) {
            assert (e != null);
            LOGGER.log(Level.WARNING, "Unsupported Feature");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getStackTrace()[0].getMethodName() + "Line:" + e.getStackTrace()[0].getLineNumber() + ":" + e.getMessage());
        }
        try {
            if (this.st != null && !this.st.isClosed()) {
                this.st.cancel();
            }
        }
        catch (SQLFeatureNotSupportedException e) {
            LOGGER.log(Level.WARNING, "Unsupported Feature");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getStackTrace()[0].getMethodName() + "Line:" + e.getStackTrace()[0].getLineNumber() + ":" + e.getMessage());
        }
        try {
            if (this.callStmt != null && !this.callStmt.isClosed()) {
                this.callStmt.cancel();
            }
        }
        catch (SQLFeatureNotSupportedException e) {
            LOGGER.log(Level.WARNING, "Unsupported Feature");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getStackTrace()[0].getMethodName() + "Line:" + e.getStackTrace()[0].getLineNumber() + ":" + e.getMessage());
        }
        try {
            if (this.cstmt != null && !this.cstmt.isClosed()) {
                this.cstmt.cancel();
            }
        }
        catch (SQLFeatureNotSupportedException e) {
            LOGGER.log(Level.WARNING, "Unsupported Feature");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getStackTrace()[0].getMethodName() + "Line:" + e.getStackTrace()[0].getLineNumber() + ":" + e.getMessage());
        }
    }

    public SQLCommandRunner(ISQLCommand cmd, BufferedOutputStream out) {
        this.cmd = cmd;
        this.out = out;
    }

    protected void report(ScriptRunnerContext ctx, String s) {
        ScriptUtils.report(ctx, s, this.out);
    }

    public void doWhenever(boolean SqlError) {
        ScriptUtils.doWhenever(this.scriptRunnerContext, this.cmd, this.conn, SqlError);
    }

    public ISQLCommand getCmd() {
        return this.cmd;
    }

    public void setCmd(ISQLCommand cmd) {
        this.cmd = cmd;
    }

    public String getConnName() {
        return this.connName;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
        this.connName = ConnectionResolver.getConnectionName(conn);
    }

    public void setScriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
        this.scriptRunnerContext = scriptRunnerContext;
    }

    public void write(String s) throws IOException {
        this.out.write(this.getScriptRunnerContext().stringToByteArrayForScriptRunnerNonStatic(s));
    }

    public void setConnName(String connName) {
        this.connName = connName;
        try {
            this.conn = ConnectionResolver.getConnection(connName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.scriptRunnerContext;
    }

    public boolean setBinds(PreparedStatement stmt) throws SQLException {
        boolean setBind = true;
        boolean bindSetInCommand = false;
        List<String> al = DBUtil.getBindNames(this.alteredSQL(this.doubleBinds, this.cmd.getSql(), this.altSQL), true);
        int bindIdx = al.size();
        Map popupVars = (Map)this.getScriptRunnerContext().getProperty("f9.popup.binds");
        Map<String, Bind> vars = this.getScriptRunnerContext().getVarMap();
        HashMap externalVars = (HashMap)this.getScriptRunnerContext().getProperty("BINDMAP");
        if (externalVars == null) {
            externalVars = new HashMap();
        }
        for (int i = al.size() - 1; i >= 0; --i) {
            Bind bind;
            String bindName = null;
            if (this.doubleBinds != null) {
                bindName = this.lookUpMangle.get(al.get(i));
                if (bindName == null) {
                    bindName = al.get(i);
                }
            } else {
                bindName = al.get(i);
            }
            boolean external = false;
            boolean local = false;
            boolean popup = false;
            Bind qbind = null;
            if (popupVars.containsKey(bindName)) {
                popup = true;
            }
            if (vars.containsKey(bindName.toUpperCase())) {
                local = true;
            }
            if (externalVars.containsKey(bindName)) {
                external = true;
            }
            if (local && vars.get(bindName.toUpperCase()).getDataType() != null) {
                bind = vars.get(bindName.toUpperCase());
                DataValue dataValue = bind.getDataValue();
                DataType dataType = bind.getDataType();
                Object typedValue = dataValue != null ? dataValue.getTypedValue(ValueType.DATUM) : null;
                int type = dataType.getSqlDataType(ValueType.DATUM);
                if (typedValue instanceof oracle.sql.CHAR && !(typedValue instanceof CHAR)) {
                    typedValue = dataValue.getTypedValue(ValueType.JAVA);
                }
                stmt.setObject(bindIdx, typedValue, type);
                --bindIdx;
                continue;
            }
            if (popup || local || external) {
                block59: {
                    bind = null;
                    String type = null;
                    String value = null;
                    if (popup) {
                        value = popupVars.get(bindName).equals(DBUtil.NULL_VALUE) ? null : (String)popupVars.get(bindName);
                        type = "VARCHAR2";
                    } else if (local) {
                        qbind = bind = vars.get(bindName.toUpperCase());
                        type = bind.getType();
                        value = bind.getValue();
                    } else {
                        qbind = bind = (Bind)externalVars.get(bindName);
                        type = bind.getType();
                        value = bind.getValue();
                    }
                    if (popup) {
                        if (value != null) {
                            stmt.setString(bindIdx, value);
                        } else {
                            stmt.setNull(bindIdx, 12);
                        }
                    } else {
                        if (type.toUpperCase().indexOf("NCHAR") > -1 || type.toUpperCase().indexOf("NVARCHAR") > -1 || type.toUpperCase().indexOf("NCLOB") > -1) {
                            ((OraclePreparedStatement)stmt).setFormOfUse(bindIdx, (short)2);
                        }
                        if (type.toUpperCase().indexOf("CHAR") > -1) {
                            if (value != null) {
                                stmt.setString(bindIdx, value);
                            } else {
                                stmt.setNull(bindIdx, 12);
                            }
                        } else if (type.toUpperCase().equals("NUMBER")) {
                            try {
                                if (value != null) {
                                    stmt.setBigDecimal(bindIdx, new BigDecimal(value));
                                    break block59;
                                }
                                stmt.setNull(bindIdx, 2);
                            }
                            catch (NumberFormatException e) {
                                stmt.setBigDecimal(bindIdx, new BigDecimal(0));
                            }
                        } else if (type.toUpperCase().indexOf("CLOB") > -1) {
                            if (value != null) {
                                stmt.setClob(bindIdx, (Clob)DataTypesUtil.getCLOB(value, this.conn));
                            } else {
                                stmt.setNull(bindIdx, 2005);
                            }
                        } else if (!type.toUpperCase().equals("REFCURSOR")) {
                            if (type.toUpperCase().equals("BINARY_DOUBLE")) {
                                try {
                                    if (value != null) {
                                        ((OraclePreparedStatement)stmt).setBinaryDouble(bindIdx, Double.parseDouble(value));
                                        break block59;
                                    }
                                    stmt.setNull(bindIdx, 101);
                                }
                                catch (NumberFormatException e) {
                                    stmt.setString(bindIdx, value);
                                }
                            } else if (type.toUpperCase().equals("BINARY_FLOAT")) {
                                try {
                                    if (value != null) {
                                        ((OraclePreparedStatement)stmt).setBinaryFloat(bindIdx, Float.parseFloat(value));
                                        break block59;
                                    }
                                    stmt.setNull(bindIdx, 100);
                                }
                                catch (NumberFormatException e) {
                                    stmt.setString(bindIdx, value);
                                }
                            } else if (type.toUpperCase().equals("BLOB")) {
                                try {
                                    if (qbind != null && qbind.isLastSetObj()) {
                                        if (qbind.getValueObj() != null) {
                                            stmt.setBlob(bindIdx, (Blob)qbind.getValueObj());
                                        } else {
                                            stmt.setNull(bindIdx, 2004);
                                        }
                                    } else if (value != null) {
                                        try {
                                            stmt.setBlob(bindIdx, (Blob)DataTypesUtil.getBLOB(value.toCharArray(), this.conn));
                                        }
                                        catch (IOException e) {
                                            stmt.setNull(bindIdx, 2004);
                                        }
                                    } else {
                                        stmt.setNull(bindIdx, 2004);
                                    }
                                }
                                catch (SQLException e) {
                                    LOGGER.log(Level.FINE, e.getMessage(), e);
                                    try {
                                        stmt.setNull(bindIdx, 2004);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                    }
                }
                --bindIdx;
                continue;
            }
            if (this.cmd.getBinds().size() > 0) {
                bindSetInCommand = true;
                continue;
            }
            this.report(this.scriptRunnerContext, ScriptRunnerDbArb.format("UNDECLARED_VARIABLE", bindName.toUpperCase(Locale.US)));
            setBind = false;
            break;
        }
        if (bindSetInCommand) {
            DBUtil.bind(stmt, this.cmd.getBinds());
            setBind = true;
        }
        return setBind;
    }

    protected void unlockConnection() {
        try {
            LockManager.unlock(this.conn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean lockConnection() {
        return LockManager.lock(this.conn);
    }

    protected String resolveConnectionName() {
        return ConnectionResolver.getConnectionName(this.getScriptRunnerContext().getBaseConnection());
    }

    protected Properties getConnectionInfo() {
        if (this.getScriptRunnerContext().getBaseConnection() == null) {
            return null;
        }
        return ConnectionResolver.getConnectionInfo(this.resolveConnectionName());
    }

    public static void registerListener(ScriptCommandListener listener) {
        if (!commandlisteners.contains(listener)) {
            commandlisteners.add(listener);
        }
    }

    public void unregisterListener(ScriptCommandListener listener) {
        if (commandlisteners.contains(listener)) {
            commandlisteners.remove(listener);
        }
    }

    public void fireListenersRegister(ScriptRunnerContext context) {
        for (ScriptCommandListener listener : commandlisteners) {
            listener.registerdisplay(context);
        }
    }

    public void fireListenerOutputLog(String format) {
        for (ScriptCommandListener listener : commandlisteners) {
            listener.outputLog(format);
        }
    }

    public void fireListenerWarning(int lineNumber, int column, int i, String errorMessage) {
        for (ScriptCommandListener listener : commandlisteners) {
            listener.warning(lineNumber, column, i, errorMessage);
        }
    }

    public void fireListenerError(int lineNumber, int column, int i, String errorMessage) {
        for (ScriptCommandListener listener : commandlisteners) {
            listener.error(lineNumber, column, i, errorMessage);
        }
    }

    public void fireListenerunRegisterAsynchronousLogPage() {
        for (ScriptCommandListener listener : commandlisteners) {
            listener.unregisterdisplay();
        }
    }
}

