/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.IResultsFormatterWrapper;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public abstract class ResultsFormatterWrapper
implements IResultsFormatterWrapper {
    private List<String> m_colNames;
    private int[] m_colSizes;
    private int[] m_precisions;
    private int[] m_scales;
    private transient boolean m_interrupted;
    protected IResultFormatter m_formatter;
    protected long m_rowNum = 0L;

    protected ResultsFormatterWrapper() {
    }

    void setParent(IResultFormatter parent) {
        this.m_formatter = parent;
    }

    protected void setColumnNames(List<String> names) {
        this.m_colNames = names;
    }

    protected void setColumnSizes(int[] sizes) {
        this.m_colSizes = sizes;
    }

    protected void setPrecisions(int[] sizes) {
        this.m_precisions = sizes;
    }

    protected void setScales(int[] sizes) {
        this.m_scales = sizes;
    }

    public abstract Connection getConnection();

    public void close() {
    }

    public abstract int getDataType(int var1) throws SQLException;

    public String getDataTypeName(int col) throws SQLException {
        return "";
    }

    public abstract int print() throws IOException;

    public abstract int print(IRaptorTaskProgressUpdater var1) throws IOException, ExecutionException;

    public String getColumnName(int col) {
        try {
            return this.m_colNames.get(col);
        }
        catch (Exception e) {
            return "";
        }
    }

    public int getColumnSize(int col) {
        return this.m_colSizes[col];
    }

    public int getPrecision(int col) {
        return this.m_precisions == null ? this.m_colSizes[col] : this.m_precisions[col];
    }

    public int getScale(int col) {
        return this.m_scales == null ? 0 : this.m_scales[col];
    }

    public int getColumnCount() {
        return this.m_colNames.size();
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.m_colNames);
    }

    public void interrupt() {
        this.m_interrupted = true;
    }

    protected boolean isInterrupted() {
        return this.m_interrupted;
    }

    public Object getValue(Object obj) {
        try {
            return DataTypesUtil.stringValue(obj, this.getConnection());
        }
        catch (Exception exception) {
            return obj;
        }
    }

    public Object getValue(Object obj, FormatType formatType) {
        try {
            return DataTypesUtil.stringValue(obj, this.getConnection(), formatType);
        }
        catch (Exception exception) {
            return obj;
        }
    }

    public abstract String getSQL();

    public long getRowNum() {
        return this.m_rowNum;
    }
}

