/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.preparedstatement;

import java.io.IOException;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.LongBinary;
import oracle.dbtools.raptor.datatypes.strategies.preparedstatement.PrepareBindingDatumAtName;
import oracle.jdbc.OraclePreparedStatement;

public class PrepareBindingLONGBINARY<S extends OraclePreparedStatement, P extends DataBinding>
extends PrepareBindingDatumAtName<S, P> {
    public PrepareBindingLONGBINARY(BindContext<S> context, P param) {
        super(context, param);
    }

    @Override
    protected void customBindIN(DataValue value, int pos) throws SQLException {
        LongBinary longBinary = (LongBinary)value.getTypedValue(this.getBindContext().getDataTypeConnectionProvider(), ValueType.DEFAULT);
        if (longBinary != null && !longBinary.isNull()) {
            try {
                ((OraclePreparedStatement)this.getStatement()).setBinaryStream(pos, longBinary.getInputStream(), longBinary.getLength());
            }
            catch (IOException e) {
                throw new DataTypeIOException(e);
            }
        } else {
            super.customBindIN(null, pos);
        }
    }

    @Override
    protected void customBindIN(DataValue value, String name) throws SQLException {
        LongBinary longBinary = (LongBinary)value.getTypedValue(this.getBindContext().getDataTypeConnectionProvider(), ValueType.DEFAULT);
        if (longBinary != null && !longBinary.isNull()) {
            try {
                ((OraclePreparedStatement)this.getStatement()).setBinaryStreamAtName(name, longBinary.getInputStream(), longBinary.getLength());
            }
            catch (IOException e) {
                throw new DataTypeIOException(e);
            }
        } else {
            super.customBindIN(null, name);
        }
    }
}

