/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.dbtools.util.encoding.BASE64Encoding;
import oracle.dbtools.util.encoding.EncodingException;
import oracle.dbtools.util.encoding.EncodingFactory;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.dbtools.util.encoding.MimeType;

public class ROWID
extends Datum {
    protected ROWID(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        switch (valueType) {
            case JDBC: {
                return this.customTypedValue(connectionProvider, value, ValueType.DEFAULT, target);
            }
        }
        return super.customTypedValue(connectionProvider, value, valueType, target);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                return oracle.sql.ROWID.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return -8;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        if (value instanceof oracle.sql.ROWID) {
            return value;
        }
        if (value instanceof byte[]) {
            return new oracle.sql.ROWID(Arrays.copyOf((byte[])value, ((byte[])value).length));
        }
        return new oracle.sql.ROWID(String.valueOf(value).getBytes());
    }

    @Override
    protected boolean customRequiresConnection() {
        return true;
    }

    public static byte[] decodeRowId(Object value) throws IOException, EncodingException {
        return ROWID.decodeRowId(String.valueOf(value));
    }

    public static byte[] decodeRowId(String value) throws IOException, EncodingException {
        if (value.contains(".")) {
            return ROWID.decodeOracle7RowId(value.toCharArray());
        }
        return ROWID.decodeOracle8RowId(value.toCharArray());
    }

    public static String encodeRowId(byte[] b) throws IOException, EncodingException {
        if (b.length == 8) {
            return ROWID.encodeOracle7RowId(b);
        }
        return ROWID.encodeOracle8RowId(b);
    }

    public static byte[] decodeOracle8RowId(char[] ch) throws IOException, EncodingException {
        int j;
        BASE64Encoding b64Enc = (BASE64Encoding)EncodingFactory.getDecoder(EncodingType.ENCODING_BASE64, MimeType.MIME_TEXT);
        char[] objectIdBlock = new char[8];
        int i = 0;
        objectIdBlock[i++] = 65;
        objectIdBlock[i++] = 65;
        for (j = 0; j < 6; ++j) {
            objectIdBlock[i++] = ch[j];
        }
        byte[] objectId = b64Enc.decodeToByteArray(objectIdBlock);
        char[] fileNumberBlock = new char[4];
        i = 0;
        ++j;
        while (j < 9) {
            fileNumberBlock[i++] = ch[j];
            ++j;
        }
        fileNumberBlock[i++] = 65;
        fileNumberBlock[i++] = 61;
        byte[] fileNumber = b64Enc.decodeToByteArray(fileNumberBlock);
        char[] blockNumberBlock = new char[4];
        i = 0;
        ++j;
        ++j;
        while (j < 15) {
            blockNumberBlock[i++] = ch[j];
            ++j;
        }
        byte[] blockNumber = b64Enc.decodeToByteArray(blockNumberBlock);
        char[] rowNumberBlock = new char[4];
        i = 0;
        rowNumberBlock[i++] = 65;
        while (j < 18) {
            rowNumberBlock[i++] = ch[j];
            ++j;
        }
        byte[] rowNumber = b64Enc.decodeToByteArray(rowNumberBlock);
        byte[] rowid = new byte[]{objectId[2], objectId[3], objectId[4], objectId[5], fileNumber[0], (byte)(fileNumber[1] | blockNumber[0]), blockNumber[1], blockNumber[2], rowNumber[1], rowNumber[2]};
        return rowid;
    }

    public static String encodeOracle8RowId(byte[] b) throws IOException, EncodingException {
        BASE64Encoding b64Enc = (BASE64Encoding)EncodingFactory.getDecoder(EncodingType.ENCODING_BASE64, MimeType.MIME_TEXT);
        StringBuilder sb = new StringBuilder();
        byte[] objectId = new byte[6];
        objectId[2] = b[0];
        objectId[3] = b[1];
        objectId[4] = b[2];
        objectId[5] = b[3];
        char[] objectIdBlock = b64Enc.encodeToCharArray(objectId);
        sb.append(objectIdBlock, 2, 6);
        sb.append("A");
        byte[] fileNumber = new byte[]{b[4], (byte)(b[5] & 0xF0)};
        char[] fileNumberBlock = b64Enc.encodeToCharArray(fileNumber);
        sb.append(fileNumberBlock, 0, 2);
        sb.append("AA");
        byte[] blockNumber = new byte[]{(byte)(b[5] & 0xF), b[6], b[7]};
        char[] blockNumberBlock = b64Enc.encodeToCharArray(blockNumber);
        sb.append(blockNumberBlock);
        byte[] rowNumber = new byte[3];
        rowNumber[1] = b[8];
        rowNumber[2] = b[9];
        char[] rowNumberBlock = b64Enc.encodeToCharArray(rowNumber);
        sb.append(rowNumberBlock, 1, 3);
        return sb.toString();
    }

    public static byte[] decodeOracle7RowId(char[] ch) throws IOException, EncodingException {
        BASE64Encoding hexEnc = (BASE64Encoding)EncodingFactory.getDecoder(EncodingType.ENCODING_HEX, MimeType.MIME_TEXT);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        hexEnc.decode(new CharArrayReader(ch, 0, 8), ostream);
        hexEnc.decode(new CharArrayReader(ch, 9, 4), ostream);
        hexEnc.decode(new CharArrayReader(ch, 14, 4), ostream);
        return ostream.toByteArray();
    }

    public static String encodeOracle7RowId(byte[] b) throws IOException, EncodingException {
        BASE64Encoding hexEnc = (BASE64Encoding)EncodingFactory.getDecoder(EncodingType.ENCODING_HEX, MimeType.MIME_TEXT);
        StringWriter writer = new StringWriter();
        hexEnc.encode(new ByteArrayInputStream(b, 0, 4), writer);
        writer.append('.');
        hexEnc.encode(new ByteArrayInputStream(b, 5, 2), writer);
        writer.append('.');
        hexEnc.encode(new ByteArrayInputStream(b, 5, 2), writer);
        return writer.toString();
    }
}

