/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.NumericDatum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class NUMBER
extends NumericDatum {
    protected static final int MAX_FP_PRECISION = 40;
    protected static final int MAX_PRECISION = 38;

    protected NUMBER(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        Object internalValue = value.getInternalValue();
        switch (stringType) {
            case REST: 
            case GENERIC: {
                return new StringValue(((oracle.sql.NUMBER)internalValue).stringValue());
            }
        }
        return super.customStringValue(connectionProvider, value, stringType, maxLen);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case JDBC: {
                return BigDecimal.class;
            }
            case DEFAULT: {
                return oracle.sql.NUMBER.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 2;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customUnscaledInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        try {
            if (value instanceof oracle.sql.NUMBER) {
                return value;
            }
            if (value instanceof BigDecimal) {
                return new oracle.sql.NUMBER((BigDecimal)value);
            }
            if (value instanceof BigInteger) {
                return new oracle.sql.NUMBER(this.asBigDecimal((BigInteger)value));
            }
            if (value instanceof byte[]) {
                return new oracle.sql.NUMBER(Arrays.copyOf((byte[])value, ((byte[])value).length));
            }
            if (value instanceof String) {
                String stringValue = value.toString();
                if (this.isPosInf(stringValue)) {
                    return oracle.sql.NUMBER.posInf();
                }
                if (this.isNegInf(stringValue)) {
                    return oracle.sql.NUMBER.negInf();
                }
                try {
                    return new oracle.sql.NUMBER(new BigDecimal(stringValue));
                }
                catch (Exception e1) {
                    return this.typedValueFromNLSString(connectionProvider, stringValue);
                }
            }
            return new oracle.sql.NUMBER(value);
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, value);
        }
    }

    protected oracle.sql.NUMBER typedValueFromNLSString(DataTypeConnectionProvider connectionProvider, String value) throws SQLException {
        return new oracle.sql.NUMBER(this.asBigDecimal(((OracleNLSProvider)NLSProvider.getProvider(connectionProvider.getNLSConnection())).parseNumber(value)));
    }

    protected BigDecimal asBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return null;
    }

    @Override
    protected Object customScaleInternalValue(DataTypeConnectionProvider connectionProvider, Object value) throws SQLException {
        oracle.sql.NUMBER unscaledValue = (oracle.sql.NUMBER)value;
        oracle.sql.NUMBER scaledValue = this.scaleNUMBER(unscaledValue, this.typeMetadata.get_data_precision(), this.typeMetadata.get_data_scale());
        return this.constrainNUMBER(scaledValue, unscaledValue, this.typeMetadata.get_data_precision(), this.typeMetadata.get_data_scale());
    }

    protected oracle.sql.NUMBER scaleNUMBER(oracle.sql.NUMBER value, Integer precision, Integer scale) throws SQLException {
        oracle.sql.NUMBER newValue = value;
        if (value != null && !value.isZero()) {
            if (scale != null && scale == -127) {
                newValue = this.scaleNUMBER(value, precision);
            } else if (precision != null || scale != null) {
                int ip = this.getPrecisionDigits(precision, scale);
                if (ip > 0) {
                    boolean[] exceeded = new boolean[1];
                    if (!value.isInf()) {
                        int s = this.getScaleDigits(precision, scale);
                        int shiftby = 0;
                        int p = ip - s;
                        if (s < 0 || p < 0) {
                            shiftby = s;
                            p = ip;
                            s = 0;
                        }
                        if (shiftby != 0) {
                            newValue = newValue.shift(shiftby);
                        }
                        newValue = newValue.scale(p, s, exceeded);
                        if (shiftby != 0) {
                            newValue = newValue.shift(shiftby * -1);
                        }
                        if (exceeded[0]) {
                            newValue = this.scaleNUMBER(value, ip);
                        }
                    }
                } else {
                    newValue = oracle.sql.NUMBER.zero();
                }
            } else {
                newValue = this.scaleNUMBER(value);
            }
        }
        if (newValue != value && !newValue.equals((Object)value)) {
            return newValue;
        }
        return value;
    }

    protected oracle.sql.NUMBER scaleNUMBER(oracle.sql.NUMBER value, Integer precision) throws SQLException {
        oracle.sql.NUMBER newValue = value;
        if (value != null && !value.isZero()) {
            int p = this.getPrecisionDigits(precision);
            if (p > 0) {
                if (!value.isInf()) {
                    newValue = value.floatingPointRound(p);
                }
            } else {
                newValue = oracle.sql.NUMBER.zero();
            }
        }
        if (newValue != value && !newValue.equals((Object)value)) {
            return newValue;
        }
        return value;
    }

    protected oracle.sql.NUMBER scaleNUMBER(oracle.sql.NUMBER value) throws SQLException {
        return this.scaleNUMBER(value, null);
    }

    protected oracle.sql.NUMBER posNUMBERMax(Integer precision, Integer scale) throws SQLException {
        oracle.sql.NUMBER newValue = oracle.sql.NUMBER.zero();
        if (scale != null && scale == -127) {
            newValue = this.posNUMBERMax(precision);
        } else if (precision != null || scale != null) {
            int p = this.getPrecisionDigits(precision, scale);
            if (p > 0) {
                int s = this.getScaleDigits(precision, scale);
                int shiftby = s * -1;
                return this.posFixedNUMBERMax(p, shiftby);
            }
        } else {
            newValue = this.posNUMBERMax();
        }
        return newValue;
    }

    protected oracle.sql.NUMBER posNUMBERMax(Integer precision) throws SQLException {
        int p = this.getPrecisionDigits(precision);
        if (p > 0) {
            return oracle.sql.NUMBER.posInf();
        }
        return oracle.sql.NUMBER.zero();
    }

    protected oracle.sql.NUMBER posNUMBERMax() throws SQLException {
        return this.posNUMBERMax(null);
    }

    protected oracle.sql.NUMBER negNUMBERMax(Integer precision, Integer scale) throws SQLException {
        return this.posNUMBERMax(precision, scale).negate();
    }

    protected oracle.sql.NUMBER negNUMBERMax(Integer precision) throws SQLException {
        return this.posNUMBERMax(precision).negate();
    }

    protected oracle.sql.NUMBER negNUMBERMax() throws SQLException {
        return this.posNUMBERMax().negate();
    }

    protected oracle.sql.NUMBER posNUMBERMin(Integer precision, Integer scale) throws SQLException {
        oracle.sql.NUMBER newValue = oracle.sql.NUMBER.zero();
        if (scale != null && scale == -127) {
            newValue = this.posNUMBERMin(precision);
        } else if (precision != null || scale != null) {
            int p = this.getPrecisionDigits(precision, scale);
            if (p > 0) {
                int s = this.getScaleDigits(precision, scale);
                int shiftby = s * -1;
                newValue = this.posFixedNUMBERMin(p, shiftby);
            }
        } else {
            return this.posNUMBERMin();
        }
        return newValue;
    }

    protected oracle.sql.NUMBER posNUMBERMin(Integer precision) throws SQLException {
        int p = this.getPrecisionDigits(precision);
        if (p > 0) {
            return oracle.sql.NUMBER.negInf();
        }
        return oracle.sql.NUMBER.zero();
    }

    protected oracle.sql.NUMBER posNUMBERMin() throws SQLException {
        return this.posNUMBERMin(null);
    }

    protected oracle.sql.NUMBER negNUMBERMin(Integer precision, Integer scale) throws SQLException {
        return this.posNUMBERMin(precision, scale).negate();
    }

    protected oracle.sql.NUMBER negNUMBERMin(Integer precision) throws SQLException {
        return this.posNUMBERMin(precision).negate();
    }

    protected oracle.sql.NUMBER negNUMBERMin() throws SQLException {
        return this.posNUMBERMin().negate();
    }

    protected oracle.sql.NUMBER posFixedNUMBERMax(int precision, int scale) throws SQLException {
        if (precision > 0) {
            char[] buf = new char[precision];
            Arrays.fill(buf, '9');
            oracle.sql.NUMBER newValue = new oracle.sql.NUMBER((Object)String.valueOf(buf));
            if (scale != 0) {
                newValue = newValue.shift(scale);
            }
            return newValue;
        }
        return oracle.sql.NUMBER.zero();
    }

    protected oracle.sql.NUMBER posFixedNUMBERMin(int precision, int scale) throws SQLException {
        if (precision > 0) {
            return new oracle.sql.NUMBER(1).shift(scale);
        }
        return oracle.sql.NUMBER.zero();
    }

    protected oracle.sql.NUMBER constrainNUMBER(oracle.sql.NUMBER newValue, oracle.sql.NUMBER oldValue, Integer precision, Integer scale) throws SQLException {
        if (scale == null || scale != -127) {
            oracle.sql.NUMBER maxPosValue = this.posNUMBERMax(precision, scale);
            oracle.sql.NUMBER minPosValue = this.posNUMBERMin(precision, scale);
            oracle.sql.NUMBER maxNegValue = this.negNUMBERMax(precision, scale);
            oracle.sql.NUMBER minNegValue = this.negNUMBERMin(precision, scale);
            return this.constrainNUMBER(newValue, oldValue, maxPosValue, minPosValue, maxNegValue, minNegValue);
        }
        return this.constrainNUMBER(newValue, oldValue, precision);
    }

    protected oracle.sql.NUMBER constrainNUMBER(oracle.sql.NUMBER newValue, oracle.sql.NUMBER oldValue, Integer precision) throws SQLException {
        oracle.sql.NUMBER maxPosValue = this.posNUMBERMax(precision);
        oracle.sql.NUMBER minPosValue = this.posNUMBERMin(precision);
        oracle.sql.NUMBER maxNegValue = this.negNUMBERMax(precision);
        oracle.sql.NUMBER minNegValue = this.negNUMBERMin(precision);
        return this.constrainNUMBER(newValue, oldValue, maxPosValue, minPosValue, maxNegValue, minNegValue);
    }

    protected oracle.sql.NUMBER constrainNUMBER(oracle.sql.NUMBER newValue, oracle.sql.NUMBER oldValue, oracle.sql.NUMBER maxPosValue, oracle.sql.NUMBER minPosValue, oracle.sql.NUMBER maxNegValue, oracle.sql.NUMBER minNegValue) {
        if (newValue != null) {
            int newSign = newValue.sign();
            if (oldValue != null) {
                switch (oldValue.sign()) {
                    case 1: {
                        if (newSign >= 0) break;
                        return maxPosValue;
                    }
                    case -1: {
                        if (newSign <= 0) break;
                        return maxNegValue;
                    }
                }
            }
            if (newValue.compareTo(maxPosValue) > 0) {
                return maxPosValue;
            }
            if (newValue.compareTo(maxNegValue) < 0) {
                return maxNegValue;
            }
            if (newSign > 0 && newValue.compareTo(minPosValue) < 0) {
                return minPosValue;
            }
            if (newSign < 0 && newValue.compareTo(minNegValue) > 0) {
                return minNegValue;
            }
        }
        return newValue;
    }

    protected int getPrecisionDigits(Integer precision, Integer scale) throws SQLException {
        if (scale == null || scale != -127) {
            int p;
            int maxValue = 38;
            int n = p = precision == null ? 38 : precision;
            if (p < 0) {
                return 0;
            }
            if (p > 38) {
                return 38;
            }
            return p;
        }
        return this.getPrecisionDigits(precision);
    }

    protected int getPrecisionDigits(Integer precision) throws SQLException {
        int p;
        int maxValue = 40;
        int n = p = precision == null ? 40 : precision;
        if (p < 0) {
            return 0;
        }
        if (p > 40) {
            return 40;
        }
        return p;
    }

    protected int getPrecisionDigits() throws SQLException {
        return this.getPrecisionDigits(null);
    }

    protected int getScaleDigits(Integer precision, Integer scale) throws SQLException {
        int s;
        this.getPrecisionDigits(precision, scale);
        int n = s = scale == null ? 0 : scale;
        if (s < -84) {
            return -84;
        }
        if (s > 127) {
            return 127;
        }
        return s;
    }
}

