/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.NUMBER;
import oracle.dbtools.raptor.datatypes.util.StringValue;

public class INTEGER
extends NUMBER {
    protected INTEGER(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        switch (stringType) {
            case REST: 
            case GENERIC: {
                oracle.sql.NUMBER val = (oracle.sql.NUMBER)value.getInternalValue();
                try {
                    return new StringValue(val.bigIntegerValue().toString());
                }
                catch (SQLException se) {
                    throw new DataTypeSQLException(se);
                }
            }
        }
        return super.customStringValue(connectionProvider, value, stringType, maxLen);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        Object internalValue = value.getInternalValue();
        Object superValue = super.customTypedValue(connectionProvider, value, valueType, target);
        try {
            switch (valueType) {
                case JDBC: {
                    return this.unscaledValue((BigDecimal)superValue);
                }
            }
            return superValue;
        }
        catch (Exception e) {
            throw new DataTypeIllegalArgumentException(this, internalValue, e);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case JDBC: {
                return BigInteger.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    private BigInteger unscaledValue(BigDecimal dec) throws SQLException {
        if (dec == null) {
            return null;
        }
        return dec.unscaledValue();
    }

    @Override
    protected oracle.sql.NUMBER posNUMBERMax(Integer precision, Integer scale) throws SQLException {
        oracle.sql.NUMBER maxPosValue;
        oracle.sql.NUMBER newValue = super.posNUMBERMax(precision, scale);
        if (newValue != null && newValue.compareTo(maxPosValue = new oracle.sql.NUMBER((Object)"2147483647")) > 0) {
            return maxPosValue;
        }
        return newValue;
    }

    @Override
    protected oracle.sql.NUMBER negNUMBERMax(Integer precision, Integer scale) throws SQLException {
        oracle.sql.NUMBER maxNegValue;
        oracle.sql.NUMBER newValue = super.negNUMBERMax(precision, scale);
        if (newValue != null && newValue.compareTo(maxNegValue = new oracle.sql.NUMBER((Object)"-2147483647")) < 0) {
            return maxNegValue;
        }
        return newValue;
    }
}

