/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraResolvableDatum;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.datatypes.objects.OraTimestampDatum;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.OraConversions;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.TIMESTAMP;

public class OraTIMESTAMP
extends OraResolvableDatum
implements OraTimestampDatum {
    public static OraTIMESTAMP getInstance() {
        return OraTIMESTAMP.getInstance(LocalDateTime.now());
    }

    public static OraTIMESTAMP getLocalInstance() {
        return OraTIMESTAMP.getInstance(Instant.now(), OraResolvableDatum.Realization.LOCAL_INSTANT);
    }

    public static OraTIMESTAMP getInstance(Calendar calendar, Integer nanos) {
        return calendar != null ? OraTIMESTAMP.getInstance(OraConversions.toInstant(calendar, nanos)) : null;
    }

    public static OraTIMESTAMP getInstance(Calendar calendar) {
        return OraTIMESTAMP.getInstance(calendar, null);
    }

    public static OraTIMESTAMP getLocalInstance(TIMESTAMP datetime) {
        return datetime != null ? new OraTIMESTAMP(new OraTIMESTAMPImpl(datetime, OraResolvableDatum.Realization.LOCAL_INSTANT)) : null;
    }

    public static OraTIMESTAMP getLocalInstance(LocalDateTime datetime) {
        return datetime != null ? new OraTIMESTAMP(new OraTIMESTAMPImpl(datetime, OraResolvableDatum.Realization.LOCAL_INSTANT)) : null;
    }

    public static OraTIMESTAMP getLocalInstance(Instant instant) {
        return OraTIMESTAMP.getInstance(instant, OraResolvableDatum.Realization.LOCAL);
    }

    public static OraTIMESTAMP getInstance(TIMESTAMP datetime) {
        return datetime != null ? new OraTIMESTAMP(new OraTIMESTAMPImpl(datetime)) : null;
    }

    public static OraTIMESTAMP getInstance(LocalDateTime datetime) {
        return datetime != null ? new OraTIMESTAMP(new OraTIMESTAMPImpl(datetime)) : null;
    }

    public static OraTIMESTAMP getInstance(Date datetime) {
        return datetime != null ? OraTIMESTAMP.getInstance(datetime.toInstant()) : null;
    }

    public static OraTIMESTAMP getInstance(Instant instant) {
        return instant != null ? new OraTIMESTAMP(new OraTIMESTAMPImpl(instant)) : null;
    }

    protected static OraTIMESTAMP getInstance(Instant instant, OraResolvableDatum.Realization realisation) {
        return instant != null ? new OraTIMESTAMP(new OraTIMESTAMPImpl(instant, realisation)) : null;
    }

    public static OraTIMESTAMP getInstance(OraTemporalDatum temporalDatum) {
        OraTIMESTAMP ts;
        if (temporalDatum != null) {
            ts = OraTIMESTAMP.getInstance();
            ts.replicate(temporalDatum);
        } else {
            ts = null;
        }
        return ts;
    }

    protected OraTIMESTAMP(OraTIMESTAMPImpl impl) {
        super(impl);
    }

    @Override
    protected OraTIMESTAMPImpl getImpl() {
        return (OraTIMESTAMPImpl)super.getImpl();
    }

    @Override
    public OraTIMESTAMP setSessionTimeZone(TimeZone sessionTimeZone) {
        super.setSessionTimeZone(sessionTimeZone);
        return this;
    }

    @Override
    public OraTIMESTAMP setSessionZone(ZoneId zone) {
        super.setSessionZone(zone);
        return this;
    }

    public TIMESTAMP getDatum() {
        return (TIMESTAMP)super.getDatum();
    }

    public String toString() {
        try {
            OraTIMESTAMPFormat formatter = new OraTIMESTAMPFormat(new OracleNLSProvider(null).getTimeStampFormat(FormatType.GENERIC), OraLocaleInfo.getInstance((Locale)Locale.US));
            return formatter.format(this.getDatum());
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    protected static final class OraTIMESTAMPImpl
    extends OraResolvableDatum.OraResolvableDatumImpl
    implements OraTimestampDatum.OraTimestampDatumImpl {
        protected OraTIMESTAMPImpl(LocalDateTime datetime, OraResolvableDatum.Realization realization) {
            super(datetime, realization);
        }

        protected OraTIMESTAMPImpl(Instant instant, OraResolvableDatum.Realization realization) {
            super(instant, realization);
        }

        protected OraTIMESTAMPImpl(Instant instant) {
            this(instant, OraResolvableDatum.Realization.INSTANT);
        }

        protected OraTIMESTAMPImpl(LocalDateTime datetime) {
            this(datetime, OraResolvableDatum.Realization.LOCAL);
        }

        private OraTIMESTAMPImpl(TIMESTAMP datetime, OraResolvableDatum.Realization realization) {
            this(OraTIMESTAMPImpl.unpackTemporalDatum(datetime.shareBytes()).toInstant(), realization);
        }

        private OraTIMESTAMPImpl(TIMESTAMP datetime) {
            this(datetime, OraResolvableDatum.Realization.LOCAL);
        }

        public TIMESTAMP getDatum() {
            byte[] bytes = new byte[11];
            this.packDatumBytes(bytes);
            return new TIMESTAMP(bytes);
        }
    }
}

