/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;
import oracle.dbtools.raptor.datatypes.objects.LargeDatum;
import oracle.dbtools.raptor.datatypes.util.CappedFilterWriter;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import org.xml.sax.SAXException;

public abstract class LargeVarchar
extends LargeDatum {
    public LargeVarchar() {
    }

    protected LargeVarchar(Object value) {
        super(value);
    }

    protected LargeVarchar(LargeVarchar source) {
        super(source);
    }

    public Writer exportTo(Writer writer) throws IOException, SQLException {
        LargeVarchar.copyCharacters(this.getReader(), writer);
        writer.flush();
        return writer;
    }

    public StringBuffer exportTo(StringBuffer buffer) throws IOException, SQLException {
        LargeVarchar.copyCharacters(this.getReader(), buffer);
        return buffer;
    }

    public StringBuilder exportTo(StringBuilder buffer) throws IOException, SQLException {
        LargeVarchar.copyCharacters(this.getReader(), buffer);
        return buffer;
    }

    public Clob exportTo(Clob clob) throws IOException, SQLException {
        Writer writer = clob.setCharacterStream(1L);
        this.exportTo(writer);
        writer.close();
        return clob;
    }

    public File exportTo(File file) throws IOException, SQLException {
        this.exportToObject(file);
        return file;
    }

    public Object exportTo(Object target) throws IOException, SQLException {
        return this.exportToObject(target);
    }

    protected Object exportToObject(Object target) throws IOException, SQLException {
        if (target instanceof Writer) {
            return this.exportTo((Writer)target);
        }
        if (target instanceof Clob) {
            return this.exportTo((Clob)target);
        }
        if (target instanceof File) {
            return this.exportTo(new FileWriter((File)target));
        }
        if (target instanceof StringBuilder) {
            return this.exportTo((StringBuilder)target);
        }
        if (target instanceof StringBuffer) {
            return this.exportTo((StringBuffer)target);
        }
        throw new IllegalArgumentException();
    }

    public abstract Reader getReader() throws IOException, SQLException;

    public boolean equals(Object obj) {
        boolean isEqual = this == obj;
        try {
            if (!isEqual && obj instanceof LargeVarchar) {
                LargeVarchar objLargeVarchar = (LargeVarchar)obj;
                isEqual = this.getLength() == objLargeVarchar.getLength() && (this.getValue() == null && objLargeVarchar.getValue() == null || this.getValue() != null && objLargeVarchar.getValue() != null && LargeVarchar.compareData(this.getReader(), objLargeVarchar.getReader()));
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        return isEqual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected StringValue customStringValue(StringType stringType, int maxLen) {
        switch (stringType) {
            case DEFAULT: {
                StringValue ret = null;
                try {
                    StringWriter stringWriter = new StringWriter();
                    BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
                    CappedFilterWriter filterWriter = new CappedFilterWriter(bufferedWriter, maxLen);
                    Reader reader = this.getReader();
                    try {
                        LargeVarchar.copyCharacters(reader, filterWriter, 256);
                        return ret;
                    }
                    finally {
                        try {
                            ((Writer)filterWriter).close();
                            ret = new StringValue(stringWriter.toString(), this.getLength());
                        }
                        catch (IOException e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
                        }
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
                        }
                    }
                }
                catch (SQLException e) {
                    if (ret != null && maxLen >= 0 && ret.toString().length() >= maxLen) return ret;
                    throw new DataTypeSQLException(e);
                }
                catch (IOException e) {
                    if (ret != null && maxLen >= 0 && ret.toString().length() >= maxLen) return ret;
                    throw new DataTypeIOException(e);
                }
            }
        }
        return super.customStringValue(stringType, maxLen);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, ValueType valueType, Object target) throws IOException, SQLException {
        switch (valueType) {
            case TARGET: {
                return this.exportTo(target);
            }
        }
        return super.customTypedValue(connectionProvider, valueType, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(DataType datatype, DataValueMarshalHandler hd, String name) throws SAXException {
        try {
            Reader reader = this.getReader();
            try {
                hd.bodyDataValue(datatype, name, reader);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        }
        catch (SQLException e) {
            throw new DataTypeSQLException(e);
        }
        catch (IOException e) {
            throw new DataTypeIOException(e);
        }
    }

    public static void copyCharacters(Reader reader, Writer writer) throws IOException {
        LargeVarchar.copyCharacters(reader, writer, 2400);
    }

    public static void copyCharacters(Reader reader, Writer writer, int bufferSize) throws IOException {
        char[] buf = new char[bufferSize];
        int len = reader.read(buf);
        while (len != -1) {
            writer.write(buf, 0, len);
            len = reader.read(buf);
        }
    }

    public static void copyCharacters(Reader reader, StringBuffer buffer) throws IOException {
        DataTypesUtil.copyCharacters((Readable)reader, buffer, 2400);
    }

    public static void copyCharacters(Reader reader, StringBuffer buffer, int bufferSize) throws IOException {
        DataTypesUtil.copyCharacters((Readable)reader, buffer, bufferSize);
    }

    public static void copyCharacters(Reader reader, StringBuilder buffer) throws IOException {
        DataTypesUtil.copyCharacters((Readable)reader, buffer, 2400);
    }

    public static void copyCharacters(Reader reader, StringBuilder buffer, int bufferSize) throws IOException {
        DataTypesUtil.copyCharacters((Readable)reader, buffer, bufferSize);
    }

    public static boolean compareData(Reader r1, Reader r2) throws IOException {
        return DataTypesUtil.compareData(r1, r2);
    }

    public abstract class LargeVarcharBuilder
    extends LargeDatum.LargeDatumBuilder {
        protected Writer writer;

        protected LargeVarcharBuilder(Writer writer, int cutOverLen) {
            super(LargeVarchar.this, cutOverLen);
            this.writer = writer;
        }

        public LargeVarcharBuilder write(char[] chars, int start, int len) throws IOException {
            this.checkForCutOver(len);
            this.writer.write(chars, start, len);
            this.length += (long)len;
            return this;
        }

        public LargeVarcharBuilder write(Reader reader) throws IOException {
            char[] buf = new char[2400];
            int len = reader.read(buf);
            while (len != -1) {
                this.write(buf, 0, len);
                len = reader.read(buf);
            }
            return this;
        }
    }
}

