/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeEncodingException;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;
import oracle.dbtools.raptor.datatypes.objects.LargeDatum;
import oracle.dbtools.raptor.datatypes.util.CappedFilterWriter;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.util.encoding.Decoder;
import oracle.dbtools.util.encoding.EncodingException;
import oracle.dbtools.util.encoding.EncodingFactory;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.dbtools.util.encoding.HEXEncoding;
import oracle.dbtools.util.encoding.MimeType;
import org.xml.sax.SAXException;

public abstract class LargeBinary
extends LargeDatum {
    protected static final byte FILL_BYTE = 0;

    public LargeBinary() {
    }

    protected LargeBinary(Object value) {
        super(value);
    }

    protected LargeBinary(LargeBinary source) {
        super(source);
    }

    public OutputStream exportTo(OutputStream ostream) throws IOException, SQLException {
        LargeBinary.copyBytes(this.getInputStream(), ostream);
        ostream.flush();
        return ostream;
    }

    public Blob exportTo(Blob blob) throws IOException, SQLException {
        OutputStream ostream = blob.setBinaryStream(1L);
        this.exportTo(ostream);
        ostream.close();
        return blob;
    }

    public File exportTo(File file) throws IOException, SQLException {
        this.exportToObject(file);
        return file;
    }

    public Object exportTo(Object target) throws IOException, SQLException {
        return this.exportToObject(target);
    }

    protected Object exportToObject(Object target) throws IOException, SQLException {
        if (target instanceof OutputStream) {
            return this.exportTo((OutputStream)target);
        }
        if (target instanceof Blob) {
            return this.exportTo((Blob)target);
        }
        if (target instanceof File) {
            return this.exportTo(new FileWriter((File)target));
        }
        throw new IllegalArgumentException();
    }

    public boolean equals(Object obj) {
        boolean isEqual = this == obj;
        try {
            if (!isEqual && obj instanceof LargeBinary) {
                LargeBinary objLargeBinary = (LargeBinary)obj;
                isEqual = this.getLength() == objLargeBinary.getLength() && (this.getValue() == objLargeBinary.getValue() || this.getValue() == null && objLargeBinary.getValue() == null || this.getValue() != null && objLargeBinary.getValue() != null && LargeBinary.compareData(this.getInputStream(), objLargeBinary.getInputStream()));
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        return isEqual;
    }

    public abstract InputStream getInputStream() throws IOException, SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StringValue customStringValue(StringType stringType, int maxLen) {
        switch (stringType) {
            case DEFAULT: {
                StringValue ret = null;
                try {
                    HEXEncoding hexEnc = (HEXEncoding)EncodingFactory.getEncoder(EncodingType.ENCODING_HEX, MimeType.MIME_TEXT);
                    StringWriter stringWriter = new StringWriter();
                    BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
                    CappedFilterWriter filterWriter = new CappedFilterWriter(bufferedWriter, maxLen);
                    InputStream istream = this.getInputStream();
                    try {
                        hexEnc.encode(istream, filterWriter);
                    }
                    finally {
                        try {
                            ((Writer)filterWriter).flush();
                            ret = new StringValue(stringWriter.toString(), hexEnc.getEncodeLength(this.getLength()));
                        }
                        catch (IOException e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
                        }
                        try {
                            istream.close();
                        }
                        catch (IOException e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
                        }
                    }
                }
                catch (SQLException e) {
                    if (ret == null || maxLen < 0 || ret.toString().length() < maxLen) {
                        throw new DataTypeSQLException(e);
                    }
                }
                catch (IOException e) {
                    if (ret == null || maxLen < 0 || ret.toString().length() < maxLen) {
                        throw new DataTypeIOException(e);
                    }
                }
                catch (EncodingException e) {
                    throw new DataTypeEncodingException(e);
                }
                return ret;
            }
        }
        return super.customStringValue(stringType, maxLen);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, ValueType valueType, Object target) throws IOException, SQLException {
        switch (valueType) {
            case TARGET: {
                return this.exportTo(target);
            }
        }
        return super.customTypedValue(connectionProvider, valueType, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(DataType datatype, DataValueMarshalHandler hd, String name) throws SAXException {
        try {
            InputStream istream = this.getInputStream();
            try {
                hd.bodyDataValue(datatype, name, istream);
            }
            finally {
                try {
                    istream.close();
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        }
        catch (SQLException e) {
            throw new DataTypeSQLException(e);
        }
        catch (IOException e) {
            throw new DataTypeIOException(e);
        }
    }

    public static void copyBytes(InputStream istream, OutputStream ostream) throws IOException {
        LargeBinary.copyBytes(istream, ostream, 2400);
    }

    public static void copyBytes(InputStream istream, OutputStream ostream, int bufferSize) throws IOException {
        byte[] buf = new byte[bufferSize];
        int len = istream.read(buf);
        while (len != -1) {
            ostream.write(buf, 0, len);
            len = istream.read(buf);
        }
    }

    public static boolean compareData(InputStream r1, InputStream r2) throws IOException {
        byte[] b1 = new byte[2400];
        byte[] b2 = new byte[2400];
        Arrays.fill(b1, (byte)0);
        Arrays.fill(b2, (byte)0);
        int l1 = r1.read(b1);
        int l2 = r2.read(b2);
        while (l1 != -1 && l2 != -1 && l1 == l2) {
            if (!Arrays.equals(b1, b2)) {
                return false;
            }
            l1 = r1.read(b1);
            l2 = r2.read(b2);
        }
        return l1 == l2;
    }

    public abstract class LargeBinaryBuilder
    extends LargeDatum.LargeDatumBuilder {
        private char[] charBank;
        private int banked;
        protected final Decoder decoder;
        protected final int decoderBlockSize;
        protected OutputStream ostream;
        protected OutputStream switchableStream;

        protected LargeBinaryBuilder(EncodingType encodingType, int cutOverLen) {
            super(cutOverLen);
            this.decoder = EncodingFactory.getDecoder(encodingType, MimeType.MIME_TEXT);
            this.decoderBlockSize = this.decoder.getDecodeBlocksize();
            this.charBank = new char[this.decoderBlockSize];
            this.banked = 0;
            this.ostream = new ByteArrayOutputStream();
            this.switchableStream = new FilterOutputStream(this.ostream){

                @Override
                public void write(int b) throws IOException {
                    LargeBinaryBuilder.this.checkForCutOver(1);
                    this.out = LargeBinaryBuilder.this.ostream;
                    super.write(b);
                    ++LargeBinaryBuilder.this.length;
                }

                @Override
                public void flush() throws IOException {
                    super.flush();
                    LargeBinaryBuilder.this.checkForCutOver(0);
                    this.out = LargeBinaryBuilder.this.ostream;
                    super.flush();
                }

                @Override
                public void close() throws IOException {
                    this.flush();
                    super.close();
                }
            };
        }

        public LargeBinaryBuilder write(char[] chars, int start, int len) throws IOException, EncodingException {
            int remainder;
            int end = start + len;
            int bulkStart = start;
            int bulkLen = len;
            if (this.banked > 0) {
                if (this.banked < this.decoderBlockSize) {
                    while (this.banked < this.decoderBlockSize && bulkStart < end) {
                        this.charBank[this.banked++] = chars[bulkStart++];
                        --bulkLen;
                    }
                }
                if (this.banked >= this.decoderBlockSize) {
                    this.writeBank();
                } else {
                    return this;
                }
            }
            if ((bulkLen -= (remainder = bulkLen % this.decoderBlockSize)) > 0) {
                this.write(new CharArrayReader(chars, bulkStart, bulkLen));
            }
            if (remainder > 0) {
                int remainderOffset = bulkStart + bulkLen;
                for (int i = 0; i < remainder; ++i) {
                    this.charBank[this.banked++] = chars[remainderOffset + i];
                }
            }
            return this;
        }

        public LargeBinaryBuilder write(Reader reader) throws IOException, EncodingException {
            this.decoder.decodeStream(reader, this.switchableStream);
            return this;
        }

        public LargeBinaryBuilder write(byte[] bytes, int start, int len) throws IOException {
            this.switchableStream.write(bytes, start, len);
            return this;
        }

        public LargeBinaryBuilder write(InputStream istream) throws IOException {
            byte[] buf = new byte[2400];
            int len = istream.read(buf);
            while (len != -1) {
                this.write(buf, 0, len);
                len = istream.read(buf);
            }
            return this;
        }

        private void writeBank() throws IOException, EncodingException {
            if (this.banked > 0) {
                this.write(new CharArrayReader(this.charBank, 0, this.banked));
                this.banked = 0;
            }
        }
    }
}

