/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.metadata;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.raptor.datatypes.metadata.ArgMetadata;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public final class SigMetadata {
    final Map<Integer, ArgMetadata> arguments;
    SigIdentifier identifier;
    Integer minArgPosition;
    Integer maxArgPosition;

    public SigMetadata(SigIdentifier identifier, List<ArgMetadata> arguments) {
        this.identifier = identifier;
        this.arguments = new TreeMap<Integer, ArgMetadata>();
        this.minArgPosition = null;
        this.maxArgPosition = null;
        if (arguments != null) {
            for (ArgMetadata argument : arguments) {
                this.addArgument(argument);
            }
        }
    }

    public SigMetadata(SigIdentifier identifier) {
        this(identifier, null);
    }

    public SigIdentifier getIdentifier() {
        return this.identifier;
    }

    public Integer getMinArgPosition() {
        return this.minArgPosition;
    }

    public Integer getMaxArgPosition() {
        return this.maxArgPosition;
    }

    public ArgMetadata getArgument(int position) {
        return this.arguments.get(position);
    }

    boolean addArgument(ArgMetadata argument) {
        if (argument != null) {
            Integer position = argument.identifier.getPosition();
            if (position == null || position < 0) {
                throw new IllegalArgumentException();
            }
            ArgMetadata oldArgument = this.arguments.put(position, argument);
            if (oldArgument != null && oldArgument != argument) {
                this.arguments.put(oldArgument.identifier.getPosition(), oldArgument);
                throw new IllegalArgumentException();
            }
            if (this.minArgPosition == null || this.minArgPosition > position) {
                this.minArgPosition = position;
            }
            if (this.maxArgPosition == null || this.maxArgPosition < position) {
                this.maxArgPosition = position;
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    public int countArguments() {
        return this.arguments.size();
    }

    public Iterator<ArgMetadata> argumentIterator() {
        return this.arguments.values().iterator();
    }

    SigMatch identifiedBy(SigIdentifier identifier) {
        return this.identifier.matches(identifier);
    }

    public static enum SigMatch {
        MATCHED,
        SOFT_MATCHED,
        DIFFERENT;

    }

    public static final class SigIdentifier
    implements Cloneable {
        final Integer overload;
        final Integer objectId;
        final Integer subObjectId;
        static final SigIdentifier NULL_SIG_ID = new SigIdentifier();

        SigIdentifier(Integer overload, Integer objectId, Integer subObjectId) {
            this.overload = overload;
            this.objectId = objectId;
            this.subObjectId = subObjectId;
        }

        SigIdentifier() {
            this(null, null, null);
        }

        public Object clone() {
            return new SigIdentifier(this.overload, this.objectId, this.subObjectId);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SigIdentifier) {
                SigIdentifier other = (SigIdentifier)obj;
                return DataTypesUtil.areEqual(this.overload, other.overload) && DataTypesUtil.areEqual(this.objectId, other.objectId) && DataTypesUtil.areEqual(this.subObjectId, other.subObjectId);
            }
            return false;
        }

        public int hashCode() {
            int hash = 23;
            hash = 31 * hash + (null == this.overload ? 0 : this.overload.hashCode());
            hash = 31 * hash + (null == this.objectId ? 0 : this.objectId.hashCode());
            hash = 31 * hash + (null == this.subObjectId ? 0 : this.subObjectId.hashCode());
            return hash;
        }

        public Integer getOverload() {
            return this.overload;
        }

        public Integer getObjectId() {
            return this.objectId;
        }

        public Integer getSubObjectId() {
            return this.subObjectId;
        }

        SigMatch matches(SigIdentifier identifier) {
            SigIdentifier against;
            SigIdentifier sigIdentifier = against = identifier != null ? identifier : NULL_SIG_ID;
            if (this.objectId == null && this.subObjectId == null) {
                if (DataTypesUtil.areEqual(this.overload, against.overload)) {
                    return SigMatch.SOFT_MATCHED;
                }
            } else if (DataTypesUtil.areEqual(this, against)) {
                return SigMatch.MATCHED;
            }
            return SigMatch.DIFFERENT;
        }
    }
}

