/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes;

import java.text.MessageFormat;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeArb;
import oracle.dbtools.raptor.datatypes.DataTypeException;
import oracle.dbtools.raptor.datatypes.DataValue;

public class DataTypeIllegalArgumentException
extends DataTypeException {
    private static final long serialVersionUID = 1L;

    public DataTypeIllegalArgumentException(DataType dataType, Object value) {
        super(DataTypeIllegalArgumentException.formatMessage(dataType, value));
    }

    public DataTypeIllegalArgumentException(DataType dataType, Object value, Throwable t) {
        super(DataTypeIllegalArgumentException.formatMessage(dataType, value), t);
    }

    public DataTypeIllegalArgumentException(DataValue dataValue) {
        super(DataTypeIllegalArgumentException.formatMessage(dataValue.getName(), dataValue.getDataType()));
    }

    public DataTypeIllegalArgumentException(DataValue dataValue, Throwable t) {
        super(DataTypeIllegalArgumentException.formatMessage(dataValue.getName(), dataValue.getDataType()), t);
    }

    private static String formatMessage(DataType dataType, Object value) {
        return MessageFormat.format(DataTypeArb.getString("ILLEGAL_ARGUMENT_VALUE"), value, dataType.getDataTypeString());
    }

    private static String formatMessage(String name, DataType dataType) {
        if (name == null) {
            return MessageFormat.format(DataTypeArb.getString("ILLEGAL_DATA_CONVERSION"), dataType.getDataTypeString());
        }
        return MessageFormat.format(DataTypeArb.getString("ILLEGAL_NAMED_DATA_CONVERSION"), dataType.getDataTypeString(), name);
    }
}

