/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.graphql.GQLParser;
import oracle.dbtools.parser.js.JavaScript;
import oracle.dbtools.parser.plsql.PlsqlRules;
import oracle.dbtools.parser.plsql.SqlRules;
import oracle.dbtools.util.Service;

public class UnifiedRules {
    private static final String fname = "allRules.txt";
    private static final String path = "/oracle/dbtools/parser/plsql/";
    private static String filePath = "common/src/main/resources/oracle/dbtools/parser/plsql/allRules.txt";

    public static void main(String[] args) throws Exception {
        long t1 = System.currentTimeMillis();
        UnifiedRules.memorizeRules();
        long t2 = System.currentTimeMillis();
        System.out.println("SQL grammar building time = " + (t2 - t1));
    }

    private static void memorizeRules() throws Exception {
        Set<RuleTuple> rules = UnifiedRules.extractRules();
        File file = new File(filePath);
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        for (RuleTuple rule : rules) {
            bw.write(rule.toString() + "\n");
        }
        bw.close();
    }

    public static Set<RuleTuple> getRules() throws Exception {
        Class<PlsqlRules> refClass = PlsqlRules.class;
        URL u = refClass.getResource("/oracle/dbtools/parser/plsql/allRules.txt");
        if (u == null) {
            u = Service.fileNameGitResource(refClass, fname);
        }
        InputStream is = u.openStream();
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        StringTokenizer st = new StringTokenizer(Service.readFile(is), "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            token = token.trim();
            int colonPos = token.indexOf(": ");
            String head = token.substring(0, colonPos);
            StringTokenizer st1 = new StringTokenizer(token.substring(colonPos + ": ".length()), " ");
            LinkedList<String> rhs = new LinkedList<String>();
            while (st1.hasMoreTokens()) {
                rhs.add(st1.nextToken());
            }
            rules.add(new RuleTuple(head, rhs));
        }
        is.close();
        return rules;
    }

    private static Set<RuleTuple> extractRules() throws Exception {
        Set<RuleTuple> ret = PlsqlRules.parseBNFtext(PlsqlRules.readBNFfile());
        String input = Service.readFile(UnifiedRules.class, "SqlPlus.grammar");
        List<LexerToken> src = Lexer.parse(input, false, 49);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        Grammar.grammar(root, src, ret);
        input = Service.readFile(UnifiedRules.class, "DbtoolsExtensions.grammar");
        src = Lexer.parse(input, false, 49);
        root = Grammar.parseGrammarFile(src, input);
        Grammar.grammar(root, src, ret);
        input = Service.readFile(JavaScript.class, "aggregate.rules");
        StringTokenizer st = new StringTokenizer(input, "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int colonPos = (token = token.trim()).indexOf(": ");
            if (colonPos < 0) continue;
            String head = token.substring(0, colonPos).trim();
            StringTokenizer st1 = new StringTokenizer(token.substring(colonPos + ": ".length()), " ");
            LinkedList<String> rhs = new LinkedList<String>();
            while (st1.hasMoreTokens()) {
                String symbol = st1.nextToken().trim();
                if (symbol.charAt(0) == '\'') {
                    symbol = symbol.toUpperCase();
                }
                rhs.add(symbol);
            }
            ret.add(new RuleTuple(head, rhs));
        }
        ret.add(new RuleTuple("javascript", new String[]{"Statement_List1"}));
        ret.addAll(GQLParser.getRules());
        ret.add(new RuleTuple("directive", new String[]{"'@'", "'INSERT'"}));
        ret.add(new RuleTuple("directive", new String[]{"'@'", "'UPDATE'"}));
        ret.add(new RuleTuple("argument", new String[]{"'FROM'", "':'", "value"}));
        input = Service.readFile(UnifiedRules.class, "DataPump.grammar");
        src = Lexer.parse(input, false, 49);
        root = Grammar.parseGrammarFile(src, input);
        Grammar.grammar(root, src, ret);
        input = Service.readFile(UnifiedRules.class, "PlsqlFixes.grammar");
        src = Lexer.parse(input, false, 49);
        root = Grammar.parseGrammarFile(src, input);
        Grammar.grammar(root, src, ret);
        PlsqlRules.fixIdentifierIsOrAs(ret);
        boolean T = true;
        boolean F = false;
        UnifiedRules.printOrderedRules("set_arg", true, true, ret);
        Set<RuleTuple> sql = SqlRules.extractRules();
        ret.addAll(sql);
        ret.add(new RuleTuple("pls_expr", new String[]{"multiset_expression"}));
        for (RuleTuple r : ret) {
            for (String s : r.rhs) {
                if (s.length() < 2) {
                    throw new AssertionError((Object)r.toString());
                }
            }
        }
        RuleTransforms.eliminateEmptyProductions(ret);
        RuleTransforms.substituteSingleUnaryProductions(ret);
        RuleTransforms.intervals2Numbers(ret);
        return ret;
    }

    private static void printOrderedRules(String symbol, boolean headOnly, boolean exactMatch, Set<RuleTuple> ret) {
        for (RuleTuple t : ret) {
            if (!exactMatch && t.head.contains(symbol) || exactMatch && t.head.equals(symbol)) {
                System.out.println("     " + t.toString());
            }
            if (headOnly) continue;
            for (String rhsi : t.rhs) {
                if ((exactMatch || !rhsi.contains(symbol)) && (!exactMatch || !rhsi.equals(symbol))) continue;
                System.out.println(t.toString());
            }
        }
    }
}

