/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.html;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.Token;

public class HtmlParser
extends Parser {
    public boolean debug = false;
    List<LexerToken> src;
    LinkedList<LexerToken> processed;

    @Override
    public ParseNode parse(List<LexerToken> src) {
        this.src = src;
        this.processed = new LinkedList();
        for (LexerToken t : src) {
            this.processed.add(t);
        }
        return this.nodes(0, this.processed.size());
    }

    private ParseNode nodes(int from, int to) {
        ParseNode node = this.node(from, to);
        if (node == null) {
            return null;
        }
        if (node.to == to) {
            node.addContent(this.processGrammarSymbol("nodes"));
            return node;
        }
        ParseNode ret = new ParseNode(from, to, this.processGrammarSymbol("nodes"), this);
        ret.addTopLevel(node);
        ParseNode nodes = this.nodes(node.to, to);
        if (nodes == null) {
            node.addContent(this.processGrammarSymbol("nodes"));
            return node;
        }
        ret.addTopLevel(nodes);
        ret.to = nodes.to;
        return ret;
    }

    private ParseNode node(int from, int to) {
        ParseNode nodes;
        ParseNode ret = new ParseNode(from, to, this.processGrammarSymbol("node"), this);
        ParseNode openTag = this.openTag(from, to);
        if (openTag == null) {
            return null;
        }
        ret.addTopLevel(openTag);
        ParseNode tag = null;
        for (ParseNode child : openTag.children()) {
            if (!child.contains("dashedId")) continue;
            tag = child;
            break;
        }
        if ((nodes = this.nodes(from = openTag.to, to)) != null) {
            ret.addTopLevel(nodes);
            from = nodes.to;
        }
        ParseNode closeTag = this.closeTag(from, to, tag.content(this.src));
        ret.addTopLevel(closeTag);
        ret.to = closeTag.to;
        return ret;
    }

    private ParseNode openTag(int from, int to) {
        Sequence did = new Sequence("openTag", true);
        did.addForward(new Keyword("<"));
        did.addForward(this.dashedId());
        did.addForward(this.equalities());
        did.addForward(new Optional(new Identifier()));
        did.addForward(new Keyword(">"));
        ParseNode ret = did.apply(from, to);
        return ret;
    }

    private ParseNode closeTag(int from, int to, String match) {
        Sequence did = new Sequence("closeTag", true);
        did.addForward(new Keyword("<"));
        did.addForward(new Keyword("/"));
        did.addForward(this.dashedId());
        did.addForward(new Keyword(">"));
        ParseNode ret = did.apply(from, to);
        ParseNode tag = null;
        for (ParseNode child : ret.children()) {
            if (!child.contains("dashedId")) continue;
            tag = child;
            break;
        }
        if (!match.equals(tag.content(this.src))) {
            throw new AssertionError((Object)("openTag:" + match + "!= closedTag:" + tag.content(this.src)));
        }
        return ret;
    }

    private Sequence equalities() {
        Sequence did = new Sequence("equalities", false);
        int repeat = 10;
        did.addForward(this.equality());
        for (int i = 0; i < repeat; ++i) {
            did.addForward(this.equality());
        }
        return did;
    }

    private Sequence equality() {
        Sequence did = new Sequence("equality", true);
        did.addForward(this.dashedId());
        did.addForward(new Keyword("="));
        did.addForward(new Identifier());
        return did;
    }

    private Sequence dashedId() {
        Sequence did = new Sequence("dashedId", false);
        int repeat = 5;
        did.addForward(new Identifier());
        for (int i = 0; i < repeat; ++i) {
            did.addForward(new Keyword("-"));
            did.addForward(new Identifier());
        }
        return did;
    }

    public int processGrammarSymbol(String symbol) {
        Integer ii = (Integer)this.symbolIndexes.get(symbol);
        if (ii == null) {
            ii = this.allSymbols.length;
            this.allSymbols = Arrays.copyOf(this.allSymbols, this.allSymbols.length + 1);
            this.symbolIndexes.put(symbol, ii);
            this.allSymbols[ii.intValue()] = symbol;
        }
        return ii;
    }

    class Optional
    extends ParsedGrammarSymbol {
        ParsedGrammarSymbol payload;

        public Optional(ParsedGrammarSymbol payload) {
            super(payload.symbol);
            this.payload = payload;
        }

        @Override
        ParseNode apply(int from, int to) {
            ParseNode ret = this.payload.apply(from, to);
            return ret;
        }
    }

    class Sequence
    extends ParsedGrammarSymbol {
        boolean knownLength;
        List<ParsedGrammarSymbol> forward;

        public Sequence(String operation, boolean knownLength) {
            super(operation);
            this.forward = new LinkedList<ParsedGrammarSymbol>();
            this.knownLength = knownLength;
        }

        public void addForward(ParsedGrammarSymbol o) {
            this.forward.add(o);
        }

        @Override
        public ParseNode apply(int from, int to) {
            if ("equality".equals(this.symbol)) {
                System.out.println();
            }
            ParseNode ret = new ParseNode(from, to, HtmlParser.this.processGrammarSymbol(this.symbol), HtmlParser.this);
            ParseNode prior = null;
            int pos = from;
            for (ParsedGrammarSymbol o : this.forward) {
                ParseNode p = o.apply(pos, to);
                if (p == null) {
                    if (o instanceof Optional) continue;
                    if (!this.knownLength) break;
                    this.restoreProcessed(from);
                    return null;
                }
                ret.addTopLevel(p);
                pos = p.to;
                prior = p;
            }
            if (prior == null) {
                this.restoreProcessed(from);
                return null;
            }
            ret.to = prior.to;
            if (HtmlParser.this.debug) {
                System.out.println("ret=" + ret.toString());
            }
            return ret;
        }

        private void restoreProcessed(int from) {
            LexerToken p1 = HtmlParser.this.processed.peekFirst();
            for (int ii = 0; ii < HtmlParser.this.src.size() && p1 != HtmlParser.this.src.get(ii); ++ii) {
            }
            for (int i = ii - 1; from <= i; --i) {
                HtmlParser.this.processed.addFirst(HtmlParser.this.src.get(i));
            }
        }

        @Override
        public String toString() {
            return super.toString() + (this.knownLength ? " known length" : "");
        }
    }

    class Keyword
    extends ParsedGrammarSymbol {
        public Keyword(String operation) {
            super(operation);
        }

        @Override
        ParseNode apply(int from, int to) {
            LexerToken op = null;
            op = HtmlParser.this.processed.peekFirst();
            if (op.type != Token.OPERATION) {
                return null;
            }
            if (!op.content.equals(this.symbol)) {
                return null;
            }
            to = from + 1;
            HtmlParser.this.processed.removeFirst();
            return new ParseNode(from, to, HtmlParser.this.processGrammarSymbol("'" + this.symbol + "'"), HtmlParser.this);
        }
    }

    class Identifier
    extends ParsedGrammarSymbol {
        public Identifier() {
            super("identifier");
        }

        @Override
        ParseNode apply(int from, int to) {
            LexerToken id = null;
            id = HtmlParser.this.processed.peekFirst();
            if (id.type != Token.IDENTIFIER && id.type != Token.DQUOTED_STRING) {
                return null;
            }
            to = from + 1;
            HtmlParser.this.processed.removeFirst();
            return new ParseNode(from, to, HtmlParser.this.processGrammarSymbol("identifier"), HtmlParser.this);
        }
    }

    abstract class ParsedGrammarSymbol {
        String symbol;

        public ParsedGrammarSymbol(String symbol) {
            this.symbol = symbol;
        }

        abstract ParseNode apply(int var1, int var2);

        public String toString() {
            return "symbol=" + this.symbol;
        }
    }
}

