/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class RuleTransforms {
    public static Set<String> dubiousEmptyProductions = new HashSet<String>();

    private static void log(Set<RuleTuple> delete, Set<RuleTuple> add) {
        boolean debug = true;
        debug = false;
        if (debug) {
            System.out.println("---:");
            RuleTuple.printRules(delete);
            System.out.println("+++:");
            RuleTuple.printRules(add);
            System.out.println();
        }
    }

    public static void removeRules(String head, Set<RuleTuple> src) {
        TreeSet<RuleTuple> tmp = new TreeSet<RuleTuple>();
        for (RuleTuple candidate : src) {
            if (!head.equals(candidate.head)) continue;
            tmp.add(candidate);
        }
        src.removeAll(tmp);
    }

    public static void substituteSingleBinaryProductions(Set<RuleTuple> src) {
        while (true) {
            TreeSet<RuleTuple> delete = new TreeSet<RuleTuple>();
            TreeSet<RuleTuple> add = new TreeSet<RuleTuple>();
            for (RuleTuple c1 : src) {
                if (!c1.head.endsWith(")") && !c1.head.endsWith("#") || c1.head.contains("___") || c1.rhs.length != 2) continue;
                boolean ok = true;
                for (RuleTuple c2 : src) {
                    if (!c1.head.equals(c2.head) || c1.equals(c2)) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                delete.add(c1);
                System.out.println(">>> " + c1.toString());
                for (RuleTuple c2 : src) {
                    String[] tmp = new String[c2.rhs.length * 2];
                    int pos = 0;
                    for (int i = 0; i < c2.rhs.length; ++i) {
                        if (c2.rhs[i].equals(c1.head)) {
                            tmp[pos++] = c1.rhs[0];
                            tmp[pos++] = c1.rhs[1];
                            continue;
                        }
                        tmp[pos++] = c2.rhs[i];
                    }
                    if (pos == c2.rhs.length) continue;
                    delete.add(c2);
                    String[] rhs = new String[pos];
                    for (int i = 0; i < rhs.length; ++i) {
                        rhs[i] = tmp[i];
                    }
                    add.add(new RuleTuple(c2.head, rhs));
                }
            }
            if (delete.size() == 0) break;
            RuleTransforms.log(delete, add);
            src.removeAll(delete);
            src.addAll(add);
        }
    }

    public static void substituteSingleUnaryProductions(Set<RuleTuple> src) {
        if (src.size() == 1) {
            return;
        }
        while (true) {
            TreeSet<RuleTuple> delete = new TreeSet<RuleTuple>();
            TreeSet<RuleTuple> add = new TreeSet<RuleTuple>();
            for (RuleTuple c1 : src) {
                if ("javascript".equals(c1.head)) continue;
                if ("javascript".equals(c1.head)) {
                    System.out.println("######################## " + c1.toString());
                }
                if (c1.rhs.length != 1 || c1.head.contains("___")) continue;
                if (c1.rhs[0].equals(c1.head)) {
                    delete.add(c1);
                    continue;
                }
                boolean ok = true;
                for (RuleTuple c2 : src) {
                    if (!c1.head.equals(c2.head) || c1.equals(c2)) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                delete.add(c1);
                System.out.println(">>> " + c1.toString());
                for (RuleTuple c2 : src) {
                    String[] rhs = new String[c2.rhs.length];
                    ok = false;
                    for (int i = 0; i < c2.rhs.length; ++i) {
                        if (c2.rhs[i].equals(c1.head)) {
                            rhs[i] = c1.rhs[0];
                            ok = true;
                            continue;
                        }
                        rhs[i] = c2.rhs[i];
                    }
                    if (!ok) continue;
                    delete.add(c2);
                    add.add(new RuleTuple(c2.head, rhs));
                }
            }
            if (delete.size() == 0) break;
            RuleTransforms.log(delete, add);
            src.removeAll(delete);
            src.addAll(add);
        }
    }

    public static void eliminateEmptyProductions(Set<RuleTuple> src) {
        while (true) {
            TreeSet<RuleTuple> delete = new TreeSet<RuleTuple>();
            TreeSet<RuleTuple> add = new TreeSet<RuleTuple>();
            String head = null;
            for (RuleTuple c1 : src) {
                if (head != null || c1.rhs.length != 0) continue;
                head = c1.head;
                delete.add(c1);
                if (head.contains("[")) break;
                dubiousEmptyProductions.add(head);
                break;
            }
            if (head == null) break;
            boolean isSingular = true;
            for (RuleTuple c1 : src) {
                if (c1.rhs.length == 0 || !head.equals(c1.head)) continue;
                isSingular = false;
                break;
            }
            for (RuleTuple c2 : src) {
                int matched = 0;
                for (String rhs : c2.rhs) {
                    if (!rhs.equals(head)) continue;
                    ++matched;
                }
                if (matched == 0) continue;
                if (isSingular) {
                    delete.add(c2);
                }
                if (matched > 2) {
                    throw new AssertionError((Object)("head = " + head + " matched " + c2.toString()));
                }
                if (matched == 1) {
                    String[] tmp = new String[c2.rhs.length - 1];
                    int i = 0;
                    int j = 0;
                    while (i < tmp.length) {
                        if (c2.rhs[i].equals(head)) {
                            ++j;
                        }
                        tmp[i] = c2.rhs[j];
                        ++i;
                        ++j;
                    }
                    if (c2.head.equals("expr#")) {
                        System.out.println();
                    }
                    add.add(new RuleTuple(c2.head, tmp));
                }
                if (matched != 2) continue;
                String[] tmp11 = new String[c2.rhs.length - 2];
                String[] tmp01 = new String[c2.rhs.length - 1];
                String[] tmp10 = new String[c2.rhs.length - 1];
                int i = 0;
                int j = 0;
                while (i < tmp11.length) {
                    if (c2.rhs[i].equals(head)) {
                        ++j;
                    }
                    tmp11[i] = c2.rhs[j];
                    ++i;
                    ++j;
                }
                i = 0;
                j = 0;
                while (i < tmp10.length) {
                    if (i == j && c2.rhs[i].equals(head)) {
                        ++j;
                    }
                    tmp10[i] = c2.rhs[j];
                    ++i;
                    ++j;
                }
                boolean matchedOnce = false;
                int i2 = 0;
                int j2 = 0;
                while (i2 < tmp01.length) {
                    if (!matchedOnce && c2.rhs[i2].equals(head)) {
                        matchedOnce = true;
                    } else if (matchedOnce && c2.rhs[i2].equals(head)) {
                        ++j2;
                    }
                    tmp01[i2] = c2.rhs[j2];
                    ++i2;
                    ++j2;
                }
                if (c2.head.equals("expr#")) {
                    System.out.println();
                }
                add.add(new RuleTuple(c2.head, tmp11));
                add.add(new RuleTuple(c2.head, tmp01));
                add.add(new RuleTuple(c2.head, tmp10));
            }
            if (delete.size() == 0 && add.size() == 0) break;
            RuleTransforms.log(delete, add);
            src.addAll(add);
            src.removeAll(delete);
        }
    }

    public static void injectMissingEmptyProductions(Set<RuleTuple> src) {
        HashSet<String> heirs = new HashSet<String>();
        for (String s : dubiousEmptyProductions) {
            System.out.println("injecting " + s);
            TreeSet<RuleTuple> add = new TreeSet<RuleTuple>();
            for (RuleTuple c2 : src) {
                int matched = 0;
                for (String rhs : c2.rhs) {
                    if (!rhs.equals(s)) continue;
                    ++matched;
                }
                if (matched == 0) continue;
                if (matched > 1) {
                    throw new AssertionError((Object)("head = " + s + " matched " + c2.toString()));
                }
                if (c2.rhs.length == 1) {
                    heirs.add(c2.head);
                }
                String[] tmp = new String[c2.rhs.length - 1];
                int i = 0;
                int j = 0;
                while (i < tmp.length) {
                    if (c2.rhs[i].equals(s)) {
                        ++j;
                    }
                    tmp[i] = c2.rhs[j];
                    ++i;
                    ++j;
                }
                add.add(new RuleTuple(c2.head, tmp));
            }
            System.out.println("++**++:");
            RuleTuple.printRules(add);
            System.out.println();
            src.addAll(add);
        }
        dubiousEmptyProductions = heirs;
    }

    public static void printRulesHierachy(String name, Set<RuleTuple> rules) {
        System.out.println("-------------Rules Hierachy------------");
        int prefixEnd = name.indexOf(91);
        LinkedList<RuleTuple> subset = new LinkedList<RuleTuple>();
        for (RuleTuple rule : rules) {
            if (!rule.head.startsWith(prefixEnd > 0 ? name.substring(0, prefixEnd) : name)) continue;
            subset.add(rule);
        }
        RuleTransforms.printRule(name, subset, 0);
        System.out.println("-------------------------------------");
    }

    private static void printRule(String name, List<RuleTuple> subset, int offset) {
        for (RuleTuple rule : subset) {
            if (!rule.head.equals(name)) continue;
            Service.identln(offset, rule.toString());
            for (int i = 0; i < rule.rhs.length; ++i) {
                RuleTransforms.printRule(rule.rhs[i], subset, offset + 1);
            }
        }
    }

    public static void print(Set<RuleTuple> rules) {
        for (RuleTuple r : rules) {
            System.out.println(r.toString() + ";");
        }
    }

    public static void printSelectedRules(String name, Set<RuleTuple> rules) {
        System.out.println("-------------Rules---------------");
        for (RuleTuple rule : rules) {
            if (!rule.toString().contains(name)) continue;
            System.out.println(rule.toString());
        }
        System.out.println("-------------------------------------");
    }

    public static boolean isEmptyHead(String head, Set<RuleTuple> output) {
        boolean ret = RuleTransforms.emptyClosure(output).contains(head);
        return ret;
    }

    private static Set<String> emptyClosure(Set<RuleTuple> output) {
        HashSet<String> ret = new HashSet<String>();
        for (RuleTuple t : output) {
            if (t.rhs.length != 0) continue;
            ret.add(t.head);
        }
        while (true) {
            HashSet<String> increment = new HashSet<String>();
            for (RuleTuple t : output) {
                boolean add = true;
                for (String rhs : t.rhs) {
                    if (ret.contains(rhs)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                increment.add(t.head);
            }
            if (ret.containsAll(increment)) break;
            ret.addAll(increment);
        }
        return ret;
    }

    public static void inject(RuleTuple[] rules, Set<RuleTuple> input) {
        TreeSet<RuleTuple> add = new TreeSet<RuleTuple>();
        TreeSet<RuleTuple> delete = new TreeSet<RuleTuple>();
        block0: for (RuleTuple r : input) {
            block1: for (RuleTuple r1 : rules) {
                if (r.rhs.length <= 0 + r1.rhs.length) continue;
                for (int i = 0; i < r1.rhs.length; ++i) {
                    if (!r.rhs[i].equals(r1.rhs[i])) continue block1;
                }
                delete.add(r);
                String[] rhs = new String[r.rhs.length - r1.rhs.length + 1];
                rhs[0] = r1.head;
                for (int i = 1; i < r.rhs.length - r1.rhs.length + 1; ++i) {
                    rhs[i] = r.rhs[i + r1.rhs.length - 1];
                }
                add.add(new RuleTuple(r.head, rhs));
                continue block0;
            }
        }
        for (RuleTuple r : rules) {
            input.add(r);
        }
        input.addAll(add);
        input.removeAll(delete);
    }

    public static void intervals2Numbers(Set<RuleTuple> ret) {
        TreeMap<String, CallSite> renaming = new TreeMap<String, CallSite>();
        String separator = "___";
        for (RuleTuple r : ret) {
            int iP;
            int end;
            int pos = r.head.lastIndexOf("[");
            if (pos < 0 || (end = r.head.lastIndexOf(")")) < 0 || renaming.containsKey(r.head)) continue;
            String prefix = r.head.substring(0, pos);
            Object postfix = r.head.substring(end + 1);
            int iDQuote = r.head.lastIndexOf("\"");
            if (iDQuote + 1 == pos) {
                prefix = r.head.substring(0, pos - 1);
                postfix = (String)postfix + "\"";
            }
            if ((iP = r.head.lastIndexOf("#")) + 1 == pos) {
                prefix = r.head.substring(0, pos - 1);
                postfix = (String)postfix + "#";
            }
            int cnt = 0;
            for (String key : renaming.keySet()) {
                String value = (String)renaming.get(key);
                if (!value.startsWith(prefix + "___") || !value.endsWith((String)postfix)) continue;
                ++cnt;
            }
            renaming.put(r.head, (CallSite)((Object)(prefix + "___" + cnt + (String)postfix)));
        }
        for (String key : renaming.keySet()) {
            System.out.println(key + "---->>>>" + (String)renaming.get(key));
        }
        for (RuleTuple r : ret) {
            for (String key : renaming.keySet()) {
                r.renameSymbols(key, (String)renaming.get(key));
            }
        }
    }

    public static Map<Integer, Integer> topNbyProductionCounts(Parser.Tuple[] src, int n) {
        HashMap<Integer, Integer> tmp = new HashMap<Integer, Integer>();
        for (Parser.Tuple r : src) {
            Integer cnt = (Integer)tmp.get(r.head);
            if (cnt == null) {
                cnt = 0;
            }
            Integer n2 = cnt;
            Integer n3 = cnt = Integer.valueOf(cnt + 1);
            tmp.put(r.head, cnt);
        }
        HashMap<Integer, Integer> topN = new HashMap<Integer, Integer>();
        for (Integer h : tmp.keySet()) {
            if (topN.size() < n) {
                topN.put(h, (Integer)tmp.get(h));
                continue;
            }
            Integer delete = null;
            for (Integer cmp : topN.keySet()) {
                if ((Integer)tmp.get(cmp) >= (Integer)tmp.get(h)) continue;
                if (delete != null) {
                    if ((Integer)tmp.get(cmp) >= (Integer)tmp.get(delete)) continue;
                    delete = cmp;
                    continue;
                }
                delete = cmp;
            }
            if (delete == null) continue;
            topN.remove(delete);
            topN.put(h, (Integer)tmp.get(h));
        }
        return topN;
    }

    public static void main(String[] args) {
        int n = Integer.parseInt(JOptionPane.showInputDialog("N = "));
        SqlEarley earley = SqlEarley.getInstance();
        System.out.println("production cnt = " + earley.rules.length);
        System.out.println("===================");
        Map<Integer, Integer> top10 = RuleTransforms.topNbyProductionCounts(earley.rules, n);
        int sum = 0;
        for (int h : top10.keySet()) {
            System.out.println(h + "=" + earley.allSymbols[h] + ": " + top10.get(h));
            sum += top10.get(h).intValue();
        }
        System.out.println("===================");
        System.out.println("aggregate cnt = " + sum);
    }
}

