/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.TableRenderer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;
import oracle.dbtools.util.HtmlTreeTableWidget;

public class ExplainPlan
extends CodeLens {
    static final String normalTitle = "Explain plan";
    List<LexerToken> full;
    String sql;
    Statement stmt = null;
    private Object conn = null;

    public ExplainPlan(ParseNode node, BackgroundParser parser) {
        super(node, normalTitle, parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeCommand() {
        if (this.stmt != null) {
            try {
                this.stmt.cancel();
                this.command.title = normalTitle;
                this.parser.documentBump();
                String string = "OK";
                return string;
            }
            catch (SQLException e) {
                if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                    LSP.Log.log(Level.SEVERE, e.getMessage(), e);
                }
                ResponseError responseError = new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), this.stmt);
                return responseError;
            }
            finally {
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                        this.stmt = null;
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        this.parser.waitForLexingFinish();
        this.full = new ArrayList<LexerToken>();
        this.full.addAll(this.parser.src);
        String s = this.parser.text.substring(this.full.get((int)this.node.from).begin, this.full.get((int)(this.node.to - 1)).end);
        s = s.trim();
        if (s.endsWith(";")) {
            s = s.substring(0, s.length() - 1);
        }
        this.sql = s;
        this.conn = this.parser.getRegistry().getConnection();
        if (this.conn == null || !(this.conn instanceof Connection)) {
            return new ResponseError(-32603, "Not connected", this.parser.languageServer.getLastUrl());
        }
        try {
            this.stmt = ((Connection)this.conn).createStatement();
            String setStmtTd = "SET STATEMENT_ID =";
            String SQL2 = this.sql.toUpperCase();
            String stmtId = "" + System.currentTimeMillis();
            if (!SQL2.contains("SET STATEMENT_ID =")) {
                int insPoint = SQL2.indexOf("FOR");
                this.sql = this.sql.substring(0, insPoint) + "SET STATEMENT_ID ='" + stmtId + "'  " + this.sql.substring(insPoint);
            }
            this.stmt.execute(this.sql);
            String query = "select SYS_CONNECT_BY_PATH(id, '.') \"Path\",/*id,parent_id,*/OPERATION,OBJECT_NAME,OPTIONS,CARDINALITY,COST  from plan_table \nCONNECT BY prior id = parent_id\n        AND prior statement_id = statement_id\n  START WITH id = 0\n        AND statement_id = '" + stmtId + "'\n  ORDER BY id";
            this.query(query);
            return "OK";
        }
        catch (Exception e) {
            if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                LSP.Log.log(Level.SEVERE, e.getMessage(), e);
            }
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void query(String sql) {
        LanguageServer server = this.parser.languageServer;
        ResultSet rs = null;
        try {
            rs = this.stmt.executeQuery(sql);
            boolean oldSilent = this.parser.getRenderer().isSilent;
            TableRenderer oldRenderer = this.parser.getRenderer();
            this.parser.getRenderer().isSilent = false;
            this.parser.setRenderer(TableRenderer.factory("simple grid", this.parser));
            String content = this.createHtmlWidget(rs).render();
            String fileExt = ".explainPlan.grid";
            String lastUrl = this.parser.docUrl;
            String uri = lastUrl.substring(1, lastUrl.length() - 1) + fileExt;
            String url = "\"" + uri + "\"";
            server.getLSP().createFile(uri, content);
            this.parser.getRenderer().isSilent = oldSilent;
            this.parser.setRenderer(oldRenderer);
            this.parser.getRenderer().jsCallback = null;
            server.logStatement(sql);
            LSP.windowShowMessage("Query finished", 3);
        }
        catch (Exception e) {
            if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                LSP.Log.log(Level.SEVERE, e.getMessage(), e);
            }
            if (e instanceof SQLException) {
                this.parser.failedCommand(this.node, e);
            }
        }
        finally {
            server.documentsBump();
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                    this.stmt = null;
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public HtmlTreeTableWidget createHtmlWidget(ResultSet rs) throws SQLException {
        HtmlTreeTableWidget ttw = new HtmlTreeTableWidget();
        ResultSetMetaData meta = rs.getMetaData();
        ttw.columnNames = new String[meta.getColumnCount() - 1];
        for (int i = 0; i < meta.getColumnCount() - 1; ++i) {
            ttw.columnNames[i] = meta.getColumnName(i + 2);
        }
        while (rs.next()) {
            String[] row = new String[ttw.columnNames.length];
            for (int i = 0; i < row.length; ++i) {
                row[i] = rs.getString(i + 2);
            }
            ttw.append(null, row, rs.getString(1), null, null);
        }
        return ttw;
    }
}

