/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.ResultSet;
import java.sql.Statement;
import oracle.dbtools.db.ResultSetHolder;
import oracle.dbtools.db.ResultSetTracker;

public final class ResultSetWrapper {
    private ResultSetHolder m_holder;

    ResultSetWrapper(ResultSetHolder holder) {
        this.m_holder = holder;
    }

    public ResultSet getResultSet() {
        return this.m_holder.getResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ResultSetHolder holder = null;
        ResultSetWrapper resultSetWrapper = this;
        synchronized (resultSetWrapper) {
            ResultSetTracker.untrackResultSet(this);
            holder = this.m_holder;
            this.m_holder = null;
        }
        if (holder != null) {
            holder.close();
        }
    }

    ResultSetHolder getHolder() {
        return this.m_holder;
    }

    public static ResultSetWrapper createWrapper(ResultSet rs, Statement stmt) {
        assert (rs != null);
        ResultSetHolder holder = new ResultSetHolder(rs, stmt);
        ResultSetWrapper wrapper = new ResultSetWrapper(holder);
        ResultSetTracker.trackResultSet(wrapper);
        return wrapper;
    }
}

