/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.loadservice;

import java.util.Locale;
import oracle.dbtools.data.common.TranslatableMessage;
import oracle.dbtools.data.loadservice.LoadResources;

public enum ExitCode {
    EXIT_SUCCESS(0),
    EXIT_WARNING(1),
    EXIT_ERROR(2),
    EXIT_SEVERE(3);

    private int _severity;
    private String _detailMessage = "";
    private String _shortMessage = "";

    private ExitCode(int severity) {
        this._severity = severity;
    }

    public String toStringTranslated() {
        return LoadResources.getString(this.name());
    }

    public String toStringTranslated(Iterable<Locale> locales) {
        if (locales == null) {
            return LoadResources.getString(this.name());
        }
        return new TranslatableMessage(LoadResources.class, this.name(), LoadResources.getString(this.name()), new Object[0]).toString(locales);
    }

    public int getSeverity() {
        return this._severity;
    }

    public String getMessage() {
        return this._detailMessage;
    }

    public void setMessage(String detailMessage) {
        this._detailMessage = detailMessage;
    }

    public String getShortMessage() {
        return this._shortMessage;
    }

    public void setShortMessage(String shortMessage) {
        this._shortMessage = shortMessage;
    }
}

