/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.dap.DebugAdapter;
import oracle.dbtools.dap.ErrorResponse;
import oracle.dbtools.dap.ProtocolMessage;
import oracle.dbtools.dap.Request;
import oracle.dbtools.dap.Response;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.json.Interpreter;
import oracle.dbtools.parser.json.JsonEarley;
import oracle.dbtools.parser.json.NamedValue;
import oracle.dbtools.parser.json.Util;

public class DAP {
    public static boolean logMessages = true;
    static final Charset UTF_8 = StandardCharsets.UTF_8;
    public static final String cancelResponse = "cancelResponse";
    long rseq = 1L;
    long eseq = 1L;
    private Map<Integer, Boolean> applied = new HashMap<Integer, Boolean>();
    ArrayBlockingQueue<ProtocolMessage> pending = new ArrayBlockingQueue(10);
    LinkedList<Long> cancelled = new LinkedList();
    private static DebugAdapter server = null;
    private OutputStream send;
    private boolean readingFromStream;
    public static final Logger LOG = Logger.getLogger("main");
    static int port = 4712;
    private static ServerSocket socket = null;

    private String readHeader(InputStream client) {
        StringBuilder line = new StringBuilder();
        char next = this.read(client);
        int cnt = 0;
        while (true) {
            if (next == '\r') {
                char last = this.read(client);
                assert (last == '\n');
                if (cnt != 0) break;
                ++cnt;
                next = this.read(client);
                continue;
            }
            line.append(next);
            next = this.read(client);
        }
        return line.toString();
    }

    private int parseHeader(String header) {
        String contentLength = "Content-Length: ";
        if (header.startsWith(contentLength)) {
            String tail = header.substring(contentLength.length());
            return Integer.parseInt(tail);
        }
        return -1;
    }

    private char read(InputStream client) {
        try {
            int c = client.read();
            if (c == -1) {
                LOG.warning("Stream from DAP client has been closed, throwing kill exception...");
                throw new EndOfStream();
            }
            return (char)c;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            throw new EndOfStream();
        }
    }

    private String readLength(InputStream client, int byteLength) {
        char next = this.read(client);
        while (Character.isWhitespace(next)) {
            next = this.read(client);
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (true) {
            result.append(next);
            if (++i == byteLength) break;
            next = this.read(client);
        }
        return result.toString();
    }

    String nextToken(InputStream client) {
        String line = this.readHeader(client);
        int maybeLength = this.parseHeader(line);
        if (maybeLength != -1) {
            line = this.readLength(client, maybeLength);
            return line;
        }
        throw new AssertionError((Object)"maybeLength == -1");
    }

    ProtocolMessage parseMessage(String token) throws Exception {
        Object log = token;
        if (1000 < ((String)log).length()) {
            log = ((String)log).substring(0, 1000) + "...";
        }
        if (logMessages) {
            System.out.println("dap >>> " + (String)log);
        }
        Request ret = null;
        NamedValue tmp = new Interpreter().eval(token);
        List<NamedValue> elements = tmp.composite;
        for (NamedValue el : elements) {
            if ("\"command\"".equals(el.name)) {
                String name = el.atomic;
                if (name.charAt(0) == '\"' && name.charAt(0) == '\"') {
                    name = name.substring(1, name.length() - 1);
                }
                ret = new Request();
                ret.command = name;
            }
            if ("\"arguments\"".equals(el.name)) {
                if (ret == null) {
                    ret = new Request();
                }
                ((Request)ret).arguments = el;
            }
            if ("\"type\"".equals(el.name)) {
                if (ret == null) {
                    if ("\"request\"".equals(el.atomic)) {
                        ret = new Request();
                    } else if ("...".equals(el.atomic)) {
                        ret = new Request();
                    }
                }
                if (!ret.type.equals(el.atomic)) {
                    throw new AssertionError((Object)("ret.type=" + ret.type + " != el.atomic=" + el.atomic));
                }
            }
            if (!"\"seq\"".equals(el.name)) continue;
            ret.seq = Integer.parseInt(el.valueString());
        }
        return ret;
    }

    protected void writeClient(OutputStream client, String messageText) {
        byte[] messageBytes = messageText.getBytes(UTF_8);
        String headerText = String.format("Content-Length: %d\r\n\r\n", messageBytes.length);
        byte[] headerBytes = headerText.getBytes(UTF_8);
        try {
            client.write(headerBytes);
            client.write(messageBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void respond(long requestId, String command, Object params) {
        if (cancelResponse.equals(params)) {
            LOG.log(Level.INFO, "requestId = " + requestId + "   canceled");
            return;
        }
        String jsonText = Util.toJson(params);
        String messageText = new Response(this.rseq, requestId, true, command, null, jsonText).toJson();
        ++this.rseq;
        Object log = messageText;
        if (2000 < ((String)log).length()) {
            log = ((String)log).substring(0, 2000) + "...";
        }
        if (logMessages) {
            System.out.println("   dap <<<  " + (String)log);
        }
        this.writeClientSafely(this.getSend(), messageText, requestId);
    }

    void error(long requestId, String command, String error) {
        String messageText = new ErrorResponse(this.rseq, requestId, command, error).toJson();
        ++this.rseq;
        Object log = messageText;
        if (2000 < ((String)log).length()) {
            log = ((String)log).substring(0, 2000) + "...";
        }
        if (logMessages) {
            System.out.println("   dap error <<<  " + (String)log);
        }
        this.writeClientSafely(this.getSend(), messageText, requestId);
    }

    void error(String error) {
        LOG.log(Level.SEVERE, error);
    }

    void event(String event, Object body) {
        String jsonText = Util.toJson(body);
        String messageText = String.format("{\"seq\":%d,\"type\":\"event\",\"event\":\"%s\"" + (String)(jsonText != null ? ",\"body\":" + jsonText : "") + "}", this.eseq++, event);
        Object log = messageText;
        if (2000 < ((String)log).length()) {
            log = ((String)log).substring(0, 2000) + "...";
        }
        if (logMessages) {
            System.out.println("   event:  " + (String)log);
        }
        this.writeClientSafely(this.getSend(), messageText, -1L);
    }

    public void notifyClient(OutputStream client, String method, Object params) {
        String jsonText = Util.toJson(params);
        String messageText = String.format("{\"jsonrpc\":\"2.0\",\"method\":\"%s\",\"params\":%s}", method, jsonText);
        Object log = messageText;
        if (1000 < ((String)log).length()) {
            log = ((String)log).substring(0, 1000) + "...";
        }
        if (logMessages) {
            System.out.println("FIXME: sent to client>> " + (String)log);
        }
    }

    private void writeClientSafely(OutputStream client, String messageText, long requestId) {
        long t1;
        block6: {
            t1 = System.currentTimeMillis();
            if (messageText.length() < 100000) {
                try {
                    List<LexerToken> src = LexerToken.parse(messageText, false, 161);
                    Parsed target = new Parsed(messageText, src, JsonEarley.jsonParser(), "top");
                    if (target.getSyntaxError() != null) {
                        this.error("Invalid JSON in response");
                        break block6;
                    }
                    this.writeClient(client, messageText);
                }
                catch (IOException e) {
                    this.error(e.getMessage());
                }
            } else {
                this.writeClient(client, messageText);
            }
        }
        long t2 = System.currentTimeMillis();
        if (t1 + 100L < t2) {
            System.err.println("JSON parse time = " + (t2 - t1));
        }
    }

    static DebugAdapter getServer() {
        return server;
    }

    public OutputStream getSend() {
        return this.send;
    }

    void connect(final InputStream receive, OutputStream send) {
        this.send = send;
        Program.resetCompiledPrograms();
        server = new DebugAdapter(this, this.getSend());
        this.pending = new ArrayBlockingQueue(10);
        final ProtocolMessage endOfStream = new ProtocolMessage();
        if (receive != null) {
            this.readingFromStream = true;
            class MessageReader
            implements Runnable {
                MessageReader() {
                }

                private boolean kill() {
                    LOG.info("Read stream has been closed, putting kill message onto queue...");
                    try {
                        DAP.this.pending.put(endOfStream);
                        return true;
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Failed to put kill message onto queue, will try again...", e);
                        return false;
                    }
                }

                @Override
                public void run() {
                    LOG.info("Placing incoming messages on queue...");
                    while (true) {
                        try {
                            while (true) {
                                String token;
                                if ("Connection: close" == (token = DAP.this.nextToken(receive)) && this.kill()) {
                                    return;
                                }
                                DAP.this.acceptLspRequestImpl(token);
                            }
                        }
                        catch (EndOfStream e) {
                            if (!this.kill()) continue;
                            return;
                        }
                        catch (Throwable e) {
                            LOG.log(Level.SEVERE, e.getMessage(), e);
                            continue;
                        }
                        break;
                    }
                }
            }
            Thread reader = new Thread((Runnable)new MessageReader(), "reader");
            reader.setDaemon(true);
            reader.start();
        }
        LOG.info("Reading messages from queue...");
        while (true) {
            ProtocolMessage rr;
            ProtocolMessage r = null;
            try {
                r = this.pending.poll(100L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            if (r == null) continue;
            if (r.equals(endOfStream)) {
                LOG.warning("Stream from client has been closed, exiting...");
                throw new RuntimeException("VT: exit");
            }
            if (r instanceof ErrorResponse) {
                rr = (ErrorResponse)r;
                LOG.log(Level.SEVERE, "Not a request:" + rr.toJson());
                continue;
            }
            if (r instanceof Request) {
                rr = (Request)r;
                if (5 < this.cancelled.size()) {
                    LOG.log(Level.INFO, "cancelled.size()=" + this.cancelled.size());
                }
                if (this.cancelled.contains(((Request)rr).seq)) {
                    this.cancelled.remove(((Request)rr).seq);
                    if (!logMessages) continue;
                    System.out.println("cancelled request " + ((Request)rr).seq);
                    continue;
                }
                try {
                    Object response;
                    if (((Request)rr).command.equals("cancel")) {
                        response = server.cancel(((Request)rr).arguments);
                        long seq = Long.parseLong((String)response);
                        this.cancelled.addLast(seq);
                        this.respond(r.seq, ((Request)rr).command, null);
                    }
                    if (((Request)rr).command.equals("configurationDone")) {
                        response = server.configurationDone(((Request)rr).arguments);
                        if (response instanceof Exception) {
                            this.error(r.seq, ((Request)rr).command, ((Exception)response).getMessage());
                        }
                        this.respond(r.seq, ((Request)rr).command, response);
                    }
                    if (((Request)rr).command.equals("continue")) {
                        response = server.resume(((Request)rr).arguments);
                        this.respond(r.seq, ((Request)rr).command, response);
                    }
                    if (((Request)rr).command.equals("initialize")) {
                        response = server.initialize(((Request)rr).arguments);
                        this.respond(r.seq, ((Request)rr).command, response);
                        Thread.sleep(300L);
                        this.event("initialized", null);
                    }
                    if (((Request)rr).command.equals("launch") || ((Request)rr).command.equals("attach")) {
                        response = server.launch(((Request)rr).arguments);
                        this.respond(r.seq, ((Request)rr).command, response);
                    }
                    if (((Request)rr).command.equals("next")) {
                        response = server.next(((Request)rr).arguments);
                        this.respond(r.seq, ((Request)rr).command, response);
                    }
                    if (((Request)rr).command.equals("setBreakpoints")) {
                        response = server.setBreakpoints(((Request)rr).arguments);
                        this.respond(r.seq, ((Request)rr).command, response);
                    }
                    if (((Request)rr).command.equals("setExceptionBreakpoints")) {
                        response = server.setExceptionBreakpoints(((Request)rr).arguments);
                        this.respond(r.seq, ((Request)rr).command, response);
                    }
                    if (((Request)rr).command.equals("stackTrace")) {
                        response = server.stackTrace(((Request)rr).arguments);
                        this.respond(r.seq, ((Request)rr).command, response);
                    }
                    if (((Request)rr).command.equals("scopes")) {
                        response = server.scopes(((Request)rr).arguments);
                        this.respond(r.seq, ((Request)rr).command, response);
                    }
                    if (((Request)rr).command.equals("stepIn")) {
                        response = server.stepIn(((Request)rr).arguments);
                        this.respond(r.seq, ((Request)rr).command, response);
                    }
                    if (((Request)rr).command.equals("threads")) {
                        response = server.threads();
                        this.respond(r.seq, ((Request)rr).command, response);
                    }
                    if (((Request)rr).command.equals("variables")) {
                        response = server.variables();
                        this.respond(r.seq, ((Request)rr).command, response);
                    }
                    if (((Request)rr).command.equals("evaluate")) {
                        response = server.evaluate(((Request)rr).arguments);
                        if (response instanceof Exception) {
                            this.error(r.seq, ((Request)rr).command, ((Exception)response).getMessage());
                        }
                        this.respond(r.seq, ((Request)rr).command, response);
                    }
                    if (((Request)rr).command.equals("disconnect")) {
                        response = server.disconnect(((Request)rr).arguments);
                        this.respond(r.seq, ((Request)rr).command, response);
                        throw new EndOfStream();
                    }
                    throw new Exception("Unrecognized method " + ((Request)rr).command);
                }
                catch (EndOfStream e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                    this.error(r.seq, ((Request)rr).command, e.getMessage());
                }
                continue;
            }
            LOG.log(Level.SEVERE, r.getClass().getName() + " not instance of Request");
        }
    }

    public ProtocolMessage acceptLspRequest(String jsonRpc) throws Exception, InterruptedException {
        if (this.readingFromStream || null == this.pending) {
            throw new IllegalStateException("Programmer Error(usage): Cannot accept a request directly if reading from an inputStream or if the queue is not initialized (created during LSP.connect)");
        }
        return this.acceptLspRequestImpl(jsonRpc);
    }

    private ProtocolMessage acceptLspRequestImpl(String jsonRpc) throws Exception, InterruptedException {
        ProtocolMessage message = this.parseMessage(jsonRpc);
        this.maybeProcessCancel(message);
        if (message.isProcessable()) {
            this.pending.put(message);
        }
        return message;
    }

    private void maybeProcessCancel(ProtocolMessage message) {
    }

    public boolean messageApplied(int rid) {
        for (int i = 0; i < 20; ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.applied.containsKey(rid)) continue;
            return this.applied.get(rid);
        }
        throw new AssertionError((Object)"timeout");
    }

    public static void main(String[] args) throws Exception {
        if (socket != null) {
            return;
        }
        String input = null;
        if (1 == args.length) {
            input = args[0];
        }
        if (input != null) {
            port = Integer.parseInt(input);
        }
        socket = new ServerSocket(port);
        while (true) {
            try {
                while (true) {
                    System.out.println("Listening port# " + port);
                    Socket connection = socket.accept();
                    new DAP().connect(connection.getInputStream(), connection.getOutputStream());
                }
            }
            catch (EndOfStream tri) {
                System.out.println("End of stream: reinit");
                continue;
            }
            catch (Throwable tri) {
                System.err.println("Fatal error handling request: " + tri.getMessage() + " -- reinit");
                continue;
            }
            break;
        }
    }

    static class EndOfStream
    extends RuntimeException {
        EndOfStream() {
        }
    }
}

