/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.arbori.AggregatePredicate;
import oracle.dbtools.arbori.AncestorDescendantNodes;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.EqualExpr;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class MaterializedPredicate
implements Predicate {
    Map<String, Integer> attributePositions = new HashMap<String, Integer>();
    ArrayList<String> attributes;
    Set<Tuple> tuples = new TreeSet<Tuple>();
    List<LexerToken> src;
    Program program = null;
    String name = null;

    public MaterializedPredicate(ArrayList<String> attributes, List<LexerToken> src, String name) {
        this.name = name;
        this.attributes = attributes;
        for (int i = 0; i < attributes.size(); ++i) {
            this.attributePositions.put(attributes.get(i), i);
        }
        this.src = src;
    }

    public MaterializedPredicate(String name, MaterializedPredicate src) {
        this.name = name;
        this.attributes = src.attributes;
        this.attributePositions = src.attributePositions;
        this.tuples = src.tuples;
        this.src = src.src;
        this.program = src.program;
    }

    public Set<Tuple> getTuples() {
        return this.tuples;
    }

    @Override
    public boolean eval(Map<String, Integer> attributePositions, ParseNode[] tuple, List<LexerToken> src, Map<String, Attribute> varDefs) {
        throw new AssertionError((Object)"N/A");
    }

    @Override
    public void variables(Set<String> ret, boolean optimizeEqs) {
        ret.addAll(this.attributes);
    }

    @Override
    public void signature(Set<String> ret) {
        this.variables(ret, false);
    }

    @Override
    public Predicate isRelated(String var1, String var2, Map<String, Attribute> varDefs) {
        throw new AssertionError((Object)"N/A");
    }

    public void add(Map<String, ParseNode> vector) {
        ParseNode[] tuple = new ParseNode[this.attributes.size()];
        for (int i = 0; i < tuple.length; ++i) {
            tuple[i] = vector.get(this.attributes.get(i));
        }
        this.tuples.add(new Tuple(tuple));
    }

    void addContent(ParseNode[] tuple) {
        if (this.program != null && this.program.stop) {
            throw new AssertionError((Object)"Arbori program stop requested");
        }
        this.tuples.add(new Tuple(tuple));
    }

    public ParseNode getAttribute(Tuple tuple, String attribute) {
        Integer attrPos = this.getAttribute(attribute);
        if (attrPos == null) {
            throw new AssertionError((Object)("Missing " + this.name + "." + attribute));
        }
        return tuple.values[attrPos];
    }

    public String getAttribute(int colPos) {
        return this.attributes.get(colPos);
    }

    public Integer getAttribute(String colName) {
        Integer ret = this.attributePositions.get(colName);
        if (ret != null) {
            return ret;
        }
        if (this.name != null && colName.startsWith(this.name)) {
            ret = this.attributePositions.get(colName.substring(this.name.length() + 1));
        }
        return ret;
    }

    public int arity() {
        return this.attributes.size();
    }

    public int cardinality() {
        return this.tuples.size();
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int ident) {
        StringBuilder ret = new StringBuilder("");
        if (this.name != null) {
            ret = new StringBuilder(this.name + "=");
        }
        ret.append("[");
        for (int i = 0; i < this.attributes.size(); ++i) {
            ret.append((i > 0 ? "         " : "") + this.attributes.get(i));
        }
        ret.append("]\n");
        for (Tuple t : this.tuples) {
            boolean firstTuple = true;
            for (int i = 0; i < this.attributes.size(); ++i) {
                Object value = "N/A (null)";
                ParseNode node = t.values[i];
                if (node != null) {
                    value = "[" + t.values[i].from + "," + t.values[i].to + ")";
                }
                ret.append(firstTuple ? Service.identln(ident, " ") : "  ");
                ret.append((String)value);
                ret.append(" ");
                if (node != null) {
                    ret.append(MaterializedPredicate.mnemonics(node.from, node.to, this.src));
                }
                firstTuple = false;
            }
            ret.append("\n");
        }
        return ret.toString();
    }

    @Override
    public MaterializedPredicate eval(Parsed target) {
        return this;
    }

    public static MaterializedPredicate union(MaterializedPredicate x, MaterializedPredicate y) {
        ParseNode[] retTuple;
        ArrayList<String> header = new ArrayList<String>();
        header.addAll(x.attributes);
        header.retainAll(y.attributes);
        MaterializedPredicate ret = new MaterializedPredicate(header, x.src, null);
        ret.program = x.program;
        for (Tuple tupleX : x.tuples) {
            retTuple = new ParseNode[header.size()];
            for (String attr : ret.attributes) {
                retTuple[ret.attributePositions.get((Object)attr).intValue()] = tupleX.values[x.attributePositions.get(attr)];
            }
            ret.addContent(retTuple);
        }
        for (Tuple tupleY : y.tuples) {
            retTuple = new ParseNode[header.size()];
            for (String attr : ret.attributes) {
                retTuple[ret.attributePositions.get((Object)attr).intValue()] = tupleY.values[y.attributePositions.get(attr)];
            }
            ret.addContent(retTuple);
        }
        return ret;
    }

    public static MaterializedPredicate join(MaterializedPredicate x, MaterializedPredicate y) {
        ArrayList<String> header = new ArrayList<String>();
        header.addAll(x.attributes);
        for (String s : y.attributes) {
            if (x.attributes.contains(s)) continue;
            header.add(s);
        }
        MaterializedPredicate ret = new MaterializedPredicate(header, x.src, null);
        ret.program = x.program;
        for (Tuple tupleX : x.tuples) {
            for (Tuple tupleY : y.tuples) {
                ParseNode[] retTuple = new ParseNode[header.size()];
                for (String attr : ret.attributes) {
                    Integer iY;
                    Integer iX;
                    Integer xAttr = iX = x.attributePositions.get(attr);
                    Integer yAttr = iY = y.attributePositions.get(attr);
                    Integer iRet = ret.attributePositions.get(attr);
                    if (xAttr == null) {
                        retTuple[iRet.intValue()] = tupleY.values[iY];
                        continue;
                    }
                    if (yAttr == null) {
                        retTuple[iRet.intValue()] = tupleX.values[iX];
                        continue;
                    }
                    if (tupleY.values[iY.intValue()].from != tupleX.values[iX.intValue()].from || tupleY.values[iY.intValue()].to != tupleX.values[iX.intValue()].to) {
                        retTuple = null;
                        break;
                    }
                    retTuple[iRet.intValue()] = tupleX.values[iX];
                }
                if (retTuple == null) continue;
                ret.addContent(retTuple);
            }
        }
        return ret;
    }

    public static MaterializedPredicate difference(MaterializedPredicate x, MaterializedPredicate y) {
        ArrayList<String> header = new ArrayList<String>();
        header.addAll(x.attributes);
        MaterializedPredicate ret = new MaterializedPredicate(header, x.src, null);
        ret.program = x.program;
        for (Tuple tupleX : x.tuples) {
            boolean foundMatch = false;
            for (Tuple tupleY : y.tuples) {
                boolean tuplesMatch = true;
                for (String attr : y.attributes) {
                    Integer iY = y.attributePositions.get(attr);
                    Integer iX = x.attributePositions.get(attr);
                    if (iX == null || tupleY.values[iY.intValue()].from == tupleX.values[iX.intValue()].from && tupleY.values[iY.intValue()].to == tupleX.values[iX.intValue()].to) continue;
                    tuplesMatch = false;
                    break;
                }
                if (!tuplesMatch) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            ret.tuples.add(tupleX);
        }
        return ret;
    }

    public void trimAttributes() {
        HashMap<String, Integer> trimmedAttributePositions = new HashMap<String, Integer>();
        ArrayList<String> trimmedAttributes = new ArrayList<String>();
        for (int i = 0; i < this.attributes.size(); ++i) {
            String attribute = this.attributes.get(i);
            int pos = attribute.lastIndexOf(46);
            if (0 < pos) {
                attribute = attribute.substring(pos + 1);
            }
            if (trimmedAttributePositions.containsKey(attribute) && 0 < pos) {
                return;
            }
            trimmedAttributePositions.put(attribute, i);
            trimmedAttributes.add(attribute);
        }
        this.attributePositions = trimmedAttributePositions;
        this.attributes = trimmedAttributes;
    }

    /*
     * WARNING - void declaration
     */
    public static MaterializedPredicate filteredCartesianProduct(MaterializedPredicate x, MaterializedPredicate y, Predicate filter, Map<String, Attribute> varDefs, ParseNode root, List<LexerToken> src) {
        Attribute attr;
        ArrayList<String> allVariables = new ArrayList<String>();
        block2: for (String z : varDefs.keySet()) {
            attr = varDefs.get(z);
            for (String string : x.attributes) {
                void var11_11;
                if (x.name != null && string.indexOf(46) < 0) {
                    String string2 = x.name + "." + string;
                }
                if (!attr.isDependent((String)var11_11, varDefs)) continue;
                allVariables.add(z);
                continue block2;
            }
        }
        block4: for (String z : varDefs.keySet()) {
            if (allVariables.contains(z)) continue;
            attr = varDefs.get(z);
            for (String string : y.attributes) {
                void var11_17;
                if (y.name != null && string.indexOf(46) < 0) {
                    String string3 = y.name + "." + string;
                }
                if (!attr.isDependent((String)var11_17, varDefs)) continue;
                allVariables.add(z);
                continue block4;
            }
        }
        if (filter instanceof AncestorDescendantNodes) {
            AncestorDescendantNodes loop = (AncestorDescendantNodes)filter;
            if (null == y.getAttribute(loop.d)) {
                MaterializedPredicate tmp = x;
                x = y;
                y = tmp;
            }
        }
        MaterializedPredicate ret = new MaterializedPredicate(allVariables, x.src, null);
        ret.program = x.program;
        for (Tuple tupleY : y.tuples) {
            Set<Tuple> innerLoop = x.tuples;
            if (filter instanceof AncestorDescendantNodes) {
                AncestorDescendantNodes ancestorDescendantNodes = (AncestorDescendantNodes)filter;
                try {
                    Attribute attr2;
                    Integer index = y.getAttribute(ancestorDescendantNodes.d);
                    if (index == null && (attr2 = varDefs.get(ancestorDescendantNodes.d)) instanceof EqualExpr) {
                        EqualExpr eExpr = (EqualExpr)attr2;
                        String d = eExpr.def;
                        int pos = d.indexOf(46);
                        if (0 < pos) {
                            d = d.substring(pos + 1);
                            index = y.getAttribute(d);
                        }
                    }
                    innerLoop = ancestorDescendantNodes.innerLoop(tupleY.values[index], x);
                }
                catch (AssertionError index) {
                    // empty catch block
                }
            }
            for (Tuple tupleX : innerLoop) {
                ParseNode[] retTuple = new ParseNode[allVariables.size()];
                LinkedList<String> mismatchedAttributes = new LinkedList<String>();
                for (int i = 0; i < retTuple.length; ++i) {
                    String attr3 = ret.getAttribute(i);
                    Integer j = x.attributePositions.get(attr3);
                    if (j != null) {
                        retTuple[i] = tupleX.values[j];
                        continue;
                    }
                    j = y.attributePositions.get(attr3);
                    if (j != null) {
                        retTuple[i] = tupleY.values[j];
                        continue;
                    }
                    int dotPos = attr3.indexOf(46);
                    if (0 < dotPos) {
                        String refPred = attr3.substring(0, dotPos);
                        String simpleName = attr3.substring(dotPos + 1);
                        if (x.name != null && x.name.equals(refPred)) {
                            j = x.attributePositions.get(simpleName);
                            if (j != null) {
                                retTuple[i] = tupleX.values[j];
                                continue;
                            }
                        } else if (y.name != null && y.name.equals(refPred) && (j = y.attributePositions.get(simpleName)) != null) {
                            retTuple[i] = tupleY.values[j];
                            continue;
                        }
                    }
                    mismatchedAttributes.add(attr3);
                }
                for (String attr4 : mismatchedAttributes) {
                    Set<Tuple> tmp = new TreeSet<Tuple>();
                    tmp.add(new Tuple(retTuple));
                    tmp = ret.assignDependencyChain(attr4, tmp, varDefs, root, src);
                    if (1 < tmp.size()) {
                        throw new AssertionError((Object)"1 < tmp.size()");
                    }
                    for (Tuple p : tmp) {
                        if (retTuple != p.values) {
                            throw new AssertionError((Object)"retTuple != p");
                        }
                    }
                }
                if (!filter.eval(ret.attributePositions, retTuple, x.src, varDefs)) continue;
                ret.addContent(retTuple);
            }
        }
        for (String v1 : allVariables) {
            for (String string : allVariables) {
                Predicate p;
                if (v1.compareTo(string) <= 0 || !((p = filter.isRelated(v1, string, varDefs)) instanceof AncestorDescendantNodes)) continue;
                AncestorDescendantNodes ad = (AncestorDescendantNodes)p;
                if (ad.type != AncestorDescendantNodes.Type.CLOSEST) continue;
                Integer col = ret.getAttribute(ad.a);
                if (col == null) {
                    throw new AssertionError((Object)("Predicate " + ret.name + " doesn't have " + ad.a + " attribute"));
                }
                AggregatePredicate ap = new AggregatePredicate(ad.a, ret.getAttribute(ad.d), filter);
                MaterializedPredicate ret1 = new MaterializedPredicate(allVariables, x.src, null);
                for (Tuple tuple : ret.tuples) {
                    ap.eval(tuple, ret1.tuples, col);
                }
                return ret1;
            }
        }
        return ret;
    }

    public static MaterializedPredicate filter(MaterializedPredicate x, Predicate filter, Map<String, Attribute> varDefs, ParseNode root) {
        HashSet<String> signature = new HashSet<String>();
        filter.signature(signature);
        ArrayList<String> header = MaterializedPredicate.disambigute(signature);
        Map<String, Integer> xAttributePositions = x.attributePositions;
        if (x.name != null) {
            HashMap<String, Integer> tmp = new HashMap<String, Integer>();
            for (String attr : xAttributePositions.keySet()) {
                tmp.put(x.name + "." + attr, xAttributePositions.get(attr));
            }
            xAttributePositions = tmp;
        }
        MaterializedPredicate ret = new MaterializedPredicate(header, x.src, null);
        ret.program = x.program;
        for (Tuple tupleX : x.tuples) {
            if (!filter.eval(xAttributePositions, tupleX.values, x.src, varDefs)) continue;
            ParseNode[] projectedTuple = new ParseNode[header.size()];
            for (int ix = 0; ix < tupleX.values.length; ++ix) {
                int pos;
                String colName = x.getAttribute(ix);
                Integer ip = ret.attributePositions.get(colName);
                if (ip == null && 0 < (pos = colName.indexOf(46)) && signature.contains(colName)) {
                    ip = ret.attributePositions.get(colName.substring(pos + 1));
                }
                if (ip == null) continue;
                projectedTuple[ip.intValue()] = tupleX.values[ix];
            }
            for (int ip = 0; ip < projectedTuple.length; ++ip) {
                if (projectedTuple[ip] != null) continue;
                String ixName = ret.getAttribute(ip);
                Attribute ax = varDefs.get(ixName);
                if (ax == null) {
                    ax = varDefs.get(x.name + "." + ixName);
                }
                projectedTuple[ip] = ax.lookup(xAttributePositions, tupleX.values, varDefs);
            }
            ret.addContent(projectedTuple);
        }
        return ret;
    }

    private static ArrayList<String> disambigute(Set<String> signature) {
        HashMap<String, String> names = new HashMap<String, String>();
        Iterator<String> iterator = signature.iterator();
        while (iterator.hasNext()) {
            String candidate;
            String name = candidate = iterator.next();
            int pos = candidate.indexOf(46);
            if (0 < pos) {
                name = name.substring(pos + 1);
            }
            if (names.containsKey(name)) {
                names.put(name, candidate);
                continue;
            }
            names.put(name, name);
        }
        ArrayList<String> ret = new ArrayList<String>();
        Iterator<String> iterator2 = signature.iterator();
        while (iterator2.hasNext()) {
            String tmp;
            String candidate;
            String name = candidate = iterator2.next();
            int pos = candidate.indexOf(46);
            if (0 < pos) {
                name = name.substring(pos + 1);
            }
            if (0 < (tmp = (String)names.get(name)).indexOf(46)) {
                ret.add(candidate);
                continue;
            }
            ret.add(name);
        }
        return ret;
    }

    Set<Tuple> assignDependencyChain(String name, Set<Tuple> candidates, Map<String, Attribute> varDefs, ParseNode root, List<LexerToken> src) {
        if (candidates.size() == 0) {
            return candidates;
        }
        Iterator<Tuple> iterator = candidates.iterator();
        if (iterator.hasNext()) {
            Tuple t = iterator.next();
            ParseNode cell = t.values[this.attributePositions.get(name)];
            if (cell != null) {
                return candidates;
            }
        }
        Attribute attr = varDefs.get(name);
        attr.src = src;
        Attribute ref = attr.referredTo(varDefs);
        if (ref == null) {
            return candidates;
        }
        candidates = this.assignDependencyChain(ref.name, candidates, varDefs, root, src);
        return attr.eval(this.attributePositions, candidates, root);
    }

    @Override
    public Map<String, Boolean> dependencies() {
        return new HashMap<String, Boolean>();
    }

    public static String tupleMnemonics(Map<String, ParseNode> tuple, List<LexerToken> src) {
        return MaterializedPredicate.tupleMnemonics(tuple, src, false);
    }

    public static String tupleMnemonics(Map<String, ParseNode> tuple, List<LexerToken> src, boolean independentOnly) {
        StringBuilder ret = new StringBuilder();
        int num = -1;
        for (String attribute : tuple.keySet()) {
            if (independentOnly && (0 <= attribute.indexOf(94) || 0 <= attribute.indexOf(43) || 0 <= attribute.indexOf(45))) continue;
            if (0 < ++num) {
                ret.append(",  ");
            }
            ret.append(attribute + " = ");
            ParseNode node = tuple.get(attribute);
            if (node != null) {
                ret.append("[" + node.from + "," + node.to + ")");
            }
            ret.append(" ");
            if (node == null) continue;
            ret.append(MaterializedPredicate.mnemonics(node.from, node.to, src));
        }
        return ret.toString();
    }

    public static String mnemonics(int from, int to, List<LexerToken> src) {
        int _8 = 8;
        if (from + 1 == to) {
            return Service.padln(_8 + 2 < src.get((int)from).content.length() ? src.get((int)from).content.substring(0, _8 + 2) : src.get((int)from).content, _8 + 2);
        }
        StringBuilder ret = new StringBuilder("\"");
        for (int i = from; i < to && i < from + _8; ++i) {
            String token = src.get((int)i).content.toUpperCase();
            String t = token.substring(0, 1).toLowerCase();
            for (int j = 0; j < SqlEarley.keywords.length; ++j) {
                if (!SqlEarley.keywords[j].substring(1, SqlEarley.keywords[j].length() - 1).equals(token)) continue;
                t = t.toUpperCase();
                break;
            }
            ret.append(t);
        }
        ret.append('\"');
        return Service.padln(ret.toString(), _8 + 2);
    }

    @Override
    public void adjustIsFunFlag(Set<String> independentAttributes) {
    }
}

