/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection0;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.app.injection0.DependencyLink;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class SqlInjection {
    static SqlProgram programInstance = null;
    public Parsed target = null;
    public Map<Integer, Integer> dependencyLinks = new TreeMap<Integer, Integer>();
    public Map<Integer, ParseNode> parseNode2Scope = new TreeMap<Integer, ParseNode>();
    public List<Integer> params = new LinkedList<Integer>();
    public List<Integer> execs = new LinkedList<Integer>();

    public static void main(String[] args) throws Exception {
        String input = Service.readFile(SqlInjection.class, "test.sql");
        boolean isBig = 10000 < input.length();
        SqlEarley.visualize = false;
        if (!isBig) {
            SqlEarley.main(new String[]{input});
        }
        Program.timing = isBig;
        long t1 = System.currentTimeMillis();
        SqlInjection inject = SqlInjection.findDependencies(input);
        for (int p : inject.params) {
            for (int e : inject.execs) {
                String vars;
                ParseNode se;
                ParseNode ss = inject.parseNode2Scope.get(p);
                if (ss != (se = inject.parseNode2Scope.get(e)) || (vars = inject.dependencyStr(p, e)) == null) continue;
                System.out.println("SQL Injection dependency: " + vars);
                LinkedList<Integer> dependencyChain = inject.dependencyChain(p, e);
                System.out.println("-------------------------------------------");
                int from = inject.target.getSrc().get((int)dependencyChain.getLast().intValue()).begin - 50;
                if (from < 0) {
                    from = 0;
                }
                int to = inject.target.getSrc().get((int)dependencyChain.getLast().intValue()).begin + 50;
                if (input.length() < to) {
                    to = input.length();
                }
                System.out.println(input.substring(from, to));
                System.out.println("===========================================");
            }
        }
        long t2 = System.currentTimeMillis();
        System.out.println("Exec time = " + (t2 - t1));
    }

    public static SqlInjection findDependencies(String input) throws SyntaxError {
        return SqlInjection.findDependencies(input, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlInjection findDependencies(String input, List<LexerToken> src, ParseNode root) throws SyntaxError {
        SqlInjection inject = new SqlInjection(){};
        try {
            if (programInstance == null) {
                String injectionPrg = Service.readFile(SqlInjection.class, "sqlinjection.arbori");
                programInstance = new SqlProgram(injectionPrg){};
            }
            if (src != null) {
                inject.target = new Parsed(input, src, root);
            } else {
                src = Lexer.parse(input);
                inject.target = new Parsed(input, src, (Earley)SqlEarley.getInstance(), new String[]{"parse with errors"});
            }
            programInstance.eval(inject.target, inject);
        }
        catch (SyntaxError e) {
            throw e;
        }
        catch (AssertionError e) {
            System.err.println(((Throwable)((Object)e)).getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inject;
    }

    void put(int key, int value, ParseNode scope, Parsed target) {
        this.dependencyLinks.put(key, value);
        this.parseNode2Scope.put(key, scope);
        this.parseNode2Scope.put(value, scope);
    }

    public LinkedList<Integer> dependencyChain(int startPos) {
        for (int e : this.execs) {
            LinkedList<Integer> ret;
            ParseNode se;
            ParseNode ss = this.parseNode2Scope.get(startPos);
            if (ss != (se = this.parseNode2Scope.get(e)) || (ret = this.dependencyChain(startPos, e)) == null) continue;
            return ret;
        }
        return null;
    }

    public LinkedList<Integer> dependencyChain(int startPos, int endPos) {
        List<LexerToken> src = this.target.getSrc();
        LinkedList<Integer> chain = new LinkedList<Integer>();
        chain.add(startPos);
        if (this.tryDependency(startPos, endPos, chain)) {
            return chain;
        }
        return null;
    }

    private boolean tryDependency(int startPos, int endPos, LinkedList<Integer> chain) {
        List<LexerToken> src = this.target.getSrc();
        int curPos = chain.getLast();
        if (src.get((int)endPos).content.equals(src.get((int)curPos).content)) {
            if (endPos != curPos) {
                chain.add(endPos);
            }
            return true;
        }
        for (int k : this.dependencyLinks.keySet()) {
            ParseNode csk;
            ParseNode sk = this.parseNode2Scope.get(k);
            if (sk != (csk = this.parseNode2Scope.get(curPos)) || !src.get((int)k).content.equals(src.get((int)curPos).content) || chain.contains(k)) continue;
            int value = this.dependencyLinks.get(k);
            chain.add(value);
            boolean ret = this.tryDependency(startPos, endPos, chain);
            if (ret) {
                return true;
            }
            chain.removeLast();
        }
        return false;
    }

    public String dependencyStr(int startPos) {
        for (int e : this.execs) {
            String ret = this.dependencyStr(startPos, e);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public String dependencyStr(int startPos, int endPos) {
        LinkedList<Integer> dependencyChain = this.dependencyChain(startPos, endPos);
        if (dependencyChain == null) {
            return null;
        }
        StringBuilder vars = new StringBuilder();
        int pos = 0;
        Iterator iterator = dependencyChain.iterator();
        while (iterator.hasNext()) {
            int curPos = (Integer)iterator.next();
            String varName = this.target.getSrc().get((int)curPos).content;
            int lineNo = Service.charPos2LineNo(this.target.getInput(), this.target.getSrc().get((int)curPos).begin);
            if (0 < pos++) {
                vars.append(" -> ");
            }
            vars.append(varName + "@line#" + lineNo);
        }
        return vars.toString();
    }

    public void printDependencies() {
        System.out.println("+++++++++++++");
        for (int k : this.params) {
            System.out.println(this.dependencyStr(k));
        }
    }

    public List<List<DependencyLink>> getInjections() {
        ArrayList<List<DependencyLink>> result = new ArrayList<List<DependencyLink>>();
        for (int k = 0; k < this.params.size(); ++k) {
            String depStr = this.dependencyStr(this.params.get(k));
            if (depStr == null) continue;
            ArrayList<DependencyLink> oneInjection = new ArrayList<DependencyLink>();
            for (String oneLink : depStr.split(" -> ", 0)) {
                String[] varSplit = oneLink.split("@line#", 2);
                oneInjection.add(new DependencyLink(varSplit[0], Integer.parseInt(varSplit[1]), -1, -1));
            }
            result.add(oneInjection);
        }
        return result;
    }

    public void assignments(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode key = tuple.get("key");
        ParseNode value = tuple.get("value");
        ParseNode scope = tuple.get("scope");
        this.put(key.from, value.from, scope, target);
    }

    public void declarations(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode key = tuple.get("key");
        ParseNode value = tuple.get("value");
        ParseNode scope = tuple.get("scope");
        this.put(key.from, value.from, scope, target);
    }

    public void parametersInScope(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode scope = tuple.get("scope");
        ParseNode an = tuple.get("arg_name");
        this.params.add(an.from);
        this.parseNode2Scope.put(an.from, scope);
    }

    public void executionsInScope(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode scope = tuple.get("scope");
        ParseNode sv = tuple.get("sqlVar");
        this.execs.add(sv.from);
        this.parseNode2Scope.put(sv.from, scope);
    }
}

