/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.js.JavaScript;
import oracle.dbtools.parser.js.Variables;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class JSCompleter {
    Earley earley;
    public int editorOffset = -1;
    public static int limitClasses = 20;

    public JSCompleter(Earley earley) {
        this.earley = earley;
    }

    public static void main(String[] args) throws Exception {
        Earley earley = JavaScript.getInstance();
        JSCompleter c = new JSCompleter(earley);
        String input = Service.readFile(JSCompleter.class, "example.js");
        List<LexerToken> src = LexerToken.parse(input, false, 41);
        int pos = input.indexOf("!");
        input = input.replace("!", "");
        System.out.println("pos=" + pos);
        List<CompletionItem> candidates = c.complete(input, pos);
        System.out.println("offset=" + c.editorOffset);
        System.out.println(candidates.toString());
    }

    public List<CompletionItem> complete(String input, int pos) {
        Parsed target = new Parsed(input, this.earley, this.earley instanceof SqlEarley ? "sql_statements" : "javascript");
        int editorOffset = LexerToken.char2lex(target.getSrc(), pos);
        return this.complete(target, editorOffset, pos);
    }

    public List<CompletionItem> complete(Parsed target, int editorOffset, int pos) {
        ParseNode leafAtPos;
        LinkedList<CompletionItem> ret = new LinkedList<CompletionItem>();
        String prefix = "";
        LexerToken current = target.getSrc().get(editorOffset);
        if (current.begin < pos && !".".equals(current.content)) {
            prefix = current.content.substring(0, pos - current.begin);
        }
        if ((leafAtPos = target.getRoot().leafAtPos(editorOffset)) != null && leafAtPos.contains("jLiteral")) {
            String p = prefix;
            if (p.startsWith("'")) {
                p = p.substring(1);
            }
            p = p.trim();
            for (String pkg : this.findPackageNamesStartingWith(p)) {
                ret.add(new CompletionItem(pkg, CompletionItem.Type.JAVA_PACKAGE));
            }
            for (String cls : this.findClassNamesStartingWith(p)) {
                ret.add(new CompletionItem(cls, CompletionItem.Type.JAVA_CLASS));
            }
            return ret;
        }
        if (prefix.length() == 2 && "ja".equalsIgnoreCase(prefix) || prefix.length() == 3 && "jav".equalsIgnoreCase(prefix) || prefix.length() == 4 && "java".equalsIgnoreCase(prefix) || prefix.length() == 5 && "java.".equalsIgnoreCase(prefix) || prefix.length() == 6 && "java.t".equalsIgnoreCase(prefix) || prefix.length() == 7 && "java.ty".equalsIgnoreCase(prefix)) {
            ret.add(new CompletionItem("Java.type('oracle.')", CompletionItem.Type.SNIPPET));
        }
        Set<Long> predicted = this.earley.predict(editorOffset, target.getMatrix());
        TreeSet<String> predictions = new TreeSet<String>();
        for (long key : predicted) {
            predictions.add(this.earley.allSymbols[Service.lX(key)]);
        }
        if (predictions.contains("identifier") | predictions.contains("arguments") && 2 < editorOffset) {
            int index = editorOffset;
            if (0 < prefix.length()) {
                --index;
            }
            Variables vars = new Variables();
            try {
                vars.eval(target);
            }
            catch (Exception e) {
                e.printStackTrace();
                return ret;
            }
            if (predictions.contains("identifier")) {
                for (String v : vars.variablesStartingWith(prefix)) {
                    ret.add(new CompletionItem(v, CompletionItem.Type.JAVA_VARIABLE));
                }
            }
            LexerToken prior = target.getSrc().get(index - 1);
            String var = prior.content;
            if (prior.type != Token.IDENTIFIER) {
                return ret;
            }
            String cls = vars.getType(var);
            if (cls == null) {
                String p = this.getQualifiedPrefix(target, index - 1) + "." + prefix;
                for (String pkg : this.findPackageNamesStartingWith(p)) {
                    ret.add(new CompletionItem(pkg, CompletionItem.Type.JAVA_PACKAGE));
                }
                for (String cls1 : this.findClassNamesStartingWith(p)) {
                    ret.add(new CompletionItem(cls1, CompletionItem.Type.JAVA_CLASS));
                }
                return ret;
            }
            try {
                CompletionItem ci;
                String name;
                Method[] methods;
                Class<?> c = Class.forName(cls);
                for (Method method : methods = c.getDeclaredMethods()) {
                    name = method.getName();
                    ci = new CompletionItem(name, CompletionItem.Type.JAVA_METHOD);
                    if (ret.contains(ci) || !ci.entry.startsWith(prefix)) continue;
                    ret.add(ci);
                }
                for (Method method : methods = c.getMethods()) {
                    name = method.getName();
                    ci = new CompletionItem(name, CompletionItem.Type.JAVA_METHOD);
                    if (ret.contains(ci) || !ci.entry.startsWith(prefix)) continue;
                    ret.add(ci);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return ret;
            }
        }
        return ret;
    }

    private String getQualifiedPrefix(Parsed target, int index) {
        Object ret = "";
        boolean expectDot = false;
        boolean expectId = true;
        for (int i = index; 0 < i; --i) {
            LexerToken curr = target.getSrc().get(i);
            if ((!expectDot || !".".equals(curr.content)) && (!expectId || curr.type != Token.IDENTIFIER)) break;
            ret = curr.content + (String)ret;
            expectDot = !expectDot;
            expectId = !expectId;
        }
        return ret;
    }

    private List<String> findPackageNamesStartingWith(String prefix) {
        LinkedList<String> ret = new LinkedList<String>();
        for (Package pkg : Package.getPackages()) {
            String pkgName = pkg.getName();
            if (!pkgName.startsWith(prefix) || ret.contains(pkgName = pkgName.substring(prefix.length()))) continue;
            ret.add(pkgName + ".");
        }
        return ret;
    }

    private List<String> findClassNamesStartingWith(String prefix) {
        LinkedList<String> ret = new LinkedList<String>();
        int dotPos = prefix.lastIndexOf(46);
        String pkg = prefix.substring(0, dotPos);
        String pref = prefix.substring(0, dotPos + 1);
        TreeSet<String> classes = new TreeSet<String>();
        try {
            for (Class cls : JSCompleter.getClasses(pkg)) {
                classes.add(cls.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (Class cls : JSCompleter.allClasses(ClassLoader.getSystemClassLoader().getParent())) {
                classes.add(cls.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String className : classes) {
            if (className.contains("$")) continue;
            if (className.startsWith(prefix) && !ret.contains(className = className.substring(dotPos + 1))) {
                ret.add(className);
            }
            if (limitClasses > ret.size()) continue;
            ret.add("...");
            return ret;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processJar(String pkgname, List<Class> classes, File directory, String fullPath, String relPath) {
        try {
            String jarPath = fullPath.replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
            JarFile jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.startsWith(relPath) || entryName.length() <= relPath.length() + "/".length()) continue;
                String className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
                try {
                    classes.add(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("ClassNotFoundException loading " + className);
                    return;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Class[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        String relPath = packageName.replace('.', '/');
        ArrayList<Class> classes = new ArrayList<Class>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
            try {
                File directory = new File(resource.toURI());
                String fullPath = resource.getFile();
                JSCompleter.processJar(packageName, classes, directory, fullPath, relPath);
            }
            catch (URISyntaxException directory) {}
        }
        for (File directory : dirs) {
            classes.addAll(JSCompleter.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory() || !file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + "." + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    private static Vector<Class> allClasses(ClassLoader loader) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<ClassLoader> aClass = ClassLoader.class;
        Field field = null;
        try {
            field = aClass.getDeclaredField("classes");
        }
        catch (Exception e) {
            field = aClass.getField("classes");
        }
        field.setAccessible(true);
        Object value = field.get(loader);
        return (Vector)value;
    }
}

