/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.wizards.rdfmodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.actions.ActionValues;
import oracle.dbtools.raptor.ui.actions.ActionValuesLookup;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.utils.RDFDBUtils;
import oracle.dbtools.rdfgraph.utils.RDFStatement;
import oracle.dbtools.rdfgraph.utils.RDFStatementIterator;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;
import oracle.dbtools.rdfgraph.wizards.AbstractModelObject;
import oracle.dbtools.rdfgraph.wizards.TaskResult;
import oracle.dbtools.util.Logger;
import oracle.javatools.db.DBException;

public class RDFModelWizardModel
extends AbstractModelObject {
    private final ArrayList<ActionDialogTab> tabs = new ArrayList();
    private JDialog dialog;
    private Connection connection;
    private File sourceFile;
    private String stagingTblName;
    private boolean createStagingTbl;
    private boolean hasQuads = false;
    private double insertedTriples = 0.0;
    private String RDFModelName;
    private String appTableName;
    private boolean createAppTbl;
    private boolean createModel;
    private String colunmName;
    private String tblSpaceName;
    private boolean useDefaultTblSpace;
    private String additionalFlags = null;
    private int parallel;
    private boolean rebuildAppIdx;
    private boolean is19cOrAfter = false;
    private boolean is19_3cOrAfter = false;
    private boolean isCompressionEnabled = false;
    private String networkOwner = "MDSYS";
    private String networkName = null;
    private Map<String, String> bulkLoadFlags = new HashMap<String, String>();

    public void setAdditionalFlags(String string) {
        this.additionalFlags = string;
    }

    public String getAdditionalFlags() {
        return this.additionalFlags;
    }

    public void setInsertedTriples(double d) {
        this.insertedTriples = d;
    }

    public double getInsertedTriples() {
        return this.insertedTriples;
    }

    public void setRDFModelName(String string) {
        this.RDFModelName = string;
    }

    public String getRDFModelName() {
        return this.RDFModelName;
    }

    public void setAppTableName(String string) {
        this.appTableName = string;
    }

    public String getAppTableName() {
        return this.appTableName;
    }

    public void setColunmName(String string) {
        this.colunmName = string;
    }

    public String getColunmName() {
        return this.colunmName;
    }

    public void setTblSpaceName(String string) {
        this.tblSpaceName = string;
    }

    public String getTblSpaceName() {
        return this.tblSpaceName;
    }

    public void setCreateModel(boolean bl) {
        this.createModel = bl;
    }

    public boolean isCreateModel() {
        return this.createModel;
    }

    public void setCreateAppTbl(boolean bl) {
        this.createAppTbl = bl;
    }

    public boolean isCreateAppTbl() {
        return this.createAppTbl;
    }

    public void setUseDefaultTblSpace(boolean bl) {
        this.useDefaultTblSpace = bl;
    }

    public boolean isUseDefaultTblSpace() {
        return this.useDefaultTblSpace;
    }

    public void setStagingTblName(String string) {
        this.stagingTblName = string;
    }

    public String getStagingTblName() {
        return this.stagingTblName;
    }

    public void setCreateStagingTbl(boolean bl) {
        this.createStagingTbl = bl;
    }

    public boolean isCreateStagingTbl() {
        return this.createStagingTbl;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        Object object = null;
        this.is19cOrAfter = false;
        this.is19_3cOrAfter = false;
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            object = databaseMetaData.getDatabaseProductVersion();
            if (((String)object).indexOf(" 10.") <= -1 && ((String)object).indexOf(" 11.") <= -1 && ((String)object).indexOf(" 12.") <= -1 && ((String)object).indexOf(" 18.") <= -1) {
                this.is19cOrAfter = true;
            }
            if (this.is19cOrAfter) {
                int n = ((String)object).toUpperCase().indexOf("VERSION ");
                if (n > -1) {
                    object = "Oracle Database " + ((String)object).substring(n);
                }
                if (((String)object).indexOf(" 19.0") <= -1 && ((String)object).indexOf(" 19.1.") <= -1 && ((String)object).indexOf(" 19.2.") <= -1) {
                    this.is19_3cOrAfter = true;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.isCompressionEnabled = RDFDBUtils.isCompressionEnabled(connection);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setSourceFile(File file) {
        this.sourceFile = file;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setBulkLoadFlags(Map<String, String> map) {
        this.bulkLoadFlags = map;
    }

    public Map<String, String> getBulkLoadFlags() {
        return this.bulkLoadFlags;
    }

    public void initialize() {
    }

    public void setDialog(JDialog jDialog) {
        this.dialog = jDialog;
    }

    public void processScript(String string, TaskResult taskResult) {
        boolean bl = true;
        String string2 = UiResources.getString((String)"SQL_SUCCESS");
        Throwable throwable = null;
        String string3 = this.getSummaryScript();
        try {
            this.processScript(string3);
            string2 = UiResources.getString((String)"SQL_SUCCESS");
            bl = true;
        }
        catch (DBException dBException) {
            string2 = dBException.getMessage();
            throwable = dBException;
            bl = false;
            Logger.warn(this.getClass(), (Throwable)dBException);
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
            bl = false;
            throwable = exception;
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        taskResult.setStatus(bl);
        taskResult.setMessage(string2);
        taskResult.setException((Exception)throwable);
    }

    public void cancelProcessScript() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean loadFileIntoStaging(String string) throws SQLException {
        double d = 0.0;
        int n = 1000;
        String string2 = this.getQuery(this.getConnection(), "STAGING_TABLE_INSERT_TRIPLE").replace("##STAGING_TABLE##", string);
        if (this.hasQuads()) {
            string2 = this.getQuery(this.getConnection(), "STAGING_TABLE_INSERT_QUAD").replace("##STAGING_TABLE##", string);
        }
        Connection connection = this.getConnection();
        boolean bl = connection.getAutoCommit();
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        File file = this.getSourceFile();
        try {
            RDFStatementIterator rDFStatementIterator = new RDFStatementIterator(new FileInputStream(file));
            while (rDFStatementIterator.hasNext()) {
                RDFStatement rDFStatement = rDFStatementIterator.next();
                if (rDFStatement.isTriple()) {
                    preparedStatement.setString(1, rDFStatement.getRDFTerms()[0]);
                    preparedStatement.setString(2, rDFStatement.getRDFTerms()[1]);
                    preparedStatement.setString(3, rDFStatement.getRDFTerms()[2]);
                    if (this.hasQuads()) {
                        preparedStatement.setString(4, null);
                    }
                } else if (rDFStatement.isQuad()) {
                    preparedStatement.setString(1, rDFStatement.getRDFTerms()[0]);
                    preparedStatement.setString(2, rDFStatement.getRDFTerms()[1]);
                    preparedStatement.setString(3, rDFStatement.getRDFTerms()[2]);
                    preparedStatement.setString(4, rDFStatement.getRDFTerms()[3]);
                }
                preparedStatement.addBatch();
                if ((d += 1.0) % (double)n != 0.0) continue;
                preparedStatement.executeBatch();
            }
            preparedStatement.executeBatch();
            this.getConnection().commit();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.warn(this.getClass(), (Throwable)fileNotFoundException);
            boolean bl2 = false;
            return bl2;
        }
        catch (SQLException sQLException) {
            Logger.warn(this.getClass(), (Throwable)sQLException);
        }
        finally {
            this.setInsertedTriples(d);
            connection.setAutoCommit(bl);
            preparedStatement.close();
        }
        return true;
    }

    public boolean createStagingTable(String string) {
        String string2 = RDFStringUtils.updateScriptCompression(this.getQuery(this.getConnection(), "STAGING_TABLE_CREATE").replace("##STAGING_TABLE##", string), this.isCompressionEnabled);
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.getConnection());
        dBUtil.execute(string2);
        return true;
    }

    public String stripExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    List<String> getSummaryLines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isCreateAppTbl()) {
            arrayList.add(RdfgraphArb.getString("RDFModelWizardModel.CREATE_APPLICATION_TABLE_") + this.getAppTableName());
        }
        if (this.isCreateModel()) {
            arrayList.add(RdfgraphArb.getString("RDFModelWizardModel.CREATE_NEW_RDF_MODEL_") + this.getRDFModelName());
        }
        arrayList.add(RdfgraphArb.format("RDFModelWizardModel.GRANT_SELECT_ON_STAGING_TABLE__", this.getStagingTblName()));
        arrayList.add(RdfgraphArb.format("RDFModelWizardModel.GRANT_INSERT_SELECT_ON_APPLICATION_TABLE__", this.getAppTableName()));
        arrayList.add(RdfgraphArb.format("RDFModelWizardModel.EXECUTE_SEM_APIS_BULK_LOAD_FROM_STAGING_TABLE__", this.getStagingTblName(), this.getRDFModelName()));
        return arrayList;
    }

    String getSummaryScript() {
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.getConnection());
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        String string2 = dBUtil.executeReturnOneCol("SELECT user FROM DUAL");
        if (this.isCreateAppTbl() && (!this.is19_3cOrAfter || "MDSYS".equalsIgnoreCase(this.networkOwner))) {
            stringBuffer.append(string);
            String string3 = this.getQuery(this.getConnection(), "APPLICATION_TABLE_CREATE").replace("##APP_TABLE##", this.getAppTableName());
            string3 = RDFStringUtils.updateScriptCompression(string3, this.isCompressionEnabled);
            string3 = string3.replace("##COL_NAME##", this.getColunmName());
            stringBuffer.append(string3 + string);
            stringBuffer.append(string);
            String string4 = this.getQuery(this.getConnection(), "APPLICATION_TABLE_INDEX_CREATE");
            string4 = RDFStringUtils.updateScriptCompression(string4, this.isCompressionEnabled);
            string4 = string4.replace("##APP_TABLE##", this.getAppTableName());
            string4 = string4.replace("##COL_NAME##", this.getColunmName());
            string4 = string4.replace("##MODEL_NAME##", this.getRDFModelName());
            stringBuffer.append(string4 + string);
        }
        if (this.isCreateModel()) {
            stringBuffer.append(string);
            String string5 = this.getQuery(this.getConnection(), "CREATE_SEM_MODEL");
            string5 = string5.replace(":MODEL_NAME", "'" + this.getRDFModelName() + "'");
            if (this.is19_3cOrAfter && !"MDSYS".equalsIgnoreCase(this.networkOwner)) {
                string5 = string5.replace(":TABLE_NAME", "null");
                string5 = string5.replace(":COL_NAME", "null");
            } else {
                string5 = string5.replace(":TABLE_NAME", "'" + this.getAppTableName() + "'");
                string5 = string5.replace(":COL_NAME", "'" + this.getColunmName() + "'");
            }
            string5 = string5.replace(":MODEL_TBLSPACE", "null");
            if (this.is19cOrAfter) {
                string5 = string5.replace(":NETWORK_OWNER", "'" + this.networkOwner + "'");
                string5 = "MDSYS".equalsIgnoreCase(this.networkOwner) ? string5.replace(":NETWORK_NAME", "null") : string5.replace(":NETWORK_NAME", "'" + this.networkName + "'");
            }
            stringBuffer.append(string5 + string);
            stringBuffer.append("/" + string);
        }
        stringBuffer.append(string);
        String string6 = this.getQuery(this.getConnection(), "STAGING_TABLE_GRANT_MDSYS");
        string6 = string6.replace("##STAGING_TABLE##", this.getStagingTblName());
        stringBuffer.append(string6);
        if (!this.is19_3cOrAfter || "MDSYS".equalsIgnoreCase(this.networkOwner)) {
            stringBuffer.append(string);
            String string7 = this.getQuery(this.getConnection(), "APPLICATION_TABLE_GRANT_MDSYS");
            string7 = string7.replace("##APP_TABLE##", this.getAppTableName());
            stringBuffer.append(string7);
        }
        Object object = "MDSYS.RDF_MODEL";
        if (this.networkOwner != null && !this.networkOwner.equalsIgnoreCase("MDSYS")) {
            object = this.networkOwner + "." + this.networkName + "#RDF_MODEL";
        }
        if (this.isRebuildAppIdx() && (!this.is19_3cOrAfter || "MDSYS".equalsIgnoreCase(this.networkOwner))) {
            stringBuffer.append(string);
            String string8 = this.getQuery(this.getConnection(), "APP_TAB_IDX_UNUSABLE");
            string8 = string8.replace("##MODEL_NAME##", "'" + this.getRDFModelName() + "'");
            string8 = string8.replace("##MODELS_TABLE##", (CharSequence)object);
            stringBuffer.append(string8);
        }
        stringBuffer.append(string);
        String string9 = this.getQuery(this.getConnection(), "BULK_LOAD_FROM_STAGING_TABLE");
        string9 = string9.replace(":MODEL_NAME", "'" + this.getRDFModelName() + "'");
        string9 = string9.replace(":TABLE_OWNER", "'" + string2 + "'");
        string9 = string9.replace(":TABLE_NAME", "'" + this.getStagingTblName() + "'");
        string9 = string9.replace(":FLAGS", this.getBulkLoadFlagsScript());
        if (this.is19cOrAfter) {
            string9 = string9.replace(":NETWORK_OWNER", "'" + this.networkOwner + "'");
            string9 = "MDSYS".equalsIgnoreCase(this.networkOwner) ? string9.replace(":NETWORK_NAME", "null") : string9.replace(":NETWORK_NAME", "'" + this.networkName + "'");
        }
        stringBuffer.append(string9 + string);
        stringBuffer.append("/" + string);
        if (this.isRebuildAppIdx() && (!this.is19_3cOrAfter || "MDSYS".equalsIgnoreCase(this.networkOwner))) {
            stringBuffer.append(string);
            String string10 = this.getQuery(this.getConnection(), "APP_TAB_IDX_REBUILD");
            string10 = RDFStringUtils.updateScriptCompression(string10, this.isCompressionEnabled);
            string10 = string10.replace("##MODEL_NAME##", "'" + this.getRDFModelName() + "'");
            string10 = string10.replace("##PARALLEL##", "'" + Integer.toString(this.getParallel()) + "'");
            string10 = string10.replace("##MODELS_TABLE##", (CharSequence)object);
            stringBuffer.append(string10);
        }
        return stringBuffer.toString();
    }

    public String getBulkLoadFlagsScript() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getBulkLoadFlags().size() == 0 && this.getAdditionalFlags().trim().isEmpty()) {
            return "null";
        }
        stringBuilder.append("' ");
        for (Map.Entry<String, String> entry : this.getBulkLoadFlags().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string2 != null) {
                stringBuilder.append(string + "=" + string2);
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append(" ");
        }
        stringBuilder.append(" " + this.getAdditionalFlags() + " ");
        stringBuilder.append(" '");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processScript(String string) throws Exception {
        Connection connection = this.getConnection();
        ScriptParser scriptParser = new ScriptParser(string, connection);
        scriptParser.parse();
        ISQLCommand[] iSQLCommandArray = scriptParser.getSqlStatements();
        if (Connections.getInstance().lock(connection)) {
            try {
                for (ISQLCommand iSQLCommand : iSQLCommandArray) {
                    String string2 = iSQLCommand.getSql().replace("\r", " ");
                    try (PreparedStatement preparedStatement = connection.prepareStatement(string2);){
                        preparedStatement.execute();
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw sQLException;
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    void BulkInsertFromStaging() {
        String string = this.getSummaryScript();
        try {
            this.processScript(string);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }

    public void setQuads(boolean bl) {
        this.hasQuads = bl;
    }

    public boolean hasQuads() {
        return this.hasQuads;
    }

    public void setParallel(int n) {
        this.parallel = n;
    }

    public int getParallel() {
        return this.parallel;
    }

    public void setRebuildAppIdx(boolean bl) {
        this.rebuildAppIdx = bl;
    }

    public boolean isRebuildAppIdx() {
        return this.rebuildAppIdx;
    }

    public boolean isDB19cOrAfter() {
        return this.is19cOrAfter;
    }

    public boolean isDB19_3cOrAfter() {
        return this.is19_3cOrAfter;
    }

    public void setNetworkOwner(String string) {
        this.networkOwner = string;
    }

    public String getNetworkOwner() {
        return this.networkOwner;
    }

    public void setNetworkName(String string) {
        this.networkName = string;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public class Values
    extends ActionValues<ActionValuesLookup> {
        Values() {
            for (ActionDialogTab actionDialogTab : RDFModelWizardModel.this.tabs) {
                String string = actionDialogTab.getName();
                ActionDialog.Lookup lookup = actionDialogTab.getLookup();
                if (string == null) {
                    this._lookup = lookup;
                    continue;
                }
                this._tabLookupMap.put(actionDialogTab.getName(), lookup);
            }
        }
    }
}

