/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.utils;

import java.net.URLDecoder;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;

public class RDFStringUtils {
    private static final Random RANDOM = new SecureRandom();

    public static String generateRandomId() {
        return "genid" + UUID.randomUUID().toString().replace("-", "");
    }

    public static String generateRandomTMAP() {
        return "<TMAP" + RDFStringUtils.generateRandomId() + ">";
    }

    public static String generateRandomBNode() {
        return "_:" + RDFStringUtils.generateRandomId();
    }

    public static String escapeHTML(String string) {
        StringBuilder stringBuilder = new StringBuilder(Math.max(16, string.length()));
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '<' || c == '>' || c == '&') {
                stringBuilder.append("&#");
                stringBuilder.append((int)c);
                stringBuilder.append(';');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String stripSQLName(String string) {
        string = string.replaceAll("\\\"", "");
        string = string.replaceAll("\\\\", "");
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String unescapeJavaString(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        while (true) {
            block18: {
                int n2;
                block16: {
                    char c;
                    block17: {
                        if (n >= string.length()) {
                            return stringBuilder.toString();
                        }
                        n2 = string.charAt(n);
                        if (n2 != 92) break block16;
                        char c2 = c = n == string.length() - 1 ? (char)'\\' : (char)string.charAt(n + 1);
                        if (c < 48 || c > 55) break block17;
                        String string2 = "" + c;
                        if (++n < string.length() - 1 && string.charAt(n + 1) >= '0' && string.charAt(n + 1) <= '7') {
                            string2 = string2 + string.charAt(n + 1);
                            if (++n < string.length() - 1 && string.charAt(n + 1) >= '0' && string.charAt(n + 1) <= '7') {
                                string2 = string2 + string.charAt(n + 1);
                                ++n;
                            }
                        }
                        stringBuilder.append((char)Integer.parseInt(string2, 8));
                        break block18;
                    }
                    switch (c) {
                        case '\\': {
                            n2 = 92;
                            break;
                        }
                        case 'b': {
                            n2 = 8;
                            break;
                        }
                        case 'f': {
                            n2 = 12;
                            break;
                        }
                        case 'n': {
                            n2 = 10;
                            break;
                        }
                        case 'r': {
                            n2 = 13;
                            break;
                        }
                        case 't': {
                            n2 = 9;
                            break;
                        }
                        case '\"': {
                            n2 = 34;
                            break;
                        }
                        case '\'': {
                            n2 = 39;
                            break;
                        }
                        case 'u': {
                            if (n >= string.length() - 5) {
                                n2 = 117;
                                break;
                            }
                            int n3 = Integer.parseInt("" + string.charAt(n + 2) + string.charAt(n + 3) + string.charAt(n + 4) + string.charAt(n + 5), 16);
                            stringBuilder.append(Character.toChars(n3));
                            n += 5;
                            break block18;
                        }
                    }
                    ++n;
                }
                stringBuilder.append((char)n2);
            }
            ++n;
        }
    }

    public static String escapeJavaString(String string, boolean bl, boolean bl2) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = string.length();
        block13: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u0fff') {
                stringBuilder.append("\\u" + RDFStringUtils.hex(c));
                continue;
            }
            if (c > '\u00ff') {
                stringBuilder.append("\\u0" + RDFStringUtils.hex(c));
                continue;
            }
            if (c > '\u007f') {
                stringBuilder.append("\\u00" + RDFStringUtils.hex(c));
                continue;
            }
            if (c < ' ') {
                switch (c) {
                    case '\b': {
                        stringBuilder.append('\\');
                        stringBuilder.append('b');
                        break;
                    }
                    case '\n': {
                        stringBuilder.append('\\');
                        stringBuilder.append('n');
                        break;
                    }
                    case '\t': {
                        stringBuilder.append('\\');
                        stringBuilder.append('t');
                        break;
                    }
                    case '\f': {
                        stringBuilder.append('\\');
                        stringBuilder.append('f');
                        break;
                    }
                    case '\r': {
                        stringBuilder.append('\\');
                        stringBuilder.append('r');
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            stringBuilder.append("\\u00" + RDFStringUtils.hex(c));
                            break;
                        }
                        stringBuilder.append("\\u000" + RDFStringUtils.hex(c));
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\'': {
                    if (bl) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append('\'');
                    continue block13;
                }
                case '\"': {
                    stringBuilder.append('\\');
                    stringBuilder.append('\"');
                    continue block13;
                }
                case '\\': {
                    stringBuilder.append('\\');
                    stringBuilder.append('\\');
                    continue block13;
                }
                case '/': {
                    if (bl2) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append('/');
                    continue block13;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String hex(char c) {
        return Integer.toHexString(c).toUpperCase(Locale.ENGLISH);
    }

    public static String removeWrappingQuotes(String string) {
        if ((string = string.trim()).startsWith("\"")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String addWrappingQuotes(String string) {
        return "\"" + string + "\"";
    }

    public static boolean isOracle19cOrAfter(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf("10.") <= -1 && string.indexOf("11.") <= -1 && string.indexOf("12.") <= -1 && string.indexOf("18.") <= -1;
    }

    public static HashMap<String, String> extracNetworkInfoFromNodeURL(String string) {
        int n;
        String string2;
        if (string == null) {
            return null;
        }
        try {
            string = string2 = URLDecoder.decode(string, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        string2 = null;
        String string3 = null;
        int n2 = string.indexOf("//");
        if (n2 > -1 && (n = string.indexOf("/", n2 + 2)) > -1) {
            int n3;
            string2 = string.substring(n2 + 2, n);
            int n4 = string.indexOf("/", n + 1);
            if (n4 > -1 && (n3 = string.indexOf("/", n4 + 1)) > -1) {
                string3 = string.substring(n4 + 1, n3);
                if (string3.equalsIgnoreCase("MDSYS")) {
                    string2 = string3;
                } else {
                    int n5 = string3.indexOf(".");
                    if (n5 > -1) {
                        string2 = string3.substring(0, n5);
                        string3 = string3.substring(n5 + 1);
                    }
                }
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string2 != null) {
            hashMap.put("NETWORK_OWNER", string2);
        }
        if (string3 != null) {
            hashMap.put("NETWORK_NAME", string3);
        }
        return hashMap;
    }

    public static String updateScriptCompression(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        string = !bl ? string.replaceAll("#COMPRESS#", "NOCOMPRESS") : string.replaceAll("#COMPRESS#", "COMPRESS");
        return string;
    }

    public static String enquoteName(String string) {
        String string2 = string;
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string2 = RDFStringUtils.removeWrappingQuotes(string2);
        }
        if (string2.indexOf("\"") >= 0) {
            throw new RuntimeException("Invalid SQL name");
        }
        return RDFStringUtils.addWrappingQuotes(string2);
    }

    public static String enquoteLiteral(String string) {
        String string2 = string;
        string2.replaceAll("'", "''");
        return "'" + string2 + "'";
    }
}

