/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.utils;

import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.regex.Matcher;

public class PLSQLBlockTemplate {
    String template;
    String origTemplate;
    Boolean endingSlash = false;

    public void setEndingSlash(Boolean bl) {
        this.endingSlash = bl;
    }

    public Boolean getEndingSlash() {
        return this.endingSlash;
    }

    public PLSQLBlockTemplate(String string) {
        this.template = string;
        this.origTemplate = string;
    }

    public void replaceToken(String string, String string2, ParamType paramType) {
        String string3 = "";
        string = string.trim();
        string3 = paramType == ParamType.STRING ? this.asStringParam(string2) : (paramType == ParamType.NUMERIC ? this.asNumParam(string2) : (paramType == ParamType.QUOTED_STRING_LIST ? this.asQuotedStringList(string2) : (paramType == ParamType.TABLE_NAME ? this.asTableName(string2) : (paramType == ParamType.TABLE_NAME_PARAM ? this.asTableNameParam(string2) : string2))));
        this.template = this.template.replaceAll(string, Matcher.quoteReplacement(string3));
    }

    public String asStringParam(String string) {
        if (string.trim().isEmpty()) {
            return "null";
        }
        return "'" + string + "'";
    }

    public String asTableName(String string) {
        if (string.trim().isEmpty()) {
            return "";
        }
        if (string.trim().startsWith("\"")) {
            return string.trim();
        }
        return string.trim().toUpperCase();
    }

    public String asTableNameParam(String string) {
        if (string.trim().isEmpty()) {
            return "";
        }
        if (string.trim().startsWith("\"")) {
            return "'" + string.trim() + "'";
        }
        return "'" + string.trim().toUpperCase() + "'";
    }

    public String asNumParam(String string) {
        if (string.trim().isEmpty()) {
            return "null";
        }
        return string;
    }

    public String asQuotedStringList(String string) {
        if (string.trim().isEmpty()) {
            return "''";
        }
        String[] stringArray = string.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        for (String string3 : stringArray) {
            stringBuilder.append(string2 + "'" + string3.trim() + "'");
            string2 = ", ";
        }
        return stringBuilder.toString();
    }

    public String toString() {
        if (this.endingSlash.booleanValue()) {
            return this.template + "\n/\n";
        }
        return this.template + "\n";
    }

    public static String shortUUID() {
        UUID uUID = UUID.randomUUID();
        long l = ByteBuffer.wrap(uUID.toString().getBytes()).getLong();
        return Long.toString(l, 36);
    }

    public static enum ParamType {
        STRING,
        NUMERIC,
        QUOTED_STRING_LIST,
        TABLE_NAME,
        TABLE_NAME_PARAM,
        RAW;

    }
}

