/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.LabelActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;
import oracle.javatools.dialogs.MessageDialog;

public class SetupSemanticNetworkActionDialog
extends ActionDialog {
    private Connection connection;
    private String title;
    private SqlComboBoxActionControl selectTablespace;
    private SeperatorActionControl separatorLine;
    private LabelActionControl labelNote;
    private LabelActionControl labelNotePrior19c;
    private LabelActionControl labelNoteFrom19c;
    private boolean is19cOrAfter = false;

    public void setTitle(String string) {
        this.title = string;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.setConnection(connection);
        DBObject dBObject = this.getDBObject();
        String string = dBObject.getDBVersion();
        this.is19cOrAfter = RDFStringUtils.isOracle19cOrAfter(string);
        String string2 = "SELECT tablespace_name FROM user_tablespaces order by tablespace_name";
        this.selectTablespace = new SqlComboBoxActionControl("tablespace_name", RdfgraphArb.getString("TABLESPACE"), connection, string2, "");
        this.selectTablespace.enableEditBox();
        this.separatorLine = new SeperatorActionControl();
        this.labelNote = new LabelActionControl("note_label", RdfgraphArb.getString("SetupSemanticNetworkActionDialog.NOTE"));
        this.labelNotePrior19c = new LabelActionControl("prior_label", RdfgraphArb.getString("SetupSemanticNetworkActionDialog.PRIOR_19C_NOTE"));
        this.labelNoteFrom19c = new LabelActionControl("from_label", RdfgraphArb.getString("SetupSemanticNetworkActionDialog.FROM_19C_NOTE"));
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
            {
                if (!SetupSemanticNetworkActionDialog.this.is19cOrAfter) {
                    this.add(SetupSemanticNetworkActionDialog.this.selectTablespace);
                    this.add(SetupSemanticNetworkActionDialog.this.separatorLine);
                }
                this.add(SetupSemanticNetworkActionDialog.this.labelNote);
                if (SetupSemanticNetworkActionDialog.this.is19cOrAfter) {
                    this.add(SetupSemanticNetworkActionDialog.this.labelNoteFrom19c);
                } else {
                    this.add(SetupSemanticNetworkActionDialog.this.labelNotePrior19c);
                }
            }
        };
        return arrayList;
    }

    protected List<ActionDialogTab> createAdditionalTabs() {
        ArrayList<ActionDialogTab> arrayList = new ArrayList<ActionDialogTab>(){};
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getScript(ActionDialog.Values values) {
        Object object = "";
        if (this.is19cOrAfter) {
            InputStream inputStream = null;
            try {
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("setup_metadata_functions.sql");
                object = this.readFromInputStream(inputStream);
            }
            catch (IOException iOException) {
                MessageDialog.error(null, (Object)(iOException.getMessage() + "\n[setup_metadata_functions]"), (String)UiResources.getString((String)"ERROR_TITLE"), null);
                object = "";
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            object = this.getQuery(this.connection, "CREATE_SEMANTIC_NETWORK");
            object = (String)object + "\n/";
            object = ((String)object).replaceAll("#tablespace_name#", values.get("tablespace_name"));
        }
        return object;
    }

    protected String getTitle() {
        return RdfgraphArb.getString("SetupSemanticNetworkActionDialog.SETUP_SEMANTIC_NETWORK");
    }

    private String readFromInputStream(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    protected String getHelpId() {
        return "rdfplugin-intro__GUID-CF6869CF-9C5F-4448-823C-29B9D0A164EA";
    }
}

