/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import oracle.javatools.editor.BasicEditorPane;

public class AutoCompleteListener
implements DocumentListener {
    private BasicEditorPane textField;
    private final List<String> keywords;
    private Mode mode = Mode.INSERT;

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public AutoCompleteListener(BasicEditorPane basicEditorPane, List<String> list) {
        this.textField = basicEditorPane;
        this.keywords = list;
        Collections.sort(list);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        int n;
        if (documentEvent.getLength() != 1) {
            return;
        }
        int n2 = documentEvent.getOffset();
        String string = null;
        try {
            string = this.textField.getDocument().getText(0, n2 + 1);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        for (n = n2; n >= 0 && Character.isLetter(string.charAt(n)); --n) {
        }
        if (n2 - n < 2) {
            return;
        }
        String string2 = string.substring(n + 1);
        int n3 = Collections.binarySearch(this.keywords, string2);
        if (n3 < 0 && -n3 <= this.keywords.size()) {
            String string3 = this.keywords.get(-n3 - 1);
            if (string3.startsWith(string2)) {
                String string4 = string3.substring(n2 - n);
                SwingUtilities.invokeLater(new CompletionTask(string4, n2 + 1));
            }
        } else {
            this.mode = Mode.INSERT;
        }
    }

    private class CompletionTask
    implements Runnable {
        private String completion;
        private int position;

        CompletionTask(String string, int n) {
            this.completion = string;
            this.position = n;
        }

        @Override
        public void run() {
            StringBuffer stringBuffer = new StringBuffer(AutoCompleteListener.this.textField.getText());
            stringBuffer.insert(this.position, this.completion);
            AutoCompleteListener.this.textField.setText(stringBuffer.toString());
            AutoCompleteListener.this.textField.setCaretPosition(this.position + this.completion.length());
            AutoCompleteListener.this.textField.moveCaretPosition(this.position);
            AutoCompleteListener.this.mode = Mode.COMPLETION;
        }
    }

    public class CommitAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompleteListener.this.mode == Mode.COMPLETION) {
                int n = AutoCompleteListener.this.textField.getSelectionEnd();
                StringBuffer stringBuffer = new StringBuffer(AutoCompleteListener.this.textField.getText());
                stringBuffer.insert(n, " ");
                AutoCompleteListener.this.textField.setText(stringBuffer.toString());
                AutoCompleteListener.this.textField.setCaretPosition(n + 1);
                AutoCompleteListener.this.mode = Mode.INSERT;
            } else {
                AutoCompleteListener.this.textField.replaceSelection("\t");
            }
        }
    }

    public static enum Mode {
        INSERT,
        COMPLETION;

    }
}

