/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.sparql.editor;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.phighlight.TooltipMessage;
import oracle.dbtools.rdfgraph.sparql.editor.SPARQLErrorInfo;
import oracle.dbtools.rdfgraph.sparql.editor.SPARQLHighlightAddin;
import oracle.dbtools.rdfgraph.sparql.language.SPARQLLexer;
import oracle.dbtools.rdfgraph.sparql.language.SPARQLLexicalError;
import oracle.ide.model.NodeListener;
import oracle.ide.status.editor.StatusEditorPlugin;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.editor.BasicEditorOverview;
import oracle.javatools.editor.BasicEditorOverviewMark;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.ui.overview.OverviewMark;
import oracle.javatools.ui.overview.OverviewStatus;

public class SPARQLHighlightEditorPlugin
implements EditorPlugin,
TooltipMessage {
    private Logger logger = Logger.getLogger(SPARQLHighlightEditorPlugin.class.getName());
    private BasicEditorPane _editorPane;
    private NodeListener _nodeListener;
    private HighlightLayer _highlightLayer;
    private List<SPARQLErrorInfo> _errors = new ArrayList<SPARQLErrorInfo>();
    private BasicEditorOverview overview;

    public String getToolTipText(int n) {
        int n2 = this._editorPane.getLineCount();
        if (n2 == 0) {
            return null;
        }
        if (this._errors != null && 0 < this._errors.size()) {
            for (SPARQLErrorInfo sPARQLErrorInfo : this._errors) {
                int n3 = sPARQLErrorInfo.getLineNumber();
                if (--n3 < 0) {
                    n3 = 0;
                } else if (n3 >= n2) {
                    n3 = n2 - 1;
                }
                int n4 = this._editorPane.getLineStartOffset(n3);
                int n5 = sPARQLErrorInfo.getAbsolulteOffsetBegin();
                int n6 = sPARQLErrorInfo.getAbsolulteOffsetEnd();
                if (n < n5 || n > n6) continue;
                String[] stringArray = sPARQLErrorInfo.getErrorMessage().split("\n");
                Object object = stringArray[0];
                if (stringArray.length > 1) {
                    object = (String)object + "...";
                }
                return object;
            }
        }
        return null;
    }

    public SPARQLHighlightEditorPlugin(BasicEditorOverview basicEditorOverview) {
        this.overview = basicEditorOverview;
    }

    public void install(BasicEditorPane basicEditorPane) {
        this._editorPane = basicEditorPane;
        this.updateHighlight();
        this.deinstallStatusEditorPlugin();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this._highlightLayer = null;
        this._editorPane = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public HighlightLayer getHighlightLayer() {
        if (this._highlightLayer == null && this._editorPane != null) {
            this._highlightLayer = this._editorPane.createHighlightLayer();
        }
        return this._highlightLayer;
    }

    private void deinstallStatusEditorPlugin() {
        try {
            Field field = BasicEditorPane.class.getDeclaredField("pluginList");
            field.setAccessible(true);
            ArrayList arrayList = (ArrayList)field.get(this._editorPane);
            for (int i = 0; i < arrayList.size(); ++i) {
                Object e = arrayList.get(i);
                if (!(e instanceof StatusEditorPlugin)) continue;
                this._editorPane.deinstallPlugin((EditorPlugin)e);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public void updateHighlight() {
        SwingUtilities.invokeLater(() -> {
            this._errors = this.getErrors();
            HighlightLayer highlightLayer = this.getHighlightLayer();
            if (highlightLayer == null) {
                return;
            }
            highlightLayer.removeAllHighlights();
            HighlightStyle highlightStyle = SPARQLHighlightAddin.getErrorHighlightStyle();
            HighlightStyle highlightStyle2 = SPARQLHighlightAddin.getWarningHighlightStyle();
            HighlightStyle highlightStyle3 = SPARQLHighlightAddin.getFatalHighlightStyle();
            HighlightStyle highlightStyle4 = SPARQLHighlightAddin.getCommentHighlightStyle();
            String string = "audit-errors";
            String string2 = "audit-warnings";
            this.overview.removeMarks((Object)string);
            this.overview.removeMarks((Object)string2);
            int n = this._editorPane.getLineCount();
            if (n == 0) {
                return;
            }
            for (SPARQLErrorInfo object2 : this._errors) {
                Color color;
                HighlightStyle highlightStyle5;
                String string3;
                int sPARQLLexicalError = object2.getLineNumber();
                if (--sPARQLLexicalError < 0) {
                    sPARQLLexicalError = 0;
                } else if (sPARQLLexicalError >= n) {
                    sPARQLLexicalError = n - 1;
                }
                if (!object2.isWarning() && !object2.isFatal()) {
                    string3 = string;
                    highlightStyle5 = highlightStyle;
                    color = OverviewStatus.ERROR;
                } else if (!object2.isWarning() && object2.isFatal()) {
                    string3 = string;
                    highlightStyle5 = highlightStyle3;
                    color = OverviewStatus.ERROR;
                } else {
                    string3 = string2;
                    highlightStyle5 = highlightStyle2;
                    color = OverviewStatus.WARNING;
                }
                try {
                    highlightLayer.addHighlight(highlightStyle5, object2.getAbsolulteOffsetBegin(), object2.getAbsolulteOffsetEnd());
                    this.overview.addMark((OverviewMark)new BasicEditorOverviewMark(this._editorPane, Integer.valueOf(object2.getAbsolulteOffsetBegin()), Integer.valueOf(object2.getAbsolulteOffsetEnd()), 2.0f, color), (Object)string3);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    this.logger.log(Level.SEVERE, "Could not highlight", exception);
                }
            }
            SPARQLLexer sPARQLLexer = new SPARQLLexer();
            sPARQLLexer.setTextBuffer((ReadTextBuffer)this._editorPane.getTextBuffer());
            while (sPARQLLexer.lex(null) != 0) {
            }
            for (SPARQLLexicalError sPARQLLexicalError : sPARQLLexer.getLexical_errors()) {
                highlightLayer.addHighlight(highlightStyle3, sPARQLLexicalError.getStartOffset(), sPARQLLexicalError.getEndOffset());
                this.overview.addMark((OverviewMark)new BasicEditorOverviewMark(this._editorPane, Integer.valueOf(sPARQLLexicalError.getStartOffset()), Integer.valueOf(sPARQLLexicalError.getEndOffset()), 2.0f, OverviewStatus.WARNING), (Object)string);
            }
            OverviewStatus overviewStatus = this.overview.getStatus();
            if (overviewStatus != null) {
                if (0 < this._errors.size()) {
                    overviewStatus.setColor(OverviewStatus.ERROR);
                } else {
                    overviewStatus.setColor(OverviewStatus.OK);
                }
            }
        });
    }

    public List<SPARQLErrorInfo> getErrors() {
        return this._errors;
    }

    public void setErrors(List<SPARQLErrorInfo> list) {
        this._errors = list;
    }
}

