/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.subjectmap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.GraphMapValueCellEditor;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.TermMapTypeCellEditor;
import oracle.dbtools.rdfgraph.r2rml.editor.subjectmap.SubjectGraphMapTableModel;
import oracle.dbtools.rdfgraph.r2rml.language.GraphMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.SubjectMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.javatools.icons.OracleIcons;

public class SubjectGraphMapListEditor
extends JPanel {
    private static final String SUBJECT_GRAPMAPH_TITLE = R2RMLArb.getString("SubjectGraphMapListEditor.SUBJECT_GRAPH_MAP_S_");
    SubjectMapNode node;
    TriplesMapNode tmap;
    Connection connection;
    private JTable table;
    private SubjectGraphMapTableModel tmodel;
    private JToolBar toolbar;
    public static final int VALUE_COL_IDX = 0;
    public static final int TYPE_COL_IDX = 1;

    public SubjectGraphMapListEditor(TriplesMapNode triplesMapNode, SubjectMapNode subjectMapNode, Connection connection) {
        this.tmap = triplesMapNode;
        this.node = subjectMapNode;
        this.connection = connection;
        this.setBorder(BorderFactory.createTitledBorder(SUBJECT_GRAPMAPH_TITLE));
        this.setLayout(new BorderLayout());
        this.initUI();
    }

    private void initUI() {
        this.table = this.createTable();
        this.toolbar = this.createToolBar();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.toolbar, "North");
    }

    private JToolBar createToolBar() {
        this.toolbar = new JToolBar();
        JButton jButton = new JButton(R2RMLArb.getString("SubjectGraphMapListEditor.ADD_GRAPH_MAP"), OracleIcons.getIcon((String)"add.png"));
        jButton.addActionListener(actionEvent -> {
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#graph>", new GraphMapNode(""));
            this.tmodel.fireTableDataChanged();
            int n = this.node.getGraphMaps().size();
            boolean bl = this.table.editCellAt(n - 1, 0);
            if (bl) {
                boolean bl2 = false;
                boolean bl3 = false;
                this.table.changeSelection(n - 1, 0, bl2, bl3);
                this.table.requestFocusInWindow();
            }
        });
        JButton jButton2 = new JButton(RdfgraphArb.getString("DELETE"), OracleIcons.getIcon((String)"delete.png"));
        jButton2.addActionListener(actionEvent -> {
            if (this.table.getSelectedRow() != -1) {
                int n = this.table.getSelectedRow();
                this.table.clearSelection();
                if (this.table.isEditing()) {
                    this.table.getCellEditor().stopCellEditing();
                }
                this.tmodel.removeRow(n);
            }
        });
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add(jButton);
        this.toolbar.add(jButton2);
        return this.toolbar;
    }

    private JTable createTable() {
        this.tmodel = new SubjectGraphMapTableModel(this.node);
        this.table = new JTable(this.tmodel);
        this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
        this.table.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.table.setAutoResizeMode(3);
        this.table.setFillsViewportHeight(true);
        this.table.getColumnModel().getColumn(1).setCellEditor(new TermMapTypeCellEditor());
        this.table.getColumnModel().getColumn(0).setCellEditor(new GraphMapValueCellEditor(this.tmap, this.connection));
        return this.table;
    }
}

