/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.objectmap;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.JoinConditionListEditor;
import oracle.dbtools.rdfgraph.r2rml.language.ObjectMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLTree;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;

public class ReferencingObjectMapPopupDialog
extends JDialog
implements ActionListener {
    private JLabel lblParentTMAP;
    private JComboBox<String> selParentTMAP;
    private ObjectMapNode node;
    Connection connection;
    TriplesMapNode tmap;
    R2RMLTree tree;

    public ReferencingObjectMapPopupDialog(Connection connection, R2RMLTree r2RMLTree, TriplesMapNode triplesMapNode, ObjectMapNode objectMapNode) {
        super((Frame)null, R2RMLArb.getString("ReferencingObjectMapPopupDialog.REFERENCING_OBJECT_MAP_EDITOR_") + objectMapNode.getValue(), true);
        this.connection = connection;
        this.tmap = triplesMapNode;
        this.tree = r2RMLTree;
        this.node = objectMapNode;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(R2RMLArb.getString("ReferencingObjectMapPopupDialog.REFERENCING_OBJECT_MAP")));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        this.lblParentTMAP = new JLabel(R2RMLArb.getString("ReferencingObjectMapPopupDialog.PARENT_TRIPLES_MAP_"));
        jPanel2.add(this.lblParentTMAP);
        List<String> list = r2RMLTree.getRoot().getChildren().stream().map(r2RMLNode -> r2RMLNode.getValue()).collect(Collectors.toList());
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(list.toArray(new String[0]));
        this.selParentTMAP = new JComboBox<String>(defaultComboBoxModel);
        this.lblParentTMAP.setLabelFor(this.selParentTMAP);
        jPanel2.add(this.selParentTMAP);
        if (objectMapNode.getParentTriplesMap().getValue() == null || objectMapNode.getParentTriplesMap().getValue().equals(R2RMLArb.getString("ReferencingObjectMapPopupDialog._CLICK_TO_DEFINE_"))) {
            objectMapNode.removeChildEdge("<http://www.w3.org/ns/r2rml#parentTriplesMap>");
            objectMapNode.addChildEdge("<http://www.w3.org/ns/r2rml#parentTriplesMap>", r2RMLTree.getRoot().getChildren().get(0));
        }
        this.selParentTMAP.setSelectedItem(objectMapNode.getParentTriplesMap().getValue());
        jPanel.add(jPanel2);
        JoinConditionListEditor joinConditionListEditor = new JoinConditionListEditor(this.connection, this.tree, this.tmap, objectMapNode);
        this.selParentTMAP.addItemListener(joinConditionListEditor);
        jPanel.add(joinConditionListEditor);
        this.getContentPane().add(jPanel);
        JButton jButton = new JButton(RdfgraphArb.getString("CANCEL"));
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(RdfgraphArb.getString("DIALOG_OK_BUTTON_TEXT"));
        jButton2.setPreferredSize(jButton.getPreferredSize());
        jButton2.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton2);
        jPanel3.add(jButton);
        this.getContentPane().add((Component)jPanel3, "South");
        this.pack();
        this.getRootPane().setDefaultButton(jButton2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (RdfgraphArb.getString("DIALOG_OK_BUTTON_TEXT").equals(actionEvent.getActionCommand())) {
            // empty if block
        }
        this.setVisible(false);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension((int)dimension.getWidth(), 300);
    }
}

