/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.objectmap;

import java.util.List;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.language.ColumnNameNode;
import oracle.dbtools.rdfgraph.r2rml.language.ObjectMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.PredicateObjectMap;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLNode;
import oracle.dbtools.rdfgraph.r2rml.language.StringTemplateNode;
import oracle.dbtools.rdfgraph.r2rml.language.TermMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.dbtools.rdfgraph.utils.RDFPrefixManager;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;

public class ObjectMapTableModel
extends AbstractTableModel {
    private final String[] headers = new String[]{R2RMLArb.getString("OBJECT_VALUE"), RdfgraphArb.getString("TYPE"), " "};
    private final PredicateObjectMap node;
    final int TMAP_TYPE_VAL = 0;
    final int TMAP_TYPE_COL = 1;
    final int TMAP_PROPS_COL = 2;

    public ObjectMapTableModel(PredicateObjectMap predicateObjectMap) {
        this.node = predicateObjectMap;
    }

    @Override
    public int getRowCount() {
        return this.node.getObjectMaps().size();
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                ObjectMapNode objectMapNode = (ObjectMapNode)this.node.getObjectMaps().get(n);
                return objectMapNode.getSimpleValue();
            }
            case 1: {
                ObjectMapNode objectMapNode = (ObjectMapNode)this.node.getObjectMaps().get(n);
                return objectMapNode.getMappingType();
            }
            case 2: {
                String string;
                TermMapNode termMapNode = (TermMapNode)this.node.getObjectMaps().get(n);
                List<R2RMLNode> list = termMapNode.getTermMapProperties();
                if (list.isEmpty()) {
                    string = R2RMLArb.getString("ObjectMapTableModel._DEFAULT_");
                } else {
                    List list2 = list.stream().map(r2RMLNode -> RDFPrefixManager.shortenURI(r2RMLNode.getValue())).collect(Collectors.toList());
                    string = String.join((CharSequence)", ", list2);
                }
                return string;
            }
        }
        return "NULL";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 2) {
            this.setTermMapProperties();
            return;
        }
        if (n2 == 0) {
            this.setTermMapValue(object, n, n2);
        }
        if (n2 == 1) {
            this.setTermMappingType(object, n, n2);
        }
        this.fireTableDataChanged();
    }

    public void setTermMapProperties() {
        this.fireTableDataChanged();
    }

    private void setTermMapValue(Object object, int n, int n2) {
        String string = "";
        String string2 = "";
        string = n2 == 0 ? (String)object : (String)this.getValueAt(n, 0);
        string2 = n2 == 1 ? (String)object : (String)this.getValueAt(n, 1);
        ObjectMapNode objectMapNode = (ObjectMapNode)this.node.getObjectMaps().get(n);
        if (string2.equals(R2RMLArb.getString("CONSTANT")) && objectMapNode.isShortcut()) {
            this.node.getObjectMaps().get(n).setValue(string);
        }
        if (string2.equals(R2RMLArb.getString("CONSTANT")) && !objectMapNode.isShortcut()) {
            objectMapNode.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#constant>").setValue(string);
        }
        if (string2.equals(R2RMLArb.getString("TEMPLATE"))) {
            objectMapNode.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#template>").setValue(string);
        }
        if (string2.equals(R2RMLArb.getString("COLUMN"))) {
            objectMapNode.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#column>").setValue(string);
        }
    }

    public void setTermMappingType(Object object, int n, int n2) {
        String string = "";
        String string2 = "";
        string = n2 == 0 ? (String)object : (String)this.getValueAt(n, 0);
        string2 = n2 == 1 ? (String)object : (String)this.getValueAt(n, 1);
        ObjectMapNode objectMapNode = (ObjectMapNode)this.node.getObjectMaps().get(n);
        if (objectMapNode.getMappingType().equals(string2)) {
            return;
        }
        if (string2.equals(R2RMLArb.getString("CONSTANT")) && objectMapNode.isShortcut()) {
            this.node.getObjectMaps().get(n).setValue(string);
        }
        if (string2.equals(R2RMLArb.getString("CONSTANT")) && !objectMapNode.isShortcut()) {
            this.node.removeChild(objectMapNode);
            objectMapNode = new ObjectMapNode("_:" + RDFStringUtils.generateRandomId());
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#objectMap>", objectMapNode);
            objectMapNode.addChildEdge("<http://www.w3.org/ns/r2rml#constant>", new R2RMLNode(string));
        }
        if (string2.equals(R2RMLArb.getString("TEMPLATE"))) {
            this.node.removeChild(objectMapNode);
            objectMapNode = new ObjectMapNode("_:" + RDFStringUtils.generateRandomId());
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#objectMap>", objectMapNode);
            objectMapNode.addChildEdge("<http://www.w3.org/ns/r2rml#template>", new StringTemplateNode(string));
        }
        if (string2.equals(R2RMLArb.getString("COLUMN"))) {
            this.node.removeChild(objectMapNode);
            objectMapNode = new ObjectMapNode("_:" + RDFStringUtils.generateRandomId());
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#objectMap>", objectMapNode);
            objectMapNode.addChildEdge("<http://www.w3.org/ns/r2rml#column>", new ColumnNameNode(string));
        }
        if (string2.equals(R2RMLArb.getString("REFERENCE"))) {
            this.node.removeChild(objectMapNode);
            objectMapNode = new ObjectMapNode("_:" + RDFStringUtils.generateRandomId());
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#objectMap>", objectMapNode);
            objectMapNode.addChildEdge("<http://www.w3.org/ns/r2rml#parentTriplesMap>", new TriplesMapNode(R2RMLArb.getString("ObjectMapTableModel._CLICK_TO_DEFINE_")));
        }
    }

    public void removeRow(int n) {
        R2RMLNode r2RMLNode = this.node.getObjectMaps().get(n);
        this.node.removeChild(r2RMLNode);
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public String getColumnName(int n) {
        return this.headers[n];
    }
}

