/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.objectmap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.ObjectMapTableModel;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.ObjectMapValueCellEditor;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.TermMapPropertiesCellEditor;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.TermMapPropertiesCellRenderer;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.TermMapTypeCellEditor;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.TermMapValueCellRenderer;
import oracle.dbtools.rdfgraph.r2rml.language.ObjectMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.PredicateObjectMap;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLTree;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;
import oracle.javatools.icons.OracleIcons;

public class ObjectMapListEditor
extends JPanel {
    private static final String OMAP_LIST_TITLE = R2RMLArb.getString("ObjectMapListEditor.OBJECT_MAP_S_");
    R2RMLTree tree;
    TriplesMapNode tmap;
    PredicateObjectMap node;
    Connection connection;
    private JTable table;
    private ObjectMapTableModel tmodel;
    private JToolBar toolbar;
    public static final int VALUE_COL_IDX = 0;
    public static final int TYPE_COL_IDX = 1;
    public static final int TMAP_PROPS_COL_IDX = 2;

    public ObjectMapListEditor(R2RMLTree r2RMLTree, TriplesMapNode triplesMapNode, PredicateObjectMap predicateObjectMap, Connection connection) {
        this.tree = r2RMLTree;
        this.tmap = triplesMapNode;
        this.node = predicateObjectMap;
        this.connection = connection;
        this.setBorder(BorderFactory.createTitledBorder(OMAP_LIST_TITLE));
        this.setLayout(new BorderLayout());
        this.initUI();
    }

    private void initUI() {
        this.table = this.createTable();
        this.toolbar = this.createToolBar();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.toolbar, "North");
    }

    private JTable createTable() {
        this.tmodel = new ObjectMapTableModel(this.node);
        this.table = new JTable(this.tmodel);
        this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
        this.table.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.table.setAutoResizeMode(3);
        this.table.setFillsViewportHeight(true);
        this.table.getColumnModel().getColumn(1).setCellEditor(new TermMapTypeCellEditor());
        this.table.getColumnModel().getColumn(0).setCellEditor(new ObjectMapValueCellEditor(this.tree, this.tmap, this.node, this.connection));
        this.table.getColumnModel().getColumn(0).setCellRenderer(new TermMapValueCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellEditor(new TermMapPropertiesCellEditor(this.tmap, this.node, this.connection));
        this.table.getColumnModel().getColumn(2).setCellRenderer(new TermMapPropertiesCellRenderer());
        return this.table;
    }

    private JToolBar createToolBar() {
        this.toolbar = new JToolBar();
        JButton jButton = new JButton(R2RMLArb.getString("ObjectMapListEditor.ADD_OBJECT_MAP"), OracleIcons.getIcon((String)"add.png"));
        jButton.addActionListener(actionEvent -> {
            ObjectMapNode objectMapNode = new ObjectMapNode("_:" + RDFStringUtils.generateRandomId());
            objectMapNode.addChildEdge("<http://www.w3.org/ns/r2rml#constant>", new R2RMLNode("<urn:someObject>"));
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#objectMap>", objectMapNode);
            this.tmodel.fireTableDataChanged();
            int n = this.node.getObjectMaps().size();
            boolean bl = this.table.editCellAt(n - 1, 0);
            if (bl) {
                boolean bl2 = false;
                boolean bl3 = false;
                this.table.changeSelection(n - 1, 0, bl2, bl3);
                this.table.requestFocusInWindow();
            }
        });
        JButton jButton2 = new JButton(RdfgraphArb.getString("DELETE"), OracleIcons.getIcon((String)"delete.png"));
        jButton2.addActionListener(actionEvent -> {
            if (this.table.getSelectedRow() != -1) {
                int n = this.table.getSelectedRow();
                this.table.clearSelection();
                if (this.table.isEditing()) {
                    this.table.getCellEditor().stopCellEditing();
                }
                this.tmodel.removeRow(n);
            }
        });
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add(jButton);
        this.toolbar.add(jButton2);
        return this.toolbar;
    }
}

