/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.objectmap;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellEditor;
import javax.swing.text.BadLocationException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.editor.ColumnHelperUtils;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLStringNode;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;

public class GraphMapValueCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    JTextArea textEditor;
    Connection connection;
    SqlComboBoxActionControl sqlSelectCol;
    CardLayout cardLayout;
    String editorValue = "";
    String tmtype;
    TriplesMapNode tmap;
    final int TMAP_TYPE_COL = 1;

    public GraphMapValueCellEditor(TriplesMapNode triplesMapNode, Connection connection) {
        this.connection = connection;
        this.tmap = triplesMapNode;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        String string;
        this.editorValue = (String)object;
        this.tmtype = (String)jTable.getValueAt(n, 1);
        this.textEditor = new JTextArea((String)object);
        this.textEditor.setFocusTraversalKeys(0, null);
        this.textEditor.setFocusTraversalKeys(1, null);
        this.textEditor.getDocument().putProperty("filterNewlines", Boolean.TRUE);
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.textEditor.add(jPopupMenu);
        this.textEditor.setComponentPopupMenu(jPopupMenu);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                int n = GraphMapValueCellEditor.this.textEditor.getCaretPosition();
                try {
                    GraphMapValueCellEditor.this.textEditor.getDocument().insertString(n, "{\\\"" + jMenuItem.getText() + "\\\"}", null);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(this.getClass().getName()).warning(badLocationException.getMessage());
                }
            }
        };
        String string2 = this.tmap.getCleanSource();
        String[] stringArray = string2.split("\\.");
        if (stringArray.length == 1) {
            string = string2.split("\\.")[0];
        } else {
            String string3 = string2.split("\\.")[0];
            string = string2.split("\\.")[1];
        }
        if (this.tmap.getSourceType().equalsIgnoreCase(RdfgraphArb.getString("QUERY"))) {
            R2RMLStringNode r2RMLStringNode = (R2RMLStringNode)this.tmap.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#logicalTable>").getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#sqlQuery>");
            String string4 = RDFStringUtils.unescapeJavaString(r2RMLStringNode.getValue());
            string4 = RDFStringUtils.removeWrappingQuotes(string4);
            this.sqlSelectCol = new SqlComboBoxActionControl("sel_col", "Col", this.connection, "select * from dual where 1=0");
            this.sqlSelectCol.enableEditBox();
            for (String string5 : ColumnHelperUtils.getColumnsFromQuery(this.connection, string4)) {
                jPopupMenu.add(string5).addActionListener(actionListener);
                this.sqlSelectCol.getUI().addItem(string5);
            }
        } else {
            String string6 = "SELECT COLUMN_NAME from ALL_TAB_COLUMNS where TABLE_NAME = '" + string + "' ";
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.connection);
            List list = dBUtil.executeReturnList(string6, new HashMap());
            for (Map map : list) {
                jPopupMenu.add((String)map.get("COLUMN_NAME")).addActionListener(actionListener);
            }
            this.sqlSelectCol = new SqlComboBoxActionControl("sel_col", "Col", this.connection, string6);
        }
        this.sqlSelectCol.enableEditBox();
        if (this.tmtype.equals(R2RMLArb.getString("COLUMN"))) {
            this.sqlSelectCol.getUI().setSelectedItem(RDFStringUtils.stripSQLName(this.editorValue));
            return this.sqlSelectCol.getUI();
        }
        return this.textEditor;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.tmtype.equals(R2RMLArb.getString("COLUMN"))) {
            String string = (String)this.sqlSelectCol.getUI().getSelectedItem();
            return "\"\\\"" + string + "\"\\\"";
        }
        if (this.tmtype.equals(R2RMLArb.getString("TEMPLATE"))) {
            Object object = this.textEditor.getText().trim();
            if (((String)object).charAt(0) != '\"') {
                object = "\"" + (String)object;
            }
            if (((String)object).charAt(((String)object).length() - 1) != '\"') {
                object = (String)object + "\"";
            }
            this.textEditor.setText((String)object);
        }
        return this.textEditor.getText();
    }
}

