/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.vm.PolyglotLanguageContext;
import com.oracle.truffle.api.vm.VMAccessor;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;

final class PolyglotSourceCache {
    private final ConcurrentHashMap<Object, CallTarget> sourceCache;
    private final ReferenceQueue<Source> deadSources = new ReferenceQueue();

    PolyglotSourceCache() {
        this.sourceCache = new ConcurrentHashMap();
    }

    CallTarget parseCached(PolyglotLanguageContext context, Source source, String[] argumentNames) {
        CallTarget target;
        this.cleanupStaleEntries();
        if (source.isCached()) {
            CallTarget prev;
            Object sourceId = VMAccessor.SOURCE.getSourceIdentifier(source);
            WeakSourceKey ref = new WeakSourceKey(sourceId, source, argumentNames, this.deadSources);
            target = this.sourceCache.get(ref);
            if (target == null && (prev = this.sourceCache.putIfAbsent(ref, target = PolyglotSourceCache.parseImpl(context, argumentNames, VMAccessor.SOURCE.copySource(source)))) != null) {
                target = prev;
            }
        } else {
            target = PolyglotSourceCache.parseImpl(context, argumentNames, source);
        }
        return target;
    }

    private static CallTarget parseImpl(PolyglotLanguageContext context, String[] argumentNames, Source source) {
        CallTarget parsedTarget = VMAccessor.LANGUAGE.parse(context.requireEnv(), source, null, argumentNames);
        if (parsedTarget == null) {
            throw new IllegalStateException(String.format("Parsing resulted in a null CallTarget for %s.", source));
        }
        return parsedTarget;
    }

    private void cleanupStaleEntries() {
        WeakSourceKey sourceRef = null;
        while ((sourceRef = (WeakSourceKey)this.deadSources.poll()) != null) {
            this.sourceCache.remove(sourceRef);
        }
    }

    private static final class WeakSourceKey
    extends WeakReference<Source> {
        final Object key;
        private final String[] arguments;

        WeakSourceKey(Object key, Source value, String[] arguments, ReferenceQueue<? super Source> q) {
            super(value, q);
            this.key = key;
            this.arguments = arguments != null && arguments.length == 0 ? null : arguments;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.key.hashCode();
            result = 31 * result + Arrays.hashCode(this.arguments);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WeakSourceKey) {
                WeakSourceKey other = (WeakSourceKey)obj;
                return this.key.equals(other.key) && Arrays.equals(this.arguments, other.arguments);
            }
            return false;
        }
    }
}

