/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.vm.LanguageCache;
import com.oracle.truffle.api.vm.VMAccessor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileTypeDetector;
import java.util.Collection;
import java.util.Objects;
import java.util.ServiceLoader;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

class PolyglotSource
extends AbstractPolyglotImpl.AbstractSourceImpl {
    protected PolyglotSource(AbstractPolyglotImpl engineImpl) {
        super(engineImpl);
    }

    public String getName(Object impl) {
        Source source = (Source)impl;
        return source.getName();
    }

    public String getPath(Object impl) {
        Source source = (Source)impl;
        return source.getPath();
    }

    public boolean isInteractive(Object impl) {
        Source source = (Source)impl;
        return source.isInteractive();
    }

    public boolean isInternal(Object impl) {
        Source source = (Source)impl;
        return source.isInternal();
    }

    public URL getURL(Object impl) {
        Source source = (Source)impl;
        return source.getURL();
    }

    public URI getURI(Object impl) {
        Source source = (Source)impl;
        return source.getURI();
    }

    public Reader getReader(Object impl) {
        Source source = (Source)impl;
        return source.getReader();
    }

    public InputStream getInputStream(Object impl) {
        Source source = (Source)impl;
        return source.getInputStream();
    }

    public int getLength(Object impl) {
        Source source = (Source)impl;
        return source.getLength();
    }

    public CharSequence getCode(Object impl) {
        Source source = (Source)impl;
        return source.getCharacters();
    }

    public CharSequence getCode(Object impl, int lineNumber) {
        Source source = (Source)impl;
        return source.getCharacters(lineNumber);
    }

    public int getLineCount(Object impl) {
        Source source = (Source)impl;
        return source.getLineCount();
    }

    public int getLineNumber(Object impl, int offset) {
        Source source = (Source)impl;
        return source.getLineNumber(offset);
    }

    public int getColumnNumber(Object impl, int offset) {
        Source source = (Source)impl;
        return source.getColumnNumber(offset);
    }

    public int getLineStartOffset(Object impl, int lineNumber) {
        Source source = (Source)impl;
        return source.getLineStartOffset(lineNumber);
    }

    public int getLineLength(Object impl, int lineNumber) {
        Source source = (Source)impl;
        return source.getLineLength(lineNumber);
    }

    public String toString(Object impl) {
        Source source = (Source)impl;
        return source.toString();
    }

    public String findLanguage(File file) throws IOException {
        Objects.requireNonNull(file);
        Path path = Paths.get(file.toURI());
        return PolyglotSource.findLanguageImpl(path);
    }

    static String findLanguageImpl(Path path) throws IOException {
        LanguageCache cache;
        String mimeType = PolyglotSource.getMimeType(path);
        if (mimeType != null && (cache = LanguageCache.languages().get(mimeType)) != null) {
            return cache.getId();
        }
        return null;
    }

    public String findLanguage(String mimeType) {
        Objects.requireNonNull(mimeType);
        LanguageCache cache = LanguageCache.languages().get(mimeType);
        if (cache != null) {
            return cache.getId();
        }
        return null;
    }

    static String getMimeType(Path filePath) throws IOException {
        if (!TruffleOptions.AOT) {
            Collection<ClassLoader> loaders = VMAccessor.allLoaders();
            for (ClassLoader l : loaders) {
                for (FileTypeDetector detector : ServiceLoader.load(FileTypeDetector.class, l)) {
                    String mimeType = detector.probeContentType(filePath);
                    if (mimeType == null) continue;
                    return mimeType;
                }
            }
        }
        String found = Files.probeContentType(filePath);
        return found;
    }

    public int hashCode(Object impl) {
        return impl.hashCode();
    }

    public boolean equals(Object impl, Object otherImpl) {
        return impl.equals(otherImpl);
    }

    public org.graalvm.polyglot.Source build(String language, Object origin, URI uri, String name, CharSequence content, boolean interactive, boolean internal, boolean cached) throws IOException {
        Source.Builder<Exception, Exception, Exception> builder;
        assert (language != null);
        boolean needsName = false;
        if (origin instanceof File) {
            builder = Source.newBuilder((File)origin);
        } else if (origin instanceof CharSequence) {
            builder = Source.newBuilder((CharSequence)origin);
            needsName = true;
        } else if (origin instanceof Reader) {
            builder = Source.newBuilder((Reader)origin);
            needsName = true;
        } else if (origin instanceof URL) {
            builder = Source.newBuilder((URL)origin);
        } else {
            throw new AssertionError();
        }
        if (uri != null) {
            builder.uri(uri);
        }
        if (name != null) {
            builder.name(name);
        } else if (needsName) {
            builder.name("Unnamed");
        }
        if (content != null) {
            builder.content(content);
        }
        if (internal) {
            builder.internal();
        }
        if (interactive) {
            builder.interactive();
        }
        builder.cached(cached);
        builder.language(language);
        try {
            return this.engineImpl.getAPIAccess().newSource(language, (Object)builder.build());
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionError();
        }
    }
}

