/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.vm.PolyglotImpl;
import com.oracle.truffle.api.vm.PolyglotLanguageContext;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.Proxy;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.graalvm.polyglot.proxy.ProxyInstantiable;
import org.graalvm.polyglot.proxy.ProxyNativeObject;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.graalvm.polyglot.proxy.ProxyPrimitive;

final class PolyglotProxy {
    PolyglotProxy() {
    }

    public static boolean isProxyGuestObject(TruffleObject value) {
        return value instanceof EngineProxy;
    }

    public static Proxy toProxyHostObject(TruffleObject value) {
        return ((EngineProxy)value).proxy;
    }

    public static TruffleObject toProxyGuestObject(PolyglotLanguageContext context, Proxy receiver) {
        return new EngineProxy(context, receiver);
    }

    private static Object[] copyFromStart(Object[] arguments, int startIndex) {
        Object[] newArguments = new Object[arguments.length - startIndex];
        for (int i = startIndex; i < arguments.length; ++i) {
            newArguments[i - startIndex] = arguments[i];
        }
        return newArguments;
    }

    private static final class EngineProxyFactory
    implements ForeignAccess.StandardFactory {
        private static final ForeignAccess INSTANCE = ForeignAccess.create(EngineProxy.class, new EngineProxyFactory());

        private EngineProxyFactory() {
        }

        @Override
        public CallTarget accessWrite() {
            return Truffle.getRuntime().createCallTarget(new ProxyWriteNode());
        }

        @Override
        public CallTarget accessIsBoxed() {
            return Truffle.getRuntime().createCallTarget(new ProxyIsBoxedNode());
        }

        @Override
        public CallTarget accessUnbox() {
            return Truffle.getRuntime().createCallTarget(new ProxyUnboxNode());
        }

        @Override
        public CallTarget accessRead() {
            return Truffle.getRuntime().createCallTarget(new ProxyReadNode());
        }

        @Override
        public CallTarget accessRemove() {
            return Truffle.getRuntime().createCallTarget(new ProxyRemoveNode());
        }

        @Override
        public CallTarget accessIsInstantiable() {
            return Truffle.getRuntime().createCallTarget(new ProxyIsInstantiableNode());
        }

        @Override
        public CallTarget accessNew(int argumentsLength) {
            return Truffle.getRuntime().createCallTarget(new ProxyNewNode());
        }

        @Override
        public CallTarget accessHasKeys() {
            return Truffle.getRuntime().createCallTarget(new ProxyHasKeysNode());
        }

        @Override
        public CallTarget accessKeys() {
            return Truffle.getRuntime().createCallTarget(new ProxyKeysNode());
        }

        @Override
        public CallTarget accessKeyInfo() {
            return Truffle.getRuntime().createCallTarget(new ProxyKeyInfoNode());
        }

        @Override
        public CallTarget accessIsNull() {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
        }

        @Override
        public CallTarget accessIsExecutable() {
            return Truffle.getRuntime().createCallTarget(new ProxyIsExecutableNode());
        }

        @Override
        public CallTarget accessInvoke(int argumentsLength) {
            return Truffle.getRuntime().createCallTarget(new ProxyInvokeNode());
        }

        @Override
        public CallTarget accessHasSize() {
            return Truffle.getRuntime().createCallTarget(new ProxyHasSizeNode());
        }

        @Override
        public CallTarget accessGetSize() {
            return Truffle.getRuntime().createCallTarget(new ProxyGetSizeNode());
        }

        @Override
        public CallTarget accessExecute(int argumentsLength) {
            return Truffle.getRuntime().createCallTarget(new ProxyExecuteNode());
        }

        @Override
        public CallTarget accessIsPointer() {
            return Truffle.getRuntime().createCallTarget(new ProxyIsPointerNode());
        }

        @Override
        public CallTarget accessAsPointer() {
            return Truffle.getRuntime().createCallTarget(new ProxyAsPointerNode());
        }

        @Override
        public CallTarget accessToNative() {
            return null;
        }

        @Override
        public CallTarget accessMessage(Message unknown) {
            return null;
        }
    }

    private static final class ProxyRemoveNode
    extends ProxyRootNode {
        private ProxyRemoveNode() {
        }

        @Override
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            if (arguments.length >= 2) {
                Object key = arguments[1];
                if (proxy instanceof ProxyArray && key instanceof Number) {
                    return ProxyRemoveNode.removeArrayElement((ProxyArray)proxy, (Number)key);
                }
                if (proxy instanceof ProxyObject && key instanceof String) {
                    return ProxyRemoveNode.removeMember((ProxyObject)proxy, (String)key);
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.raise(Message.READ);
        }

        @CompilerDirectives.TruffleBoundary
        static boolean removeMember(ProxyObject object, String key) {
            if (object.hasMember(key)) {
                try {
                    return object.removeMember(key);
                }
                catch (UnsupportedOperationException e) {
                    throw UnsupportedMessageException.raise(Message.READ);
                }
            }
            throw UnknownIdentifierException.raise(key);
        }

        @CompilerDirectives.TruffleBoundary
        static boolean removeArrayElement(ProxyArray object, Number index) {
            boolean result;
            try {
                result = object.remove(index.longValue());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw UnknownIdentifierException.raise(e.getMessage());
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.raise(Message.READ);
            }
            return result;
        }
    }

    private static final class ProxyReadNode
    extends ProxyRootNode {
        private ProxyReadNode() {
        }

        @Override
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            if (arguments.length >= 2) {
                Object key = arguments[1];
                if (proxy instanceof ProxyArray && key instanceof Number) {
                    return ProxyReadNode.getArray(context, (ProxyArray)proxy, (Number)key);
                }
                if (proxy instanceof ProxyObject && key instanceof String) {
                    return ProxyReadNode.getMember(context, (ProxyObject)proxy, (String)key);
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.raise(Message.READ);
        }

        @CompilerDirectives.TruffleBoundary
        static Object getMember(PolyglotLanguageContext context, ProxyObject object, String key) {
            if (object.hasMember(key)) {
                try {
                    return context.toGuestValue(object.getMember(key));
                }
                catch (UnsupportedOperationException e) {
                    throw UnsupportedMessageException.raise(Message.READ);
                }
            }
            throw UnknownIdentifierException.raise(key);
        }

        @CompilerDirectives.TruffleBoundary
        static Object getArray(PolyglotLanguageContext context, ProxyArray object, Number index) {
            Object result;
            try {
                result = object.get(index.longValue());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw UnknownIdentifierException.raise(e.getMessage());
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.raise(Message.READ);
            }
            return context.toGuestValue(result);
        }
    }

    private static final class ProxyWriteNode
    extends ProxyRootNode {
        private ProxyWriteNode() {
        }

        @Override
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            if (arguments.length >= 3) {
                Object key = arguments[1];
                Object value = arguments[2];
                if (proxy instanceof ProxyArray && key instanceof Number) {
                    ProxyWriteNode.setArray(context, (ProxyArray)proxy, (Number)key, value);
                    return value;
                }
                if (proxy instanceof ProxyObject && key instanceof String) {
                    ProxyWriteNode.putMember(context, (ProxyObject)proxy, (String)key, value);
                    return value;
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.raise(Message.WRITE);
        }

        @CompilerDirectives.TruffleBoundary
        static void putMember(PolyglotLanguageContext context, ProxyObject object, String key, Object value) {
            try {
                object.putMember(key, context.toHostValue(value));
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.raise(Message.WRITE);
            }
        }

        @CompilerDirectives.TruffleBoundary
        static void setArray(PolyglotLanguageContext context, ProxyArray object, Number index, Object value) {
            Value castValue = context.toHostValue(value);
            try {
                object.set(index.longValue(), castValue);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw UnknownIdentifierException.raise(e.getMessage());
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.raise(Message.READ);
            }
        }
    }

    private static final class ProxyInvokeNode
    extends ProxyRootNode {
        @Node.Child
        private Node isExecutable = Message.IS_EXECUTABLE.createNode();
        @Node.Child
        private Node executeNode = Message.createExecute(0).createNode();

        private ProxyInvokeNode() {
        }

        @Override
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            if (arguments.length >= 2) {
                Object key = arguments[1];
                if (proxy instanceof ProxyObject && key instanceof String) {
                    return this.invoke(context, (ProxyObject)proxy, (String)key, arguments);
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.raise(Message.createInvoke(0));
        }

        @CompilerDirectives.TruffleBoundary
        Object invoke(PolyglotLanguageContext context, ProxyObject object, String key, Object[] arguments) {
            if (object.hasMember(key)) {
                Object member = context.toGuestValue(object.getMember(key));
                if (member instanceof TruffleObject && ForeignAccess.sendIsExecutable(this.isExecutable, (TruffleObject)member)) {
                    try {
                        return ForeignAccess.sendExecute(this.executeNode, (TruffleObject)member, PolyglotProxy.copyFromStart(arguments, 2));
                    }
                    catch (InteropException e) {
                        throw e.raise();
                    }
                }
                throw UnknownIdentifierException.raise(key);
            }
            throw UnknownIdentifierException.raise(key);
        }
    }

    private static final class ProxyKeyInfoNode
    extends ProxyRootNode {
        static final Integer KEY = 38;

        private ProxyKeyInfoNode() {
        }

        @Override
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            if (arguments.length >= 2) {
                Object key = arguments[1];
                if (proxy instanceof ProxyObject && key instanceof String) {
                    return ProxyKeyInfoNode.keyInfo((ProxyObject)proxy, (String)key);
                }
                if (proxy instanceof ProxyArray && key instanceof Number) {
                    return ProxyKeyInfoNode.keyInfo((ProxyArray)proxy, (Number)key);
                }
            }
            return 0;
        }

        @CompilerDirectives.TruffleBoundary
        private static Integer keyInfo(ProxyArray proxy, Number key) {
            long size = proxy.getSize();
            long index = key.longValue();
            if (index >= 0L && index < size) {
                return KEY;
            }
            return 64;
        }

        @CompilerDirectives.TruffleBoundary
        private static Integer keyInfo(ProxyObject proxy, String key) {
            if (proxy.hasMember(key)) {
                return KEY;
            }
            return 64;
        }
    }

    private static final class ProxyKeysNode
    extends ProxyRootNode {
        @Node.Child
        private Node hasSize = Message.HAS_SIZE.createNode();
        private static final ProxyArray EMPTY = new ProxyArray(){

            public void set(long index, Value value) {
                throw new ArrayIndexOutOfBoundsException();
            }

            public long getSize() {
                return 0L;
            }

            public Object get(long index) {
                throw new ArrayIndexOutOfBoundsException();
            }
        };

        private ProxyKeysNode() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            Object result;
            if (proxy instanceof ProxyObject) {
                ProxyObject object = (ProxyObject)proxy;
                result = object.getMemberKeys();
                if (result == null) {
                    result = EMPTY;
                }
            } else {
                result = EMPTY;
            }
            Object guestValue = context.toGuestValue(result);
            if (!(guestValue instanceof TruffleObject) || !ForeignAccess.sendHasSize(this.hasSize, (TruffleObject)guestValue)) {
                throw PolyglotImpl.wrapHostException(context, new IllegalStateException(String.format("getMemberKeys() returned invalid value %s but must return an array of member key Strings.", context.toHostValue(guestValue).toString())));
            }
            return guestValue;
        }
    }

    private static final class ProxyHasKeysNode
    extends ProxyRootNode {
        private ProxyHasKeysNode() {
        }

        @Override
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            return proxy instanceof ProxyObject;
        }
    }

    private static final class ProxyGetSizeNode
    extends ProxyRootNode {
        private ProxyGetSizeNode() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            if (proxy instanceof ProxyArray) {
                return (int)((ProxyArray)proxy).getSize();
            }
            throw UnsupportedMessageException.raise(Message.GET_SIZE);
        }
    }

    private static final class ProxyHasSizeNode
    extends ProxyRootNode {
        private ProxyHasSizeNode() {
        }

        @Override
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            return proxy instanceof ProxyArray;
        }
    }

    private static final class ProxyUnboxNode
    extends ProxyRootNode {
        private ProxyUnboxNode() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            if (proxy instanceof ProxyPrimitive) {
                Object primitive = ((ProxyPrimitive)proxy).asPrimitive();
                if (primitive instanceof String || primitive instanceof Boolean || primitive instanceof Character || primitive instanceof Byte || primitive instanceof Short || primitive instanceof Integer || primitive instanceof Long || primitive instanceof Float || primitive instanceof Double) {
                    return primitive;
                }
                throw new IllegalStateException(String.format("Invalid return value for %s. Only Java primitive values or String is allowed as return value fo asPrimitive().", ProxyPrimitive.class.getSimpleName()));
            }
            throw UnsupportedMessageException.raise(Message.UNBOX);
        }
    }

    private static final class ProxyIsBoxedNode
    extends ProxyRootNode {
        private ProxyIsBoxedNode() {
        }

        @Override
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            return proxy instanceof ProxyPrimitive;
        }
    }

    private static final class ProxyAsPointerNode
    extends ProxyRootNode {
        private ProxyAsPointerNode() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            if (proxy instanceof ProxyNativeObject) {
                return ((ProxyNativeObject)proxy).asPointer();
            }
            throw UnsupportedMessageException.raise(Message.AS_POINTER);
        }
    }

    private static final class ProxyIsPointerNode
    extends ProxyRootNode {
        private ProxyIsPointerNode() {
        }

        @Override
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            return proxy instanceof ProxyNativeObject;
        }
    }

    private static final class ProxyIsExecutableNode
    extends ProxyRootNode {
        private ProxyIsExecutableNode() {
        }

        @Override
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            return proxy instanceof ProxyExecutable;
        }
    }

    private static final class ProxyExecuteNode
    extends ProxyRootNode {
        private ProxyExecuteNode() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            if (proxy instanceof ProxyExecutable) {
                return context.toGuestValue(((ProxyExecutable)proxy).execute(context.toHostValues(arguments, 1)));
            }
            throw UnsupportedMessageException.raise(Message.createExecute(0));
        }
    }

    private static final class ProxyIsInstantiableNode
    extends ProxyRootNode {
        private ProxyIsInstantiableNode() {
        }

        @Override
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            return proxy instanceof ProxyInstantiable;
        }
    }

    private static final class ProxyNewNode
    extends ProxyRootNode {
        private ProxyNewNode() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        Object executeProxy(PolyglotLanguageContext context, Proxy proxy, Object[] arguments) {
            if (proxy instanceof ProxyInstantiable) {
                return context.toGuestValue(((ProxyInstantiable)proxy).newInstance(context.toHostValues(arguments, 1)));
            }
            throw UnsupportedMessageException.raise(Message.createNew(0));
        }
    }

    private static abstract class ProxyRootNode
    extends RootNode {
        @CompilerDirectives.CompilationFinal
        boolean seenException = false;

        protected ProxyRootNode() {
            super(null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object[] arguments = frame.getArguments();
            EngineProxy proxy = (EngineProxy)arguments[0];
            PolyglotLanguageContext context = proxy.languageContext;
            try {
                return this.executeProxy(context, proxy.proxy, arguments);
            }
            catch (Throwable t) {
                if (!this.seenException) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenException = true;
                }
                throw PolyglotImpl.wrapHostException(context, t);
            }
        }

        abstract Object executeProxy(PolyglotLanguageContext var1, Proxy var2, Object[] var3);
    }

    private static class EngineProxy
    implements TruffleObject {
        final PolyglotLanguageContext languageContext;
        final Proxy proxy;

        EngineProxy(PolyglotLanguageContext context, Proxy proxy) {
            this.languageContext = context;
            this.proxy = proxy;
        }

        @Override
        public ForeignAccess getForeignAccess() {
            return EngineProxyFactory.INSTANCE;
        }
    }
}

