/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.vm.LanguageCache;
import com.oracle.truffle.api.vm.OptionValuesImpl;
import com.oracle.truffle.api.vm.PolyglotContextImpl;
import com.oracle.truffle.api.vm.PolyglotEngineImpl;
import com.oracle.truffle.api.vm.PolyglotImpl;
import com.oracle.truffle.api.vm.PolyglotLanguageContext;
import com.oracle.truffle.api.vm.PolyglotSourceCache;
import com.oracle.truffle.api.vm.VMAccessor;
import java.util.Set;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotLanguage
extends AbstractPolyglotImpl.AbstractLanguageImpl
implements PolyglotImpl.VMObject {
    final PolyglotEngineImpl engine;
    final LanguageCache cache;
    Language api;
    LanguageInfo info;
    final int index;
    private final boolean host;
    final RuntimeException initError;
    private OptionDescriptors options;
    private volatile OptionValuesImpl optionValues;
    @CompilerDirectives.CompilationFinal
    private ContextProfile profile;
    volatile PolyglotSourceCache sourceCache;
    private volatile boolean initialized;

    PolyglotLanguage(PolyglotEngineImpl engine, LanguageCache cache, int index, boolean host, RuntimeException initError) {
        super((AbstractPolyglotImpl)engine.impl);
        this.engine = engine;
        this.cache = cache;
        this.initError = initError;
        this.index = index;
        this.host = host;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    boolean dependsOn(PolyglotLanguage otherLanguage) {
        Set<String> dependentLanguages = this.cache.getDependentLanguages();
        if (dependentLanguages.contains(otherLanguage.getId())) {
            return true;
        }
        for (String dependentLanguage : dependentLanguages) {
            PolyglotLanguage dependentLanguageObj = this.engine.idToLanguage.get(dependentLanguage);
            if (dependentLanguageObj == null || !this.dependsOn(dependentLanguageObj)) continue;
            return true;
        }
        return false;
    }

    void initializeMultiContext(PolyglotLanguageContext languageContext) {
        assert (Thread.holdsLock(this.engine));
        if (this.initialized) {
            boolean allowsCaching = VMAccessor.LANGUAGE.initializeMultiContext(this.info);
            if (allowsCaching) {
                this.sourceCache = languageContext != null && languageContext.isInitialized() ? languageContext.sourceCache : new PolyglotSourceCache();
                assert (this.sourceCache != null);
            } else {
                this.sourceCache = null;
            }
        }
    }

    Object getCurrentContext() {
        TruffleLanguage.Env env = PolyglotContextImpl.requireContext().contexts[this.index].env;
        if (env == null) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("The language context is not yet initialized or already disposed. ");
        }
        return VMAccessor.LANGUAGE.getContext(env);
    }

    boolean isHost() {
        return this.host;
    }

    public OptionDescriptors getOptions() {
        this.engine.checkState();
        this.ensureInitialized();
        return this.options;
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureInitialized() {
        if (!this.initialized) {
            PolyglotEngineImpl polyglotEngineImpl = this.engine;
            synchronized (polyglotEngineImpl) {
                if (!this.initialized) {
                    try {
                        this.profile = new ContextProfile(this);
                        LanguageCache.LoadedLanguage loadedLanguage = this.cache.loadLanguage();
                        VMAccessor.LANGUAGE.initializeLanguage(this.info, loadedLanguage.getLanguage(), loadedLanguage.isSingleton());
                        this.options = VMAccessor.LANGUAGE.describeOptions(loadedLanguage.getLanguage(), this.cache.getId());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(String.format("Error initializing language '%s' using class '%s'.", this.cache.getId(), this.cache.getClassName()), e);
                    }
                    this.initialized = true;
                    if (!this.engine.singleContext.isValid()) {
                        this.initializeMultiContext(null);
                    }
                }
            }
        }
    }

    ContextProfile requireProfile() {
        if (this.profile == null) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)"No language context is active on this thread.");
        }
        return this.profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OptionValuesImpl getOptionValues() {
        if (this.optionValues == null) {
            PolyglotEngineImpl polyglotEngineImpl = this.engine;
            synchronized (polyglotEngineImpl) {
                if (this.optionValues == null) {
                    this.optionValues = new OptionValuesImpl(this.engine, this.getOptions());
                }
            }
        }
        return this.optionValues;
    }

    void clearOptionValues() {
        this.optionValues = null;
    }

    <S> S lookup(Class<S> serviceClass) {
        this.ensureInitialized();
        return VMAccessor.LANGUAGE.lookup(this.info, serviceClass);
    }

    public String getName() {
        return this.cache.getName();
    }

    public String getImplementationName() {
        return this.cache.getImplementationName();
    }

    public boolean isInteractive() {
        return this.cache.isInteractive();
    }

    public String getVersion() {
        String version = this.cache.getVersion();
        if (version.equals("inherit")) {
            return this.engine.getVersion();
        }
        return version;
    }

    public String getId() {
        return this.cache.getId();
    }

    public String toString() {
        return "PolyglotLanguage [id=" + this.getId() + ", name=" + this.getName() + ", host=" + this.isHost() + "]";
    }

    static final class ContextProfile {
        private static final Object UNSET_CONTEXT = new Object();
        private final PolyglotLanguage language;
        private final Assumption singleContext = Truffle.getRuntime().createAssumption("Language single context.");
        @CompilerDirectives.CompilationFinal
        private volatile Object cachedSingleContext = UNSET_CONTEXT;

        ContextProfile(PolyglotLanguage language) {
            this.language = language;
        }

        Object get() {
            Object cachedSingle;
            assert (this.assertCorrectEngine());
            if (this.singleContext.isValid() && (cachedSingle = this.cachedSingleContext) != UNSET_CONTEXT) {
                assert (this.assertGet(cachedSingle));
                return cachedSingle;
            }
            return this.lookupLanguageContext(PolyglotContextImpl.requireContext());
        }

        private boolean assertCorrectEngine() {
            PolyglotContextImpl context = PolyglotContextImpl.requireContext();
            if (context.engine != this.language.engine) {
                throw new AssertionError((Object)String.format("Context reference was used from an Engine that is currently not entered. ContextReference of engine %s was used but engine %s is currently entered. ContextReference must not be shared between multiple TruffleLanguage instances.", this.language.engine.creatorApi, context.engine.creatorApi));
            }
            return true;
        }

        private boolean assertGet(Object cachedSingle) {
            PolyglotContextImpl context = PolyglotContextImpl.requireContext();
            if (!this.singleContext.isValid()) {
                return true;
            }
            return cachedSingle == this.lookupLanguageContext(context);
        }

        private Object lookupLanguageContext(PolyglotContextImpl context) {
            TruffleLanguage.Env env = context.contexts[this.language.index].env;
            if (env == null) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException("The language context is not yet initialized or already disposed.");
            }
            return VMAccessor.LANGUAGE.getContext(env);
        }

        void notifyContextCreate(TruffleLanguage.Env env) {
            if (this.singleContext.isValid()) {
                Object cachedSingle = this.cachedSingleContext;
                assert (cachedSingle != VMAccessor.LANGUAGE.getContext(env) || cachedSingle == null) : "Non-null context objects should be distinct";
                if (cachedSingle == UNSET_CONTEXT) {
                    if (this.singleContext.isValid()) {
                        this.cachedSingleContext = VMAccessor.LANGUAGE.getContext(env);
                    }
                } else {
                    this.singleContext.invalidate();
                    this.cachedSingleContext = UNSET_CONTEXT;
                }
            }
        }

        void notifyEngineDisposed() {
            if (this.singleContext.isValid()) {
                this.cachedSingleContext = UNSET_CONTEXT;
            }
        }
    }
}

