/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.vm.PolyglotEngine;
import com.oracle.truffle.api.vm.PolyglotRootNode;
import java.util.HashMap;
import java.util.Map;

final class PolyglotCache {
    private final Map<Object, Cache> cachedTargets = new HashMap<Object, Cache>();
    private final PolyglotEngine engine;

    PolyglotCache(PolyglotEngine engine) {
        this.engine = engine;
    }

    CallTarget lookupAsJava(Class<?> type) {
        Cache cache = this.lookupCache(type);
        if (cache.asJava == null) {
            cache.asJava = PolyglotRootNode.createAsJava(this.engine, type);
        }
        return cache.asJava;
    }

    CallTarget lookupExecute(Class<?> type) {
        Cache cache = this.lookupCache(type);
        if (cache.execute == null) {
            cache.execute = PolyglotRootNode.createExecuteSymbol(this.engine, type);
        }
        return cache.execute;
    }

    CallTarget lookupComputation(Object key, RootNode computation) {
        Cache cache = this.lookupCache(key);
        if (cache.computation == null && computation != null) {
            cache.computation = Truffle.getRuntime().createCallTarget(computation);
        }
        return cache.computation;
    }

    private Cache lookupCache(Object clazzOrMethod) {
        Cache cache = this.cachedTargets.get(clazzOrMethod);
        if (cache == null) {
            cache = new Cache();
            this.cachedTargets.put(clazzOrMethod, cache);
        }
        return cache;
    }

    private static class Cache {
        CallTarget asJava;
        CallTarget execute;
        CallTarget computation;

        private Cache() {
        }
    }
}

