/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.vm.PolyglotContextImpl;
import com.oracle.truffle.api.vm.PolyglotImpl;
import com.oracle.truffle.api.vm.PolyglotLanguageContext;
import java.util.function.Supplier;

final class PolyglotBoundaryRootNode
extends RootNode {
    private static final Object UNINITIALIZED_CONTEXT = new Object();
    private final Supplier<String> name;
    @CompilerDirectives.CompilationFinal
    private boolean seenEnter;
    @CompilerDirectives.CompilationFinal
    private boolean seenNonEnter;
    @CompilerDirectives.CompilationFinal
    private Object constantContext = UNINITIALIZED_CONTEXT;
    @Node.Child
    private ExecutableNode executable;

    protected PolyglotBoundaryRootNode(Supplier<String> name, ExecutableNode executable) {
        super(null);
        this.name = name;
        this.executable = executable;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object prev;
        boolean needsEnter;
        Object[] args = frame.getArguments();
        Object languageContext = this.profileContext(args[0]);
        PolyglotContextImpl context = languageContext != null ? ((PolyglotLanguageContext)languageContext).context : null;
        boolean bl = needsEnter = languageContext != null && context.needsEnter();
        if (needsEnter) {
            if (!this.seenEnter) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenEnter = true;
            }
            prev = context.enter();
        } else {
            if (!this.seenNonEnter) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenNonEnter = true;
            }
            prev = null;
        }
        try {
            Object object = this.executable.execute(frame);
            return object;
        }
        catch (Throwable e) {
            CompilerDirectives.transferToInterpreter();
            throw PolyglotImpl.wrapGuestException((PolyglotLanguageContext)languageContext, e);
        }
        finally {
            if (needsEnter) {
                context.leave(prev);
            }
        }
    }

    private Object profileContext(Object languageContext) {
        if (this.constantContext != null) {
            if (this.constantContext == languageContext) {
                return this.constantContext;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.constantContext = this.constantContext == UNINITIALIZED_CONTEXT ? languageContext : null;
        }
        return languageContext;
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

