/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.vm.DefaultScope;
import com.oracle.truffle.api.vm.PolyglotLanguageContext;
import java.util.Map;
import org.graalvm.polyglot.Value;

final class PolyglotBindings
implements TruffleObject {
    final PolyglotLanguageContext languageContext;
    final Map<String, Value> bindings;

    PolyglotBindings(PolyglotLanguageContext languageContext, Map<String, Value> bindings) {
        this.languageContext = languageContext;
        this.bindings = bindings;
    }

    @Override
    public ForeignAccess getForeignAccess() {
        return PolyglotBindingsFactory.INSTANCE;
    }

    private static final class PolyglotBindingsFactory
    implements ForeignAccess.StandardFactory {
        private static final ForeignAccess INSTANCE = ForeignAccess.create(PolyglotBindings.class, new PolyglotBindingsFactory());

        private PolyglotBindingsFactory() {
        }

        @Override
        public CallTarget accessWrite() {
            return Truffle.getRuntime().createCallTarget(new WriteNode());
        }

        @Override
        public CallTarget accessIsBoxed() {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(Boolean.FALSE));
        }

        @Override
        public CallTarget accessUnbox() {
            return null;
        }

        @Override
        public CallTarget accessRead() {
            return Truffle.getRuntime().createCallTarget(new ReadNode());
        }

        @Override
        public CallTarget accessRemove() {
            return Truffle.getRuntime().createCallTarget(new RemoveNode());
        }

        @Override
        public CallTarget accessIsInstantiable() {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(Boolean.FALSE));
        }

        @Override
        public CallTarget accessNew(int argumentsLength) {
            return null;
        }

        @Override
        public CallTarget accessHasKeys() {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(Boolean.TRUE));
        }

        @Override
        public CallTarget accessKeys() {
            return Truffle.getRuntime().createCallTarget(new KeysNode());
        }

        @Override
        public CallTarget accessKeyInfo() {
            return Truffle.getRuntime().createCallTarget(new KeyInfoNode());
        }

        @Override
        public CallTarget accessIsNull() {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
        }

        @Override
        public CallTarget accessIsExecutable() {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
        }

        @Override
        public CallTarget accessInvoke(int argumentsLength) {
            return null;
        }

        @Override
        public CallTarget accessHasSize() {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
        }

        @Override
        public CallTarget accessGetSize() {
            return null;
        }

        @Override
        public CallTarget accessExecute(int argumentsLength) {
            return null;
        }

        @Override
        public CallTarget accessIsPointer() {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
        }

        @Override
        public CallTarget accessAsPointer() {
            return null;
        }

        @Override
        public CallTarget accessToNative() {
            return null;
        }

        @Override
        public CallTarget accessMessage(Message unknown) {
            return null;
        }

        private static class KeyInfoNode
        extends BaseNode {
            private KeyInfoNode() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object execute(PolyglotLanguageContext context, Map<String, Value> map, Object[] arguments, int offset) throws InteropException {
                String identifier = KeyInfoNode.expectIdentifier(arguments, offset, Message.KEY_INFO);
                if (map.containsKey(identifier)) {
                    return 38;
                }
                return 64;
            }
        }

        private static class KeysNode
        extends BaseNode {
            private KeysNode() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object execute(PolyglotLanguageContext context, Map<String, Value> map, Object[] arguments, int offset) throws InteropException {
                return new DefaultScope.VariableNamesObject(map.keySet());
            }
        }

        private static class RemoveNode
        extends BaseNode {
            private RemoveNode() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object execute(PolyglotLanguageContext context, Map<String, Value> map, Object[] arguments, int offset) throws InteropException {
                String identifier = RemoveNode.expectIdentifier(arguments, offset, Message.REMOVE);
                return map.remove(identifier);
            }
        }

        private static class WriteNode
        extends BaseNode {
            private WriteNode() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object execute(PolyglotLanguageContext context, Map<String, Value> map, Object[] arguments, int offset) throws InteropException {
                String identifier = WriteNode.expectIdentifier(arguments, offset, Message.WRITE);
                Object value = arguments[offset + 1];
                map.put(identifier, context.toHostValue(value));
                return value;
            }
        }

        private static class ReadNode
        extends BaseNode {
            private ReadNode() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object execute(PolyglotLanguageContext context, Map<String, Value> map, Object[] arguments, int offset) throws InteropException {
                String identifier = ReadNode.expectIdentifier(arguments, offset, Message.READ);
                Value value = map.get(identifier);
                if (value == null) {
                    CompilerDirectives.transferToInterpreter();
                    Value legacyValue = context.context.findLegacyExportedSymbol(identifier);
                    if (legacyValue != null) {
                        return context.getAPIAccess().getReceiver(legacyValue);
                    }
                    throw UnknownIdentifierException.raise(identifier);
                }
                return context.toGuestValue(value);
            }
        }

        private static abstract class BaseNode
        extends RootNode {
            protected BaseNode() {
                super(null);
            }

            @Override
            public final Object execute(VirtualFrame frame) {
                Object[] arguments = frame.getArguments();
                PolyglotBindings bindings = (PolyglotBindings)arguments[0];
                try {
                    return this.execute(bindings.languageContext, bindings.bindings, arguments, 1);
                }
                catch (InteropException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw e.raise();
                }
            }

            protected static final String expectIdentifier(Object[] arguments, int offset, Message message) {
                Object key = arguments[offset];
                if (!(key instanceof String)) {
                    CompilerDirectives.transferToInterpreter();
                    throw UnsupportedMessageException.raise(message);
                }
                return (String)key;
            }

            abstract Object execute(PolyglotLanguageContext var1, Map<String, Value> var2, Object[] var3, int var4) throws InteropException;
        }
    }
}

