/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.vm.DefaultScope;
import com.oracle.truffle.api.vm.NullValueForeignFactory;

final class NullValueForeign
implements ForeignAccess.StandardFactory,
ForeignAccess.Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.create(new NullValueForeign(), null);

    @Deprecated
    public static ForeignAccess createAccess() {
        return ForeignAccess.create(new NullValueForeign(), null);
    }

    private NullValueForeign() {
    }

    @Override
    public boolean canHandle(TruffleObject obj) {
        return DefaultScope.NullValue.isInstance(obj);
    }

    @Override
    public CallTarget accessIsNull() {
        return Truffle.getRuntime().createCallTarget(IsNullSubNode.createRoot());
    }

    @Override
    public CallTarget accessIsExecutable() {
        return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }

    @Override
    public CallTarget accessIsInstantiable() {
        return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }

    @Override
    public CallTarget accessIsBoxed() {
        return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }

    @Override
    public CallTarget accessHasKeys() {
        return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }

    @Override
    public CallTarget accessHasSize() {
        return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }

    @Override
    public CallTarget accessGetSize() {
        return null;
    }

    @Override
    public CallTarget accessUnbox() {
        return null;
    }

    @Override
    public CallTarget accessRead() {
        return null;
    }

    @Override
    public CallTarget accessWrite() {
        return null;
    }

    @Override
    public CallTarget accessRemove() {
        return null;
    }

    @Override
    public CallTarget accessExecute(int argumentsLength) {
        return null;
    }

    @Override
    public CallTarget accessInvoke(int argumentsLength) {
        return null;
    }

    @Override
    public CallTarget accessNew(int argumentsLength) {
        return null;
    }

    @Override
    public CallTarget accessKeyInfo() {
        return null;
    }

    @Override
    public CallTarget accessKeys() {
        return null;
    }

    @Override
    public CallTarget accessIsPointer() {
        return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }

    @Override
    public CallTarget accessAsPointer() {
        return null;
    }

    @Override
    public CallTarget accessToNative() {
        return null;
    }

    @Override
    public CallTarget accessMessage(Message unknown) {
        return null;
    }

    static abstract class IsNullSubNode
    extends DefaultScope.NullValue.IsNull {
        IsNullSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2);

        @Specialization
        protected Object accessWithTarget(DefaultScope.NullValue receiver) {
            return this.access(receiver);
        }

        public static RootNode createRoot() {
            return new IS_NULLRootNode();
        }

        private static final class IS_NULLRootNode
        extends RootNode {
            @Node.Child
            private IsNullSubNode node = NullValueForeignFactory.IsNullSubNodeGen.create();

            protected IS_NULLRootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::IS_NULL::com.oracle.truffle.api.vm.DefaultScope.NullValue";
            }

            @Override
            public Object execute(VirtualFrame frame) {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                try {
                    return this.node.executeWithTarget(frame, receiver);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsNullSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }
}

