/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.vm.ModuleResourceLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

final class InstrumentCache {
    private static final boolean JDK8OrEarlier = System.getProperty("java.specification.version").compareTo("1.9") < 0;
    private static final List<InstrumentCache> nativeImageCache = TruffleOptions.AOT ? new ArrayList() : null;
    private static List<InstrumentCache> runtimeCache;
    private Class<? extends TruffleInstrument> instrumentClass;
    private final String className;
    private final String id;
    private final String name;
    private final String version;
    private final boolean internal;
    private final ClassLoader loader;
    private final Set<String> services;

    private static void initializeNativeImageState(ClassLoader imageClassLoader) {
        nativeImageCache.addAll(InstrumentCache.doLoad(Collections.singletonList(imageClassLoader)));
    }

    private static void resetNativeImageState() {
        nativeImageCache.clear();
        runtimeCache = null;
    }

    private InstrumentCache(String prefix, Properties info, ClassLoader loader) {
        String nth;
        String serviceName;
        this.loader = loader;
        this.className = info.getProperty(prefix + "className");
        this.name = info.getProperty(prefix + "name");
        this.version = info.getProperty(prefix + "version");
        this.internal = Boolean.valueOf(info.getProperty(prefix + "internal"));
        String loadedId = info.getProperty(prefix + "id");
        if (loadedId.equals("")) {
            int lastIndex = this.className.lastIndexOf(36);
            if (lastIndex == -1) {
                lastIndex = this.className.lastIndexOf(46);
            }
            this.id = this.className.substring(lastIndex + 1, this.className.length());
        } else {
            this.id = loadedId;
        }
        int servicesCounter = 0;
        this.services = new TreeSet<String>();
        while ((serviceName = info.getProperty(nth = prefix + "service" + servicesCounter++)) != null) {
            this.services.add(serviceName);
        }
        if (TruffleOptions.AOT) {
            this.loadClass();
        }
    }

    public boolean isInternal() {
        return this.internal;
    }

    static List<InstrumentCache> load(Collection<ClassLoader> loaders) {
        if (TruffleOptions.AOT) {
            return nativeImageCache;
        }
        if (runtimeCache != null) {
            return runtimeCache;
        }
        return InstrumentCache.doLoad(loaders);
    }

    private static List<InstrumentCache> doLoad(Collection<ClassLoader> loaders) {
        ArrayList<InstrumentCache> list = new ArrayList<InstrumentCache>();
        HashSet<String> classNamesUsed = new HashSet<String>();
        for (ClassLoader loader : loaders) {
            InstrumentCache.loadForOne(loader, list, classNamesUsed);
        }
        if (!JDK8OrEarlier) {
            InstrumentCache.loadForOne(ModuleResourceLocator.createLoader(), list, classNamesUsed);
        }
        runtimeCache = list;
        return runtimeCache;
    }

    private static void loadForOne(ClassLoader loader, List<InstrumentCache> list, Set<String> classNamesUsed) {
        Enumeration<URL> en;
        if (loader == null) {
            return;
        }
        try {
            en = loader.getResources("META-INF/truffle/instrument");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot read list of Truffle instruments", ex);
        }
        while (en.hasMoreElements()) {
            String prefix;
            String className;
            Properties p;
            URL u = en.nextElement();
            try {
                p = new Properties();
                try (InputStream is = u.openStream();){
                    p.load(is);
                }
            }
            catch (IOException ex) {
                PrintStream out = System.err;
                out.println("Cannot process " + u + " as language definition");
                ex.printStackTrace();
                continue;
            }
            int cnt = 1;
            while ((className = p.getProperty((prefix = "instrument" + cnt + ".") + "className")) != null) {
                if (!classNamesUsed.contains(className)) {
                    classNamesUsed.add(className);
                    list.add(new InstrumentCache(prefix, p, loader));
                }
                ++cnt;
            }
        }
        Collections.sort(list, new Comparator<InstrumentCache>(){

            @Override
            public int compare(InstrumentCache o1, InstrumentCache o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
    }

    String getId() {
        return this.id;
    }

    String getName() {
        return this.name;
    }

    String getClassName() {
        return this.className;
    }

    String getVersion() {
        return this.version;
    }

    Class<?> getInstrumentationClass() {
        if (!TruffleOptions.AOT && this.instrumentClass == null) {
            this.loadClass();
        }
        return this.instrumentClass;
    }

    boolean supportsService(Class<?> clazz) {
        return this.services.contains(clazz.getName()) || this.services.contains(clazz.getCanonicalName());
    }

    String[] services() {
        return this.services.toArray(new String[0]);
    }

    private void loadClass() {
        try {
            this.instrumentClass = Class.forName(this.className, true, this.loader).asSubclass(TruffleInstrument.class);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot initialize " + this.getName() + " instrument with implementation " + this.className, ex);
        }
    }
}

