/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.vm.ComputeInExecutor;
import com.oracle.truffle.api.vm.ConvertedObject;
import com.oracle.truffle.api.vm.PolyglotEngine;
import com.oracle.truffle.api.vm.PolyglotRootNode;
import java.util.Objects;

final class EngineTruffleObject
implements TruffleObject,
ForeignAccess.Factory {
    private final PolyglotEngine engine;
    private final TruffleObject delegate;

    private EngineTruffleObject(PolyglotEngine engine, TruffleObject obj) {
        this.engine = engine;
        this.delegate = obj;
    }

    static Object wrap(PolyglotEngine engine, Object value) {
        Object obj = ConvertedObject.value(value);
        if (obj instanceof TruffleObject) {
            return new EngineTruffleObject(engine, (TruffleObject)obj);
        }
        return obj;
    }

    @Override
    public ForeignAccess getForeignAccess() {
        return ForeignAccess.create(this);
    }

    TruffleObject getDelegate() {
        return this.delegate;
    }

    PolyglotEngine engine() {
        return this.engine;
    }

    void assertEngine(PolyglotEngine other) {
        if (this.engine != other) {
            this.throwEngine(other);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void throwEngine(PolyglotEngine other) throws IllegalArgumentException {
        throw new IllegalArgumentException("This object comes from " + this.engine + " and cannot be sent to " + other);
    }

    @Override
    public boolean canHandle(TruffleObject obj) {
        return obj instanceof EngineTruffleObject;
    }

    @Override
    public CallTarget accessMessage(Message message) {
        return Truffle.getRuntime().createCallTarget(new WrappingRoot(this.engine, message));
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.engine);
        hash = 89 * hash + Objects.hashCode(this.delegate);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EngineTruffleObject) {
            EngineTruffleObject other = (EngineTruffleObject)obj;
            return this.engine == other.engine && Objects.equals(this.delegate, other.delegate);
        }
        return false;
    }

    public String toString() {
        return this.delegate.toString();
    }

    static class WrappingRoot
    extends RootNode {
        private final PolyglotEngine engine;
        @Node.Child
        private DirectCallNode messageCallNode;

        WrappingRoot(PolyglotEngine engine, Message foreignMessage) {
            super(null);
            this.engine = engine;
            this.messageCallNode = DirectCallNode.create(PolyglotRootNode.createSend(engine, foreignMessage));
        }

        @Override
        public Object execute(VirtualFrame frame) {
            EngineTruffleObject engineTruffleObject = (EngineTruffleObject)ForeignAccess.getReceiver(frame);
            Object[] oldArguments = frame.getArguments();
            Object[] arguments = new Object[oldArguments.length];
            TruffleObject delegate = engineTruffleObject.getDelegate();
            arguments[0] = delegate;
            System.arraycopy(oldArguments, 1, arguments, 1, oldArguments.length - 1);
            Object res = this.engine.executor() == null ? this.messageCallNode.call(arguments) : this.invokeOnExecutor(arguments);
            return EngineTruffleObject.wrap(this.engine, res);
        }

        @CompilerDirectives.TruffleBoundary
        private Object invokeOnExecutor(final Object[] arguments) {
            ComputeInExecutor<Object> compute = new ComputeInExecutor<Object>(this.engine.executor()){

                @Override
                protected Object compute() {
                    return messageCallNode.call(arguments);
                }
            };
            compute.perform();
            return compute.get();
        }
    }
}

