/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.source.CharSequenceReader;
import com.oracle.truffle.api.source.CharSequenceWrapper;
import com.oracle.truffle.api.source.InternedSources;
import com.oracle.truffle.api.source.MissingMIMETypeException;
import com.oracle.truffle.api.source.MissingNameException;
import com.oracle.truffle.api.source.SourceAccessor;
import com.oracle.truffle.api.source.SourceImpl;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.source.SubSourceImpl;
import com.oracle.truffle.api.source.TextMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileTypeDetector;
import java.util.Collection;
import java.util.Objects;
import java.util.ServiceLoader;

public abstract class Source {
    private static final Source EMPTY = new SourceImpl.Key(null, null, null, null, null, null, null, false, false, false).toSource();
    private static final String NO_FASTPATH_SUBSOURCE_CREATION_MESSAGE = "do not create sub sources from compiled code";
    private static final String URI_SCHEME = "truffle";
    private static final InternedSources SOURCES = new InternedSources();
    private volatile TextMap textMap;
    private volatile URI computedURI;
    private static final int[] S = new int[]{41, 46, 67, 201, 162, 216, 124, 1, 61, 54, 84, 161, 236, 240, 6, 19, 98, 167, 5, 243, 192, 199, 115, 140, 152, 147, 43, 217, 188, 76, 130, 202, 30, 155, 87, 60, 253, 212, 224, 22, 103, 66, 111, 24, 138, 23, 229, 18, 190, 78, 196, 214, 218, 158, 222, 73, 160, 251, 245, 142, 187, 47, 238, 122, 169, 104, 121, 145, 21, 178, 7, 63, 148, 194, 16, 137, 11, 34, 95, 33, 128, 127, 93, 154, 90, 144, 50, 39, 53, 62, 204, 231, 191, 247, 151, 3, 255, 25, 48, 179, 72, 165, 181, 209, 215, 94, 146, 42, 172, 86, 170, 198, 79, 184, 56, 210, 150, 164, 125, 182, 118, 252, 107, 226, 156, 116, 4, 241, 69, 157, 112, 89, 100, 113, 135, 32, 134, 91, 207, 101, 230, 45, 168, 2, 27, 96, 37, 173, 174, 176, 185, 246, 28, 70, 97, 105, 52, 64, 126, 15, 85, 71, 163, 35, 221, 81, 175, 58, 195, 92, 249, 206, 186, 197, 234, 38, 44, 83, 13, 110, 133, 40, 132, 9, 211, 223, 205, 244, 65, 129, 77, 82, 106, 220, 55, 200, 108, 193, 171, 250, 36, 225, 123, 8, 12, 189, 177, 74, 120, 136, 149, 139, 227, 99, 232, 109, 233, 203, 213, 254, 59, 0, 29, 57, 242, 239, 183, 14, 102, 88, 208, 228, 166, 119, 114, 248, 235, 117, 75, 10, 49, 68, 80, 180, 143, 237, 31, 26, 219, 153, 141, 51, 159, 17, 131, 20};

    abstract Object getSourceId();

    Source() {
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Source)) {
            return false;
        }
        return this.getSourceId().equals(((Source)obj).getSourceId());
    }

    public final int hashCode() {
        return this.getSourceId().hashCode();
    }

    public static Builder<IOException, RuntimeException, RuntimeException> newBuilder(File file) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder<IOException, RuntimeException, RuntimeException>(file);
    }

    public static Builder<RuntimeException, MissingMIMETypeException, MissingNameException> newBuilder(String text) {
        return Source.newBuilder((CharSequence)text);
    }

    public static Builder<RuntimeException, MissingMIMETypeException, MissingNameException> newBuilder(CharSequence characters) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder<RuntimeException, MissingMIMETypeException, MissingNameException>(characters);
    }

    public Source subSource(int baseCharIndex, int length) {
        CompilerAsserts.neverPartOfCompilation(NO_FASTPATH_SUBSOURCE_CREATION_MESSAGE);
        return SubSourceImpl.create(this, baseCharIndex, length);
    }

    public static Builder<IOException, RuntimeException, RuntimeException> newBuilder(URL url) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder<IOException, RuntimeException, RuntimeException>(url);
    }

    public static Builder<IOException, MissingMIMETypeException, MissingNameException> newBuilder(Reader reader) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder<IOException, MissingMIMETypeException, MissingNameException>(reader);
    }

    static String read(File file) throws IOException {
        byte[] content = SourceAccessor.isTruffleFile(file) ? SourceAccessor.readTruffleFile(file) : Files.readAllBytes(file.toPath());
        return new String(content, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String read(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[1024];
        try {
            int n;
            while ((n = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, n);
            }
        }
        finally {
            reader.close();
        }
        return builder.toString();
    }

    abstract Source copy();

    public abstract CharSequence getCharacters();

    public abstract String getName();

    public abstract String getPath();

    public abstract boolean isInternal();

    public abstract boolean isCached();

    public abstract boolean isInteractive();

    public abstract URL getURL();

    abstract URI getOriginalURI();

    public final URI getURI() {
        URI uri = this.getOriginalURI();
        if (uri == null && (uri = this.computedURI) == null) {
            uri = this.computedURI = this.getNamedURI(this.getName(), this.getCharacters().toString().getBytes());
        }
        return uri;
    }

    public abstract String getMimeType();

    public abstract String getLanguage();

    public final Reader getReader() {
        return new CharSequenceReader(this.getCharacters());
    }

    public final InputStream getInputStream() {
        return new ByteArrayInputStream(this.getCharacters().toString().getBytes());
    }

    public final int getLength() {
        return this.getTextMap().length();
    }

    public final CharSequence getCharacters(int lineNumber) {
        int offset = this.getTextMap().lineStartOffset(lineNumber);
        int length = this.getTextMap().lineLength(lineNumber);
        return this.getCharacters().subSequence(offset, offset + length);
    }

    public final int getLineCount() {
        return this.getTextMap().lineCount();
    }

    public final int getLineNumber(int offset) throws IllegalArgumentException {
        return this.getTextMap().offsetToLine(offset);
    }

    public final int getColumnNumber(int offset) throws IllegalArgumentException {
        return this.getTextMap().offsetToCol(offset);
    }

    public final int getLineStartOffset(int lineNumber) throws IllegalArgumentException {
        return this.getTextMap().lineStartOffset(lineNumber);
    }

    public final int getLineLength(int lineNumber) throws IllegalArgumentException {
        return this.getTextMap().lineLength(lineNumber);
    }

    public final SourceSection createUnavailableSection() {
        return new SourceSection(this, 0, -1);
    }

    public final SourceSection createSection(int lineNumber) {
        if (lineNumber < 1) {
            throw new IllegalArgumentException("lineNumber < 1");
        }
        int charIndex = this.getTextMap().lineStartOffset(lineNumber);
        int length = this.getTextMap().lineLength(lineNumber);
        SourceSection section = new SourceSection(this, charIndex, length);
        assert (Source.assertValid(section));
        return section;
    }

    public final SourceSection createSection(int charIndex, int length) {
        if (charIndex < 0) {
            throw new IllegalArgumentException("charIndex < 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        SourceSection section = new SourceSection(this, charIndex, length);
        assert (Source.assertValid(section));
        return section;
    }

    public final SourceSection createSection(int startLine, int startColumn, int length) {
        if (startLine <= 0) {
            throw new IllegalArgumentException("startLine < 1");
        }
        if (startColumn <= 0) {
            throw new IllegalArgumentException("startColumn < 1");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        int lineStartOffset = this.getTextMap().lineStartOffset(startLine);
        if (startColumn > this.getTextMap().lineLength(startLine)) {
            throw new IllegalArgumentException("column out of range");
        }
        int charIndex = lineStartOffset + startColumn - 1;
        if (charIndex + length > this.getCharacters().length()) {
            throw new IllegalArgumentException("charIndex out of range");
        }
        SourceSection section = new SourceSection(this, charIndex, length);
        assert (Source.assertValid(section));
        return section;
    }

    private static boolean assertValid(SourceSection section) {
        if (!section.isValid()) {
            throw new IllegalArgumentException("Invalid source section bounds.");
        }
        return true;
    }

    final TextMap getTextMap() {
        TextMap res = this.textMap;
        if (res == null) {
            res = this.textMap = this.createTextMap();
        }
        assert (res != null);
        return res;
    }

    TextMap createTextMap() {
        CharSequence code = this.getCharacters();
        if (code == null) {
            throw new RuntimeException("can't read file " + this.getName());
        }
        return TextMap.fromCharSequence(code);
    }

    static <E extends Exception> E raise(Class<E> type, Exception ex) throws E {
        throw ex;
    }

    static CharSequence enforceCharSequenceContract(CharSequence sequence) {
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertions) {
            if (sequence instanceof String) {
                return sequence;
            }
            if (sequence instanceof CharSequenceWrapper) {
                return sequence;
            }
            return new CharSequenceWrapper(sequence);
        }
        return sequence;
    }

    static String findMimeType(Path filePath) throws IOException {
        String found;
        if (!TruffleOptions.AOT) {
            Collection<ClassLoader> loaders = SourceAccessor.allLoaders();
            for (ClassLoader l : loaders) {
                for (FileTypeDetector detector : ServiceLoader.load(FileTypeDetector.class, l)) {
                    String mimeType = detector.probeContentType(filePath);
                    if (mimeType == null) continue;
                    return mimeType;
                }
            }
        }
        return (found = Files.probeContentType(filePath)) == null ? "content/unknown" : found;
    }

    static String findMimeType(URL url) throws IOException {
        try {
            Path path = Paths.get(url.toURI());
            String firstGuess = Source.findMimeType(path);
            if (firstGuess != null) {
                return firstGuess;
            }
        }
        catch (IllegalArgumentException | URISyntaxException | FileSystemNotFoundException exception) {
            // empty catch block
        }
        return url.openConnection().getContentType();
    }

    private URI getNamedURI(String name, byte[] bytes) {
        return this.getNamedURI(name, bytes, 0, bytes.length);
    }

    private URI getNamedURI(String name, byte[] bytes, int byteIndex, int length) {
        String digest = bytes != null ? Source.digest(bytes, byteIndex, length) : Integer.toString(System.identityHashCode(this), 16);
        if (name != null) {
            digest = digest + '/' + name;
        }
        try {
            return new URI(URI_SCHEME, digest, null);
        }
        catch (URISyntaxException ex) {
            throw new Error(ex);
        }
    }

    static String digest(byte[] message, int from, int length) {
        int[] m = new int[19];
        int[] x = new int[48];
        int[] c = new int[16];
        int loop = 1;
        int start = 0;
        int bytes = 0;
        for (int i = 0; i < 16; ++i) {
            c[i] = 0;
            x[i] = 0;
        }
        int last = 0;
        int index = from;
        m[18] = 0;
        m[17] = 0;
        m[16] = 0;
        while (loop == 1) {
            int t;
            int i;
            m[0] = m[16];
            m[1] = m[17];
            m[2] = m[18];
            for (i = 3; i < 16; ++i) {
                m[i] = 0;
            }
            i = start;
            while (index < length && i < 16) {
                int code = message[index];
                if (code < 0) {
                    code += 256;
                }
                m[i++] = code;
                ++index;
            }
            bytes += i - start;
            start = i - 16;
            if (index == length && i < 16) {
                loop = 2;
                t = 16 - (bytes & 0xF);
                while (i < 16) {
                    m[i] = t;
                    ++i;
                }
            }
            for (i = 0; i < 16; ++i) {
                int n = i;
                c[n] = c[n] ^ S[m[i] ^ last];
                last = c[i];
            }
            for (i = 0; i < loop; ++i) {
                int[] mOrC = i == 0 ? m : c;
                x[16] = mOrC[0];
                x[32] = x[16] ^ x[0];
                x[17] = mOrC[1];
                x[33] = x[17] ^ x[1];
                x[18] = mOrC[2];
                x[34] = x[18] ^ x[2];
                x[19] = mOrC[3];
                x[35] = x[19] ^ x[3];
                x[20] = mOrC[4];
                x[36] = x[20] ^ x[4];
                x[21] = mOrC[5];
                x[37] = x[21] ^ x[5];
                x[22] = mOrC[6];
                x[38] = x[22] ^ x[6];
                x[23] = mOrC[7];
                x[39] = x[23] ^ x[7];
                x[24] = mOrC[8];
                x[40] = x[24] ^ x[8];
                x[25] = mOrC[9];
                x[41] = x[25] ^ x[9];
                x[26] = mOrC[10];
                x[42] = x[26] ^ x[10];
                x[27] = mOrC[11];
                x[43] = x[27] ^ x[11];
                x[28] = mOrC[12];
                x[44] = x[28] ^ x[12];
                x[29] = mOrC[13];
                x[45] = x[29] ^ x[13];
                x[30] = mOrC[14];
                x[46] = x[30] ^ x[14];
                x[31] = mOrC[15];
                x[47] = x[31] ^ x[15];
                t = 0;
                for (int j = 0; j < 18; ++j) {
                    for (int k = 0; k < 48; ++k) {
                        x[k] = t = x[k] ^ S[t];
                    }
                    t = t + j & 0xFF;
                }
            }
        }
        StringBuilder result = new StringBuilder(32);
        for (int i = 0; i < 16; ++i) {
            String hex = Integer.toHexString(x[i]);
            if (result.length() == 0) {
                if (hex.equals("0")) {
                    continue;
                }
            } else if (hex.length() == 1) {
                result.append("0");
            }
            result.append(hex);
        }
        return result.toString();
    }

    static {
        SourceAccessor.allLoaders();
    }

    public final class Builder<E1 extends Exception, E2 extends Exception, E3 extends Exception> {
        private final Object origin;
        private URI uri;
        private String name;
        private String mime;
        private String language;
        private CharSequence content;
        private boolean internal;
        private boolean interactive;
        private boolean cached = true;

        private Builder(Object origin) {
            this.origin = origin;
        }

        public Builder<E1, E2, RuntimeException> name(String newName) {
            Objects.requireNonNull(newName);
            this.name = newName;
            return this;
        }

        public Builder<E1, RuntimeException, E3> mimeType(String newMimeType) {
            Objects.requireNonNull(newMimeType);
            this.mime = newMimeType;
            return this;
        }

        public Builder<E1, E2, E3> cached(boolean cached) {
            this.cached = cached;
            return this;
        }

        public Builder<E1, RuntimeException, E3> language(String newLanguage) {
            Objects.requireNonNull(newLanguage);
            if (this.mime == null) {
                this.mime = "x-unknown";
            }
            this.language = newLanguage;
            return this;
        }

        public Builder<E1, E2, E3> internal() {
            this.internal = true;
            return this;
        }

        public Builder<E1, E2, E3> interactive() {
            this.interactive = true;
            return this;
        }

        public Builder<E1, E2, E3> uri(URI ownUri) {
            Objects.requireNonNull(ownUri);
            this.uri = ownUri;
            return this;
        }

        public Builder<RuntimeException, E2, E3> content(String code) {
            this.content = code;
            return this;
        }

        public Builder<RuntimeException, E2, E3> content(CharSequence characters) {
            this.content = characters;
            return this;
        }

        public Source build() throws E1, E2, E3 {
            try {
                String useName = this.name;
                CharSequence useContent = this.content;
                String usePath = null;
                URI useUri = this.uri;
                URL useUrl = null;
                String useMimeType = this.mime;
                if (this.origin instanceof File) {
                    File file = (File)this.origin;
                    File absoluteFile = file.getCanonicalFile();
                    useName = useName == null ? file.getName() : useName;
                    useContent = useContent == null ? Source.read(file) : useContent;
                    usePath = usePath == null ? absoluteFile.getPath() : usePath;
                    useUri = useUri == null ? absoluteFile.toURI() : useUri;
                    useMimeType = useMimeType == null ? Source.findMimeType(absoluteFile.toPath()) : useMimeType;
                } else if (this.origin instanceof Reader) {
                    Reader r = (Reader)this.origin;
                    useContent = useContent == null ? Source.read(r) : useContent;
                } else if (this.origin instanceof URL) {
                    URL url = (URL)this.origin;
                    String urlPath = url.getPath();
                    int lastIndex = urlPath.lastIndexOf(47);
                    useName = useName == null && lastIndex != -1 ? url.getPath().substring(lastIndex + 1) : useName;
                    useContent = useContent == null ? Source.read(new InputStreamReader(url.openStream())) : useContent;
                    String string = usePath = usePath == null ? url.toExternalForm() : usePath;
                    if (useUri == null) {
                        try {
                            useUri = url.toURI();
                        }
                        catch (URISyntaxException ex) {
                            throw new IOException("Bad URL: " + url, ex);
                        }
                    }
                    useUrl = url;
                    useMimeType = useMimeType == null ? Source.findMimeType(url) : useMimeType;
                } else {
                    assert (this.origin instanceof CharSequence);
                    useContent = useContent == null ? (CharSequence)this.origin : useContent;
                }
                this.content = useContent = Source.enforceCharSequenceContract(useContent);
                if (useMimeType == null) {
                    throw Source.raise(RuntimeException.class, new MissingMIMETypeException());
                }
                if (useName == null) {
                    throw Source.raise(RuntimeException.class, new MissingNameException());
                }
                SourceImpl.Key key = new SourceImpl.Key(useContent, useMimeType, this.language, useUrl, useUri, useName, usePath, this.internal, this.interactive, this.cached);
                return SOURCES.intern(key);
            }
            catch (IOException ex) {
                throw Source.raise(RuntimeException.class, ex);
            }
        }
    }
}

