/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ReplaceObserver;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.NodeInterface;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Node
implements NodeInterface,
Cloneable {
    @CompilerDirectives.CompilationFinal
    private volatile Node parent;
    private static final Object GIL = new Object();
    private static final ReentrantLock GIL_LOCK = new ReentrantLock(false);
    static final AccessorNodes ACCESSOR = new AccessorNodes();

    protected Node() {
        CompilerAsserts.neverPartOfCompilation("do not create a Node from compiled code");
        assert (NodeClass.get(this.getClass()) != null);
        if (TruffleOptions.TraceASTJSON) {
            Node.dump(this, null, null);
        }
    }

    NodeClass getNodeClass() {
        return NodeClass.get(this.getClass());
    }

    void setParent(Node parent) {
        this.parent = parent;
    }

    public NodeCost getCost() {
        NodeInfo info = this.getClass().getAnnotation(NodeInfo.class);
        if (info != null) {
            return info.cost();
        }
        return NodeCost.MONOMORPHIC;
    }

    public SourceSection getSourceSection() {
        return null;
    }

    @ExplodeLoop
    public SourceSection getEncapsulatingSourceSection() {
        Node current = this;
        while (current != null) {
            SourceSection currentSection = current.getSourceSection();
            if (currentSection != null) {
                return currentSection;
            }
            current = current.parent;
        }
        return null;
    }

    protected final <T extends Node> T[] insert(T[] newChildren) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (newChildren != null) {
            for (T newChild : newChildren) {
                this.adoptHelper((Node)newChild);
            }
        }
        return newChildren;
    }

    protected final <T extends Node> T insert(T newChild) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (newChild != null) {
            this.adoptHelper(newChild);
        }
        return newChild;
    }

    protected final void notifyInserted(Node node) {
        RootNode rootNode = node.getRootNode();
        if (rootNode == null) {
            throw new IllegalStateException("Node is not yet adopted and cannot be updated.");
        }
        Accessor.InstrumentSupport support = ACCESSOR.instrumentSupport();
        if (support != null) {
            support.onNodeInserted(rootNode, node);
        }
    }

    public final void adoptChildren() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        NodeUtil.adoptChildrenHelper(this);
    }

    final void adoptHelper(Node newChild) {
        assert (newChild != null);
        if (newChild == this) {
            throw new IllegalStateException("The parent of a node can never be the node itself.");
        }
        assert (this.checkSameLanguages(newChild));
        newChild.parent = this;
        if (TruffleOptions.TraceASTJSON) {
            Node.dump(this, newChild, null);
        }
        NodeUtil.adoptChildrenHelper(newChild);
    }

    int adoptChildrenAndCount() {
        CompilerAsserts.neverPartOfCompilation();
        return 1 + NodeUtil.adoptChildrenAndCountHelper(this);
    }

    int adoptAndCountHelper(Node newChild) {
        assert (newChild != null);
        if (newChild == this) {
            throw new IllegalStateException("The parent of a node can never be the node itself.");
        }
        assert (this.checkSameLanguages(newChild));
        newChild.parent = this;
        if (TruffleOptions.TraceASTJSON) {
            Node.dump(this, newChild, null);
        }
        return 1 + NodeUtil.adoptChildrenAndCountHelper(newChild);
    }

    private boolean checkSameLanguages(Node newChild) {
        if (newChild instanceof ExecutableNode && !(newChild instanceof RootNode)) {
            RootNode root = this.getRootNode();
            if (root == null) {
                throw new IllegalStateException("Cannot adopt ExecutableNode " + newChild + " as a child of node without a root.");
            }
            LanguageInfo pl = root.getLanguageInfo();
            LanguageInfo cl = ((ExecutableNode)newChild).getLanguageInfo();
            if (cl != pl) {
                throw new IllegalArgumentException("Can not adopt ExecutableNode under a different language. Parent " + this + " is of " + Node.langId(pl) + ", child " + newChild + " is of " + Node.langId(cl));
            }
        }
        return true;
    }

    private static String langId(LanguageInfo languageInfo) {
        if (languageInfo == null) {
            return null;
        }
        return languageInfo.getId();
    }

    private void adoptUnadoptedHelper(final Node newChild) {
        assert (newChild != null);
        if (newChild == this) {
            throw new IllegalStateException("The parent of a node can never be the node itself.");
        }
        newChild.parent = this;
        NodeUtil.forEachChild(newChild, new NodeVisitor(){

            @Override
            public boolean visit(Node child) {
                if (child != null && child.getParent() == null) {
                    newChild.adoptUnadoptedHelper(child);
                }
                return true;
            }
        });
    }

    public Map<String, Object> getDebugProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        return properties;
    }

    public final Node getParent() {
        return this.parent;
    }

    public final <T extends Node> T replace(final T newNode, final CharSequence reason) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.atomic(new Runnable(){

            @Override
            public void run() {
                Node.this.replaceHelper(newNode, reason);
            }
        });
        return newNode;
    }

    public final <T extends Node> T replace(T newNode) {
        return this.replace(newNode, "");
    }

    final void replaceHelper(Node newNode, CharSequence reason) {
        CompilerAsserts.neverPartOfCompilation("do not call Node.replaceHelper from compiled code");
        assert (this.inAtomicBlock());
        if (this.getParent() == null) {
            throw new IllegalStateException("This node cannot be replaced, because it does not yet have a parent.");
        }
        newNode.parent = this.parent;
        if (!NodeUtil.replaceChild(this.parent, this, newNode, true)) {
            this.parent.adoptUnadoptedHelper(newNode);
        }
        this.reportReplace(this, newNode, reason);
        this.onReplace(newNode, reason);
    }

    public final boolean isSafelyReplaceableBy(Node newNode) {
        return NodeUtil.isReplacementSafe(this.getParent(), this, newNode);
    }

    private void reportReplace(Node oldNode, Node newNode, CharSequence reason) {
        for (Node node = this; node != null; node = node.getParent()) {
            RootCallTarget target;
            boolean consumed = false;
            if (node instanceof ReplaceObserver) {
                consumed = ((ReplaceObserver)((Object)node)).nodeReplaced(oldNode, newNode, reason);
            } else if (node instanceof RootNode && (target = ((RootNode)node).getCallTarget()) instanceof ReplaceObserver) {
                consumed = ((ReplaceObserver)((Object)target)).nodeReplaced(oldNode, newNode, reason);
            }
            if (consumed) break;
        }
        if (TruffleOptions.TraceRewrites) {
            NodeUtil.traceRewrite(this, newNode, reason);
        }
        if (TruffleOptions.TraceASTJSON) {
            Node.dump(this, newNode, reason);
        }
    }

    private static void dump(Node node, Node newChild, CharSequence reason) {
        Accessor.DumpSupport dumpSupport;
        if (ACCESSOR != null && (dumpSupport = ACCESSOR.dumpSupport()) != null) {
            dumpSupport.dump(node, newChild, reason);
        }
    }

    protected void onReplace(Node newNode, CharSequence reason) {
    }

    public final void accept(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            NodeUtil.forEachChildRecursive(this, nodeVisitor);
        }
    }

    public final Iterable<Node> getChildren() {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return Node.this.getNodeClass().makeIterator(Node.this);
            }
        };
    }

    public Node copy() {
        CompilerAsserts.neverPartOfCompilation("do not call Node.copy from compiled code");
        try {
            return (Node)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Node deepCopy() {
        return NodeUtil.deepCopyImpl(this);
    }

    public final RootNode getRootNode() {
        Node rootNode = this;
        while (rootNode.getParent() != null) {
            assert (!(rootNode instanceof RootNode)) : "root node must not have a parent";
            rootNode = rootNode.getParent();
        }
        if (rootNode instanceof RootNode) {
            return (RootNode)rootNode;
        }
        return null;
    }

    protected final void reportPolymorphicSpecialize() {
        CompilerAsserts.neverPartOfCompilation();
        ACCESSOR.nodes().reportPolymorphicSpecialize(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        Map<String, Object> properties = this.getDebugProperties();
        boolean hasProperties = false;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            sb.append(hasProperties ? "," : "<");
            hasProperties = true;
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (hasProperties) {
            sb.append(">");
        }
        sb.append("@").append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }

    public final void atomic(Runnable closure) {
        Lock lock = this.getLock();
        try {
            lock.lock();
            closure.run();
        }
        finally {
            lock.unlock();
        }
    }

    public final <T> T atomic(Callable<T> closure) {
        Lock lock = this.getLock();
        try {
            lock.lock();
            T t = closure.call();
            return t;
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    @Deprecated
    protected final Object getAtomicLock() {
        RootNode root = this.getRootNode();
        return root == null ? GIL : root;
    }

    protected final Lock getLock() {
        RootNode root = this.getRootNode();
        return root == null ? GIL_LOCK : root.lock;
    }

    @Deprecated
    protected boolean isTaggedWith(Class<?> tag) {
        return false;
    }

    public String getDescription() {
        NodeInfo info = this.getClass().getAnnotation(NodeInfo.class);
        if (info != null) {
            return info.description();
        }
        return "";
    }

    @Deprecated
    public String getLanguage() {
        NodeInfo info = this.getClass().getAnnotation(NodeInfo.class);
        if (info != null && info.language() != null && info.language().length() > 0) {
            return info.language();
        }
        if (this.parent != null) {
            return this.parent.getLanguage();
        }
        return "";
    }

    private boolean inAtomicBlock() {
        return ((ReentrantLock)this.getLock()).isHeldByCurrentThread();
    }

    static final class AccessorNodes
    extends Accessor {
        AccessorNodes() {
        }

        @Override
        protected void onLoopCount(Node source, int iterations) {
            super.onLoopCount(source, iterations);
        }

        @Override
        protected Accessor.EngineSupport engineSupport() {
            return super.engineSupport();
        }

        @Override
        protected Accessor.Nodes nodes() {
            return new AccessNodes();
        }

        @Override
        protected Accessor.LanguageSupport languageSupport() {
            return super.languageSupport();
        }

        @Override
        protected Accessor.DumpSupport dumpSupport() {
            return super.dumpSupport();
        }

        @Override
        protected Accessor.InstrumentSupport instrumentSupport() {
            return super.instrumentSupport();
        }

        static final class AccessNodes
        extends Accessor.Nodes {
            AccessNodes() {
            }

            @Override
            public boolean isInstrumentable(RootNode rootNode) {
                return rootNode.isInstrumentable();
            }

            @Override
            public boolean isTaggedWith(Node node, Class<?> tag) {
                return node.isTaggedWith(tag);
            }

            @Override
            public boolean isCloneUninitializedSupported(RootNode rootNode) {
                return rootNode.isCloneUninitializedSupported();
            }

            @Override
            public RootNode cloneUninitialized(RootNode rootNode) {
                return rootNode.cloneUninitialized();
            }

            @Override
            public int adoptChildrenAndCount(RootNode rootNode) {
                return rootNode.adoptChildrenAndCount();
            }

            @Override
            public Object getEngineObject(LanguageInfo languageInfo) {
                return languageInfo.getEngineObject();
            }

            @Override
            public TruffleLanguage<?> getLanguageSpi(LanguageInfo languageInfo) {
                return languageInfo.getSpi();
            }

            @Override
            public void setLanguageSpi(LanguageInfo languageInfo, TruffleLanguage<?> spi) {
                languageInfo.setSpi(spi);
            }

            @Override
            public LanguageInfo createLanguage(Object vmObject, String id, String name, String version, Set<String> mimeTypes, boolean internal) {
                return new LanguageInfo(vmObject, id, name, version, mimeTypes, internal);
            }

            @Override
            public Object getSourceVM(RootNode rootNode) {
                return rootNode.sourceVM;
            }

            @Override
            public int getRootNodeBits(RootNode root) {
                return root.instrumentationBits;
            }

            @Override
            public void setRootNodeBits(RootNode root, int bits) {
                assert ((byte)bits == bits) : "root bits currently limit to a byte";
                root.instrumentationBits = (byte)bits;
            }

            @Override
            public Lock getLock(Node node) {
                return node.getLock();
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Child {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Children {
    }
}

